name     "Stack Cutting"
describe "Push sensitive Win32 API calls through a stack-cutting call proxy."
author   "Raphael Mudge"

x86:
	# load our x86 .o file AND turn it into position-independent code
	load "bin/loader.x86.o"
		# +gofirst moves go() to position 0 of our PIC
		make pic +gofirst +optimize

		# OPT into x86 program fixes to allow data references without code hacks
		fixptrs "_caller"

		# OPT into PIC dynamic function resolution
		dfr "_resolve" "ror13"

		# merge the Tradecraft Garden Library into our PIC
		mergelib "../libtcg/libtcg.x86.zip"

		# load our DLL argument AND link it into our PIC as my_data section
		push $DLL
			link "my_data"

		# load our free() object
		load "bin/free.x86.o"
			make object
			export
			link "my_free"

		# load our proxy PIC as a resource.
		load "bin/proxy.x86.o"
			# This is PIC but we're not bothering with dfr, fixptrs, and +gofirst. It's not needed here. This PIC is a
			# simple one-off call gate function.
			make pic
			export
			preplen
			link "my_proxy"

		# setup our hooks too
		load "bin/hook.x86.o"
			make object
			import "LoadLibraryA, GetProcAddress, CallProxy, SpoofReturnAddr, SpoofFrameAddr"
			export
			link "my_hooks"

		# we're done, export the final blob
		export

x64:
	load "bin/loader.x64.o"
		make pic +gofirst +optimize

		dfr "resolve" "ror13"
		mergelib "../libtcg/libtcg.x64.zip"

		push $DLL
			link "my_data"

		load "bin/free.x64.o"
			make object
			export
			link "my_free"

		load "bin/proxy.x64.o"
			make pic64
			export
			preplen
			link "my_proxy"

		load "bin/hook.x64.o"
			make object
			import "LoadLibraryA, GetProcAddress, CallProxy, SpoofReturnAddr, SpoofFrameAddr"
			export
			link "my_hooks"

		export
