# some meta-info about our capability
name     "PageStream rDLL"
describe "Use VEHs and guard pages to limit DLL visibility in eXecutable memory"
author   "Raphael Mudge"

x86:
	# load our x86 .o file AND turn it into position-independent code
	load "bin/loader.x86.o"
		# +gofirst moves go() to position 0 of our PIC
		make pic +gofirst +optimize

		# OPT into x86 program fixes to allow data references without code hacks
		fixptrs "_caller"

		# OPT into PIC dynamic function resolution
		dfr "_resolve" "ror13"

		# merge the Tradecraft Garden Library into our PIC
		mergelib "../libtcg/libtcg.x86.zip"

		# generate a 16b XOR key for our obfuscated pages
		generate $KEY 16

		# load our guardexec() PICO
		load "bin/guardexec.x86.o"
			make object +optimize

			# merge the Tradecraft Garden Library into our PICO, +optimize means we're
			# only keeping the functions we use, so it's all right
			mergelib "../libtcg/libtcg.x86.zip"

			# patch that key into our PICO
			patch "_xorkey" $KEY

			export
			link "my_bof"
	
		# load our Reflective DLL argument AND link it into our PICO as my_data section.
		push $DLL
			link "my_data"

		# we're done, export the final blob
		export

x64:
	load "bin/loader.x64.o"
		make pic +gofirst +optimize

		dfr "resolve" "ror13"
		mergelib "../libtcg/libtcg.x64.zip"

		generate $KEY 16

		load "bin/guardexec.x64.o"
			make object +optimize
			mergelib "../libtcg/libtcg.x64.zip"
			patch "xorkey" $KEY
			export
			link "my_bof"

		push $DLL
			link "my_data"

		export
