/*
 * Copyright 2025 Raphael Mudge, Adversary Fan Fiction Writers Guild
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <windows.h>
#include "proxy.h"

/*
 * A NOTE ABOUT SYMBOLS
 * --------------------
 *
 * This PICO imports several symbols that were passed to PicoLoad() as extensions to the
 * IMPORTFUNCS struct. The import command, in loader.spec, is where these extended fields
 * are mapped to the function symbols in this program. You'll see them throughout this code:
 *
 * load "bin/hook.x64.o"
 * 	make object
 *	import "LoadLibraryA, GetProcAddress, VirtualAlloc, VirtualProtect, CallProxy, SpoofReturnAddr, SpoofFrameAddr"
 *
 * I'm being a little abusive to my system, using SpoofReturnAddr and SpoofFrameAddr functions
 * to import pointers from that same struct. I could have passed them to go()  and assigned them
 * to global vars, but didn't feel like going that route.
 */

typedef struct {
	__typeof__(LoadLibraryA)   * LoadLibraryA;
	__typeof__(GetProcAddress) * GetProcAddress;
} IMPORTFUNCS;

WINBASEAPI VOID WINAPI KERNEL32$Sleep (DWORD dwMilliseconds);
WINUSERAPI int  WINAPI USER32$MessageBoxA(HWND hWnd,LPCSTR lpText,LPCSTR lpCaption,UINT uType);

/*
 * Some functions to aid with our call proxying
 */
DECLSPEC_IMPORT void      SpoofReturnAddr();		/* pointer to our original ReturnAddress */
DECLSPEC_IMPORT void      SpoofFrameAddr();		/* pointer to our original FramePointer */
DECLSPEC_IMPORT ULONG_PTR CallProxy(PROXYCALL * desc);  /* our Proxy PIC--where-ever it's installed */

/*
 * Using this as a global, to keep it in our heap memory, and off the stack.
 */
PROXYCALL call;

ULONG_PTR proxy(int argc) {
	call.argc              = argc;
	call.spoofme.retaddr   = (ULONG_PTR)SpoofReturnAddr;
	call.spoofme.frameaddr = (ULONG_PTR)SpoofFrameAddr;

	return CallProxy(&call);
}

/*
 * Our hooked functions that do what we want...
 */
HMODULE WINAPI _LoadLibraryA (LPCSTR lpLibFileName) {
	call.function = (ULONG_PTR)LoadLibraryA;
	call.args[0]  = (ULONG_PTR)lpLibFileName;

	return (HMODULE)proxy(1);
}

int WINAPI _MessageBoxA(HWND hWnd,LPCSTR lpText,LPCSTR lpCaption,UINT uType) {
	call.function = (ULONG_PTR)USER32$MessageBoxA;
	call.args[0]  = (ULONG_PTR)hWnd;
	call.args[1]  = (ULONG_PTR)lpText;
	call.args[2]  = (ULONG_PTR)lpCaption;
	call.args[3]  = (ULONG_PTR)uType;

	return (int)proxy(4);
}

VOID WINAPI _Sleep (DWORD dwMilliseconds) {
	call.function = (ULONG_PTR)KERNEL32$Sleep;
	call.args[0]  = (ULONG_PTR)dwMilliseconds;

	proxy(1);
}

LPVOID WINAPI _VirtualAlloc (LPVOID lpAddress, SIZE_T dwSize, DWORD flAllocationType, DWORD flProtect) {
	call.function = (ULONG_PTR)VirtualAlloc;
	call.args[0]  = (ULONG_PTR)lpAddress;
	call.args[1]  = (ULONG_PTR)dwSize;
	call.args[2]  = (ULONG_PTR)flAllocationType;
	call.args[3]  = (ULONG_PTR)flProtect;

	return (LPVOID)proxy(4);
}

WINBOOL WINAPI _VirtualProtect (LPVOID lpAddress, SIZE_T dwSize, DWORD flNewProtect, PDWORD lpflOldProtect) {
	call.function = (ULONG_PTR)VirtualProtect;
	call.args[0]  = (ULONG_PTR)lpAddress;
	call.args[1]  = (ULONG_PTR)dwSize;
	call.args[2]  = (ULONG_PTR)flNewProtect;
	call.args[3]  = (ULONG_PTR)lpflOldProtect;

	return (WINBOOL)proxy(4);
}

/*
 * This is the GetProcAddress our loader will use. It's a chance for us to hook things. Notice, we also use
 * this to replace any other references to GetProcAddress with our hook function too. In this way, for the
 * things our DLL does... everything will use this GetProcAddress giving us nice visibility into follow-on stuff
 */
char * WINAPI _GetProcAddress(HMODULE hModule, LPCSTR lpProcName) {
	char * result = (char *)GetProcAddress(hModule, lpProcName);

	if ((char *)GetProcAddress == result) {
		return (char *)_GetProcAddress;
	}
	else if ((char *)LoadLibraryA == result) {
		return (char *)_LoadLibraryA;
	}
	else if ((char *)VirtualAlloc == result) {
		return (char *)_VirtualAlloc;
	}
	else if ((char *)VirtualProtect == result) {
		return (char *)_VirtualProtect;
	}
	else if ((char *)KERNEL32$Sleep == result) {
		return (char *)_Sleep;
	}
	/* Note: this reference will LoadLibraryA("USER32") before our hooks are installed. */
	else if ((char *)USER32$MessageBoxA == result) {
		return (char *)_MessageBoxA;
	}

	return result;
}

/* Our entry point and our initialization for everything fun that will happen... */
void go(IMPORTFUNCS * funcs) {
	/* update the functions our loader will use for follow-on purposes (e.g., loading
	 * our final DLL, loading the free and run PICO, etc.). This gives us a chance to
	 * install our hooks into these codes. */
	funcs->LoadLibraryA   = (__typeof__(LoadLibraryA)   *)_LoadLibraryA;
	funcs->GetProcAddress = (__typeof__(GetProcAddress) *)_GetProcAddress;
}
