name     "Simple Loader (Pointer Patching)"
describe "Simple Loader that bootstraps with user-provided GetModuleHandle and GetProcAddress pointers"
author   "Raphael Mudge"

x86:
	# load our x86 .o file AND turn it into position-independent code
	load "bin/loader.x86.o"
		make pic

		# For our x86 PIC, we're going to add our pointers and access them the same
		# as other appended resources. Nothing too special here.
		#
		# $GMH is GetModuleHandle, $GPA is GetProcAddress
		#
		# We *could* follow this approach for x64 too, but if we're x64-only, there's
		# a much much easier way.
		push $GMH
			link "gmh_data"

		push $GPA
			link "gpa_data"

		# load our DLL argument AND link it into our PIC as my_data section
		push $DLL
			link "my_data"
	
		# we're done, export the final blob
		export

x64:
	load "bin/loader.x64.o"
		# adds an .rdata section to our PIC; allowing us to use strings!
		make pic64

		# For x64 PIC, this is that much much easier way. Just patch our data into these
		# global variables that live inside of the .text section. Super easy to work with.
		patch "pGetModuleHandle" $GMH
		patch "pGetProcAddress"  $GPA

		push $DLL
			link "my_data"
	
		export
