name     "Simple Loader (Hooking)"
describe "Simple DLL loader that masks DLL content when MessageBoxA called"
author   "Raphael Mudge"

x86:
	# load our x86 .o file AND turn it into position-independent code
	load "bin/loader.x86.o"
		make pic

		# resolve a function pointer for go with a relative address
		reladdr "_go"

		# load our Reflective DLL argument AND link it into our PIC as my_data section
		push $DLL
			link "my_data"

		# load our free() PICO
		load "bin/free.x86.o"
			make object
			export
			link "my_bof"

		# generate a 128B key for our hook module
		generate $HKEY 128

		# load our hook PICO
		load "bin/hook.x86.o"
			make object

			# patch that key into our PICO
			patch "_xorkey" $HKEY

			# export and link it
			export
			link "my_hooks"
	
		# we're done, export the final blob
		export

x64:
	load "bin/loader.x64.o"
		make pic

		push $DLL
			link "my_data"

		load "bin/free.x64.o"
			make object
			export
			link "my_bof"

		generate $HKEY 128

		load "bin/hook.x64.o"
			make object
			patch "xorkey" $HKEY
			export
			link "my_hooks"
	
		export
