#
# Simple COFF Loader build spec
#

x86:
	# load our x86 .o file AND turn it into position-independent code
	load "bin/loader.x86.o"
		# +optimize shines here, because we need only some parts our RDLL loader 
		# (to resolve Win32 APIs for example)
		make pic +optimize

		# load our COFF argument AND link it into our PIC as my_data section
		push $OBJECT
			make object +optimize
			export
			link "my_data"

		# this is OPTIONAL, it will dump the disassembled loader.x86.o to out.txt
		disassemble "out.txt"

		# we're done, export the final blob
		export

x64:
	load "bin/loader.x64.o"
		make pic +optimize

		push $OBJECT
			make object +optimize
			export
			link "my_data"

		disassemble "out.txt"

		export
