# some meta-info about our capability
name     "PageStream rDLL"
describe "Use VEHs and guard pages to limit DLL visibility in eXecutable memory"
author   "Raphael Mudge"

x86:
	# load our x86 .o file AND turn it into position-independent code
	load "bin/loader.x86.o"
		make pic

		# resolve a function pointer for go with a relative address
		reladdr "_go"

		# generate a 16b XOR key for our obfuscated pages
		generate $KEY 16

		# load our guardexec() PICO
		load "bin/guardexec.x86.o"
			make object

			# patch that key into our PICO
			patch "_xorkey" $KEY

			export
			link "my_bof"
	
		# load our Reflective DLL argument AND link it into our PICO as my_data section.
		push $DLL
			link "my_data"

		# we're done, export the final blob
		export

x64:
	load "bin/loader.x64.o"
		make pic

		generate $KEY 16

		load "bin/guardexec.x64.o"
			make object
			patch "xorkey" $KEY
			export
			link "my_bof"

		push $DLL
			link "my_data"

		export
