/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.info;

import com.github.icedland.iced.x86.Code;
import com.github.icedland.iced.x86.info.InstructionFormatter;
import com.github.icedland.iced.x86.info.OpCodeFormatter;
import com.github.icedland.iced.x86.info.OpCodeOperandKinds;
import com.github.icedland.iced.x86.internal.InstructionMemorySizes;
import com.github.icedland.iced.x86.internal.InstructionOpCounts;
import com.github.icedland.iced.x86.internal.MvexInfo;

public final class OpCodeInfo {
    private final String toOpCodeStringValue;
    private final String toInstructionStringValue;
    private final int encFlags2;
    private final int encFlags3;
    private final int opcFlags1;
    private final int opcFlags2;
    private final int code;
    private final byte encoding;
    private final byte operandSize;
    private final byte addressSize;
    private final byte l;
    private final byte tupleType;
    private final byte table;
    private final byte mandatoryPrefix;
    private final byte groupIndex;
    private final byte rmGroupIndex;
    private final byte op0Kind;
    private final byte op1Kind;
    private final byte op2Kind;
    private final byte op3Kind;
    private final byte op4Kind;
    private final int flags;
    private static final int[] toDecoderOptions = new int[]{0, 0x800000, 1024, 32, 0x100000, 0x400000, 0x200000, 4096, 256, 512, 2048, 524288, 64, 128, 8, 16, 32768, 0x1000000};

    OpCodeInfo(int code, int encFlags1, int encFlags2, int encFlags3, int opcFlags1, int opcFlags2, StringBuilder sb, String[] mnemonics) {
        int lkind;
        this.code = code;
        this.encFlags2 = encFlags2;
        this.encFlags3 = encFlags3;
        this.opcFlags1 = opcFlags1;
        this.opcFlags2 = opcFlags2;
        int flagsTmp = 0;
        if ((encFlags1 & 0x40000000) != 0) {
            flagsTmp |= 1;
        }
        if ((encFlags1 & Integer.MIN_VALUE) != 0) {
            flagsTmp |= 2;
        }
        switch (opcFlags1 & 3) {
            case 1: {
                flagsTmp |= 0x40;
                break;
            }
            case 2: {
                flagsTmp |= 0x200;
                break;
            }
            default: {
                flagsTmp |= 0x3C0;
            }
        }
        this.encoding = (byte)(encFlags3 >>> 0 & 7);
        switch (encFlags2 >>> 20 & 3) {
            case 0: {
                this.mandatoryPrefix = (byte)((encFlags2 & 0x40000000) != 0 ? 1 : 0);
                break;
            }
            case 1: {
                this.mandatoryPrefix = (byte)2;
                break;
            }
            case 2: {
                this.mandatoryPrefix = (byte)3;
                break;
            }
            case 3: {
                this.mandatoryPrefix = (byte)4;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (encFlags3 >>> 3 & 3) {
            case 0: {
                this.operandSize = 0;
                break;
            }
            case 1: {
                this.operandSize = (byte)16;
                break;
            }
            case 2: {
                this.operandSize = (byte)32;
                break;
            }
            case 3: {
                this.operandSize = (byte)64;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (encFlags3 >>> 5 & 3) {
            case 0: {
                this.addressSize = 0;
                break;
            }
            case 1: {
                this.addressSize = (byte)16;
                break;
            }
            case 2: {
                this.addressSize = (byte)32;
                break;
            }
            case 3: {
                this.addressSize = (byte)64;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.groupIndex = (byte)((encFlags2 & Integer.MIN_VALUE) == 0 ? -1 : encFlags2 >>> 27 & 7);
        this.rmGroupIndex = (byte)((encFlags3 & 0x2000) == 0 ? -1 : encFlags2 >>> 27 & 7);
        this.tupleType = (byte)(encFlags3 >>> 7 & 0x1F);
        switch (encFlags2 >>> 24 & 7) {
            case 3: {
                lkind = 3;
                this.l = 0;
                break;
            }
            case 0: {
                lkind = 2;
                this.l = 0;
                break;
            }
            case 1: {
                lkind = 2;
                this.l = 1;
                break;
            }
            case 4: {
                lkind = 1;
                this.l = 0;
                break;
            }
            case 5: {
                lkind = 1;
                this.l = 1;
                break;
            }
            case 6: {
                lkind = 1;
                this.l = (byte)2;
                break;
            }
            case 2: {
                lkind = 0;
                this.l = 0;
                flagsTmp |= 4;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (encFlags2 >>> 22 & 3) {
            case 0: {
                break;
            }
            case 1: {
                flagsTmp |= 8;
                break;
            }
            case 2: {
                flagsTmp |= 0x10;
                break;
            }
            case 3: {
                flagsTmp |= 0x20;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        block37 : switch (this.encoding) {
            case 0: {
                byte[] opKinds = OpCodeOperandKinds.legacyOpKinds;
                this.op0Kind = opKinds[encFlags1 >>> 0 & 0x7F];
                this.op1Kind = opKinds[encFlags1 >>> 7 & 0x7F];
                this.op2Kind = opKinds[encFlags1 >>> 14 & 0x7F];
                this.op3Kind = opKinds[encFlags1 >>> 21 & 0x7F];
                this.op4Kind = 0;
                switch (encFlags2 >>> 17 & 7) {
                    case 0: {
                        this.table = 0;
                        break block37;
                    }
                    case 1: {
                        this.table = 1;
                        break block37;
                    }
                    case 2: {
                        this.table = (byte)2;
                        break block37;
                    }
                    case 3: {
                        this.table = (byte)3;
                        break block37;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 1: {
                byte[] opKinds = OpCodeOperandKinds.vexOpKinds;
                this.op0Kind = opKinds[encFlags1 >>> 0 & 0x3F];
                this.op1Kind = opKinds[encFlags1 >>> 6 & 0x3F];
                this.op2Kind = opKinds[encFlags1 >>> 12 & 0x3F];
                this.op3Kind = opKinds[encFlags1 >>> 18 & 0x3F];
                this.op4Kind = opKinds[encFlags1 >>> 24 & 0x3F];
                switch (encFlags2 >>> 17 & 7) {
                    case 0: {
                        this.table = 0;
                        break block37;
                    }
                    case 1: {
                        this.table = 1;
                        break block37;
                    }
                    case 2: {
                        this.table = (byte)2;
                        break block37;
                    }
                    case 3: {
                        this.table = (byte)3;
                        break block37;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 2: {
                byte[] opKinds = OpCodeOperandKinds.evexOpKinds;
                this.op0Kind = opKinds[encFlags1 >>> 0 & 0x1F];
                this.op1Kind = opKinds[encFlags1 >>> 5 & 0x1F];
                this.op2Kind = opKinds[encFlags1 >>> 10 & 0x1F];
                this.op3Kind = opKinds[encFlags1 >>> 15 & 0x1F];
                this.op4Kind = 0;
                switch (encFlags2 >>> 17 & 7) {
                    case 1: {
                        this.table = 1;
                        break block37;
                    }
                    case 2: {
                        this.table = (byte)2;
                        break block37;
                    }
                    case 3: {
                        this.table = (byte)3;
                        break block37;
                    }
                    case 5: {
                        this.table = (byte)4;
                        break block37;
                    }
                    case 6: {
                        this.table = (byte)5;
                        break block37;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 3: {
                byte[] opKinds = OpCodeOperandKinds.xopOpKinds;
                this.op0Kind = opKinds[encFlags1 >>> 0 & 0x1F];
                this.op1Kind = opKinds[encFlags1 >>> 5 & 0x1F];
                this.op2Kind = opKinds[encFlags1 >>> 10 & 0x1F];
                this.op3Kind = opKinds[encFlags1 >>> 15 & 0x1F];
                this.op4Kind = 0;
                switch (encFlags2 >>> 17 & 7) {
                    case 0: {
                        this.table = (byte)6;
                        break block37;
                    }
                    case 1: {
                        this.table = (byte)7;
                        break block37;
                    }
                    case 2: {
                        this.table = (byte)8;
                        break block37;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 4: {
                this.op0Kind = (byte)46;
                this.op1Kind = (byte)19;
                this.op2Kind = 0;
                this.op3Kind = 0;
                this.op4Kind = 0;
                this.table = 1;
                break;
            }
            case 5: {
                byte[] opKinds = OpCodeOperandKinds.mvexOpKinds;
                this.op0Kind = opKinds[encFlags1 >>> 0 & 0xF];
                this.op1Kind = opKinds[encFlags1 >>> 4 & 0xF];
                this.op2Kind = opKinds[encFlags1 >>> 8 & 0xF];
                this.op3Kind = opKinds[encFlags1 >>> 12 & 0xF];
                this.op4Kind = 0;
                switch (encFlags2 >>> 17 & 7) {
                    case 1: {
                        this.table = 1;
                        break block37;
                    }
                    case 2: {
                        this.table = (byte)2;
                        break block37;
                    }
                    case 3: {
                        this.table = (byte)3;
                        break block37;
                    }
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.flags = flagsTmp;
        this.toOpCodeStringValue = new OpCodeFormatter(this, sb, lkind, (opcFlags1 & 0x100000) != 0).format();
        int fmtOption = opcFlags2 >>> 29 & 7;
        this.toInstructionStringValue = new InstructionFormatter(this, fmtOption, sb, mnemonics).format();
    }

    public int getCode() {
        return this.code;
    }

    public int getMnemonic() {
        return Code.mnemonic(this.getCode());
    }

    public int getEncoding() {
        return this.encoding;
    }

    public boolean isInstruction() {
        return this.code > 4 && this.code != 4833;
    }

    public boolean getMode16() {
        return (this.encFlags3 & 0x10000) != 0;
    }

    public boolean getMode32() {
        return (this.encFlags3 & 0x10000) != 0;
    }

    public boolean getMode64() {
        return (this.encFlags3 & 0x20000) != 0;
    }

    public boolean getFwait() {
        return (this.encFlags3 & 0x8000) != 0;
    }

    public int getOperandSize() {
        return this.operandSize;
    }

    public int getAddressSize() {
        return this.addressSize;
    }

    public int getL() {
        return this.l;
    }

    public int getW() {
        return (this.flags & 8) != 0 ? 1 : 0;
    }

    public boolean isLIG() {
        return (this.flags & 4) != 0;
    }

    public boolean isWIG() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isWIG32() {
        return (this.flags & 0x20) != 0;
    }

    public int getTupleType() {
        return this.tupleType;
    }

    public int getMvexEHBit() {
        return this.getEncoding() == 5 ? MvexInfo.getEHBit(this.getCode()) : 0;
    }

    public boolean getMvexCanUseEvictionHint() {
        return this.getEncoding() == 5 && MvexInfo.canUseEvictionHint(this.getCode());
    }

    public boolean getMvexCanUseImmRoundingControl() {
        return this.getEncoding() == 5 && MvexInfo.canUseImmRoundingControl(this.getCode());
    }

    public boolean getMvexIgnoresOpMaskRegister() {
        return this.getEncoding() == 5 && MvexInfo.getIgnoresOpMaskRegister(this.getCode());
    }

    public boolean getMvexNoSaeRc() {
        return this.getEncoding() == 5 && MvexInfo.getNoSaeRc(this.getCode());
    }

    public int getMvexTupleTypeLutKind() {
        return this.getEncoding() == 5 ? MvexInfo.getTupleTypeLutKind(this.getCode()) : 0;
    }

    public int getMvexConversionFunc() {
        return this.getEncoding() == 5 ? MvexInfo.getConvFn(this.getCode()) : 0;
    }

    public int getMvexValidConversionFuncsMask() {
        return this.getEncoding() == 5 ? ~MvexInfo.getInvalidConvFns(this.getCode()) : 0;
    }

    public int getMvexValidSwizzleFuncsMask() {
        return this.getEncoding() == 5 ? ~MvexInfo.getInvalidSwizzleFns(this.getCode()) : 0;
    }

    public int getMemorySize() {
        return InstructionMemorySizes.sizesNormal[this.code] & 0xFF;
    }

    public int getBroadcastMemorySize() {
        return InstructionMemorySizes.sizesBcst[this.code] & 0xFF;
    }

    public boolean canBroadcast() {
        return (this.encFlags3 & 0x4000000) != 0;
    }

    public boolean canUseRoundingControl() {
        return (this.encFlags3 & 0x8000000) != 0;
    }

    public boolean canSuppressAllExceptions() {
        return (this.encFlags3 & 0x10000000) != 0;
    }

    public boolean canUseOpMaskRegister() {
        return (this.encFlags3 & 0x20000000) != 0;
    }

    public boolean getRequireOpMaskRegister() {
        return (this.encFlags3 & Integer.MIN_VALUE) != 0;
    }

    public boolean canUseZeroingMasking() {
        return (this.encFlags3 & 0x40000000) != 0;
    }

    public boolean canUseLockPrefix() {
        return (this.encFlags3 & 0x40000) != 0;
    }

    public boolean canUseXacquirePrefix() {
        return (this.encFlags3 & 0x80000) != 0;
    }

    public boolean canUseXreleasePrefix() {
        return (this.encFlags3 & 0x100000) != 0;
    }

    public boolean canUseRepPrefix() {
        return (this.encFlags3 & 0x200000) != 0;
    }

    public boolean canUseRepnePrefix() {
        return (this.encFlags3 & 0x400000) != 0;
    }

    public boolean canUseBndPrefix() {
        return (this.encFlags3 & 0x800000) != 0;
    }

    public boolean canUseHintTakenPrefix() {
        return (this.encFlags3 & 0x1000000) != 0;
    }

    public boolean canUseNotrackPrefix() {
        return (this.encFlags3 & 0x2000000) != 0;
    }

    public boolean getIgnoresRoundingControl() {
        return (this.flags & 1) != 0;
    }

    public boolean getAmdLockRegBit() {
        return (this.flags & 2) != 0;
    }

    public boolean getDefaultOpSize64() {
        return (this.encFlags3 & 0x1000) != 0;
    }

    public boolean getForceOpSize64() {
        return (this.opcFlags1 & 0x40000000) != 0;
    }

    public boolean getIntelForceOpSize64() {
        return (this.encFlags3 & 0x4000) != 0;
    }

    public boolean getMustBeCpl0() {
        return (this.flags & 0x3C0) == 64;
    }

    public boolean getCpl0() {
        return (this.flags & 0x40) != 0;
    }

    public boolean getCpl1() {
        return (this.flags & 0x80) != 0;
    }

    public boolean getCpl2() {
        return (this.flags & 0x100) != 0;
    }

    public boolean getCpl3() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isInputOutput() {
        return (this.opcFlags1 & 4) != 0;
    }

    public boolean isNop() {
        return (this.opcFlags1 & 8) != 0;
    }

    public boolean isReservedNop() {
        return (this.opcFlags1 & 0x10) != 0;
    }

    public boolean isSerializingIntel() {
        return (this.opcFlags1 & 0x20) != 0;
    }

    public boolean isSerializingAmd() {
        return (this.opcFlags1 & 0x40) != 0;
    }

    public boolean getMayRequireCpl0() {
        return (this.opcFlags1 & 0x80) != 0;
    }

    public boolean isCetTracked() {
        return (this.opcFlags1 & 0x100) != 0;
    }

    public boolean isNonTemporal() {
        return (this.opcFlags1 & 0x200) != 0;
    }

    public boolean isFpuNoWait() {
        return (this.opcFlags1 & 0x400) != 0;
    }

    public boolean getIgnoresModBits() {
        return (this.opcFlags1 & 0x800) != 0;
    }

    public boolean getNo66() {
        return (this.opcFlags1 & 0x1000) != 0;
    }

    public boolean getNFx() {
        return (this.opcFlags1 & 0x2000) != 0;
    }

    public boolean getRequiresUniqueRegNums() {
        return (this.opcFlags1 & 0x4000) != 0;
    }

    public boolean getRequiresUniqueDestRegNum() {
        return (this.opcFlags1 & Integer.MIN_VALUE) != 0;
    }

    public boolean isPrivileged() {
        return (this.opcFlags1 & 0x8000) != 0;
    }

    public boolean isSaveRestore() {
        return (this.opcFlags1 & 0x10000) != 0;
    }

    public boolean isStackInstruction() {
        return (this.opcFlags1 & 0x20000) != 0;
    }

    public boolean getIgnoresSegment() {
        return (this.opcFlags1 & 0x40000) != 0;
    }

    public boolean isOpMaskReadWrite() {
        return (this.opcFlags1 & 0x80000) != 0;
    }

    public boolean getRealMode() {
        return (this.opcFlags2 & 1) != 0;
    }

    public boolean getProtectedMode() {
        return (this.opcFlags2 & 2) != 0;
    }

    public boolean getVirtual8086Mode() {
        return (this.opcFlags2 & 4) != 0;
    }

    public boolean getCompatibilityMode() {
        return (this.opcFlags2 & 8) != 0;
    }

    public boolean getLongMode() {
        return (this.encFlags3 & 0x20000) != 0;
    }

    public boolean getUseOutsideSmm() {
        return (this.opcFlags2 & 0x10) != 0;
    }

    public boolean getUseInSmm() {
        return (this.opcFlags2 & 0x20) != 0;
    }

    public boolean getUseOutsideEnclaveSgx() {
        return (this.opcFlags2 & 0x40) != 0;
    }

    public boolean getUseInEnclaveSgx1() {
        return (this.opcFlags2 & 0x80) != 0;
    }

    public boolean getUseInEnclaveSgx2() {
        return (this.opcFlags2 & 0x100) != 0;
    }

    public boolean getUseOutsideVmxOp() {
        return (this.opcFlags2 & 0x200) != 0;
    }

    public boolean getUseInVmxRootOp() {
        return (this.opcFlags2 & 0x400) != 0;
    }

    public boolean getUseInVmxNonRootOp() {
        return (this.opcFlags2 & 0x800) != 0;
    }

    public boolean getUseOutsideSeam() {
        return (this.opcFlags2 & 0x1000) != 0;
    }

    public boolean getUseInSeam() {
        return (this.opcFlags2 & 0x2000) != 0;
    }

    public boolean getTdxNonRootGenUd() {
        return (this.opcFlags2 & 0x4000) != 0;
    }

    public boolean getTdxNonRootGenVe() {
        return (this.opcFlags2 & 0x8000) != 0;
    }

    public boolean getTdxNonRootMayGenEx() {
        return (this.opcFlags2 & 0x10000) != 0;
    }

    public boolean getIntelVmExit() {
        return (this.opcFlags2 & 0x20000) != 0;
    }

    public boolean getIntelMayVmExit() {
        return (this.opcFlags2 & 0x40000) != 0;
    }

    public boolean getIntelSmmVmExit() {
        return (this.opcFlags2 & 0x80000) != 0;
    }

    public boolean getAmdVmExit() {
        return (this.opcFlags2 & 0x100000) != 0;
    }

    public boolean getAmdMayVmExit() {
        return (this.opcFlags2 & 0x200000) != 0;
    }

    public boolean getTsxAbort() {
        return (this.opcFlags2 & 0x400000) != 0;
    }

    public boolean getTsxImplAbort() {
        return (this.opcFlags2 & 0x800000) != 0;
    }

    public boolean getTsxMayAbort() {
        return (this.opcFlags2 & 0x1000000) != 0;
    }

    public boolean getIntelDecoder16() {
        return (this.opcFlags2 & 0x2000000) != 0;
    }

    public boolean getIntelDecoder32() {
        return (this.opcFlags2 & 0x2000000) != 0;
    }

    public boolean getIntelDecoder64() {
        return (this.opcFlags2 & 0x4000000) != 0;
    }

    public boolean getAmdDecoder16() {
        return (this.opcFlags2 & 0x8000000) != 0;
    }

    public boolean getAmdDecoder32() {
        return (this.opcFlags2 & 0x8000000) != 0;
    }

    public boolean getAmdDecoder64() {
        return (this.opcFlags2 & 0x10000000) != 0;
    }

    public int getDecoderOption() {
        return toDecoderOptions[this.opcFlags1 >>> 21 & 0x1F];
    }

    public int getTable() {
        return this.table;
    }

    public int getMandatoryPrefix() {
        return this.mandatoryPrefix;
    }

    public int getOpCode() {
        return this.encFlags2 >>> 0 & 0xFFFF;
    }

    public int getOpCodeLength() {
        return (this.encFlags2 & 0x10000) != 0 ? 2 : 1;
    }

    public boolean isGroup() {
        return this.groupIndex >= 0;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public boolean isRmGroup() {
        return this.rmGroupIndex >= 0;
    }

    public int getRmGroupIndex() {
        return this.rmGroupIndex;
    }

    public int getOpCount() {
        return InstructionOpCounts.opCount[this.code];
    }

    public int getOp0Kind() {
        return this.op0Kind;
    }

    public int getOp1Kind() {
        return this.op1Kind;
    }

    public int getOp2Kind() {
        return this.op2Kind;
    }

    public int getOp3Kind() {
        return this.op3Kind;
    }

    public int getOp4Kind() {
        return this.op4Kind;
    }

    public int getOpKind(int operand) {
        switch (operand) {
            case 0: {
                return this.getOp0Kind();
            }
            case 1: {
                return this.getOp1Kind();
            }
            case 2: {
                return this.getOp2Kind();
            }
            case 3: {
                return this.getOp3Kind();
            }
            case 4: {
                return this.getOp4Kind();
            }
        }
        throw new IllegalArgumentException("operand");
    }

    public boolean isAvailableInMode(int bitness) {
        switch (bitness) {
            case 16: {
                return this.getMode16();
            }
            case 32: {
                return this.getMode32();
            }
            case 64: {
                return this.getMode64();
            }
        }
        throw new IllegalArgumentException("bitness");
    }

    public String toOpCodeString() {
        return this.toOpCodeStringValue;
    }

    public String toInstructionString() {
        return this.toInstructionStringValue;
    }

    public String toString() {
        return this.toInstructionString();
    }

    private static final class Flags {
        static final int IGNORES_ROUNDING_CONTROL = 1;
        static final int AMD_LOCK_REG_BIT = 2;
        static final int LIG = 4;
        static final int W = 8;
        static final int WIG = 16;
        static final int WIG32 = 32;
        static final int CPL0 = 64;
        static final int CPL1 = 128;
        static final int CPL2 = 256;
        static final int CPL3 = 512;

        private Flags() {
        }
    }
}

