/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.MnemonicCC;

final class SimpleInstrInfo_os_loop
extends InstrInfo {
    private final int bitness;
    private final int ccIndex;
    private final int register;
    private final FormatterString[] mnemonics;

    SimpleInstrInfo_os_loop(int bitness, int ccIndex, int register, String[] mnemonics) {
        this.bitness = bitness;
        this.ccIndex = ccIndex;
        this.register = register;
        this.mnemonics = FormatterString.create(mnemonics);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        boolean addReg;
        int expectedReg;
        int flags = 0;
        int instrBitness = SimpleInstrInfo_os_loop.getBitness(instruction.getCodeSize());
        switch (instrBitness) {
            case 0: {
                expectedReg = this.register;
                break;
            }
            case 16: {
                expectedReg = 22;
                break;
            }
            case 32: {
                expectedReg = 38;
                break;
            }
            case 64: {
                expectedReg = 54;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean bl = addReg = expectedReg != this.register;
        if (instrBitness != 0 && instrBitness != this.bitness) {
            flags = this.bitness == 16 ? (flags |= 8) : (this.bitness == 32 ? (flags |= 0x10) : (flags |= 0x18));
        }
        FormatterString mnemonic = this.ccIndex == -1 ? this.mnemonics[0] : MnemonicCC.getMnemonicCC(options, this.ccIndex, this.mnemonics);
        InstrOpInfo info = new InstrOpInfo(mnemonic, instruction, flags);
        if (addReg) {
            assert (info.opCount == 1) : info.opCount;
            info.opCount = (byte)2;
            info.op1Kind = 0;
            info.op1Index = (byte)-7;
            info.op1Register = (byte)this.register;
        }
        return info;
    }
}

