/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_os_call
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;
    private final boolean canHaveBndPrefix;

    SimpleInstrInfo_os_call(int bitness, String mnemonic, boolean canHaveBndPrefix) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
        this.canHaveBndPrefix = canHaveBndPrefix;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int flags = 0;
        if (this.canHaveBndPrefix && instruction.getRepnePrefix()) {
            flags |= 0x40000;
        }
        int instrBitness = SimpleInstrInfo_os_call.getBitness(instruction.getCodeSize());
        int branchInfo = 0;
        if (instrBitness != 0 && instrBitness != this.bitness) {
            if (this.bitness == 16) {
                branchInfo = 4;
            } else if (this.bitness == 32) {
                branchInfo = 5;
            }
        }
        return new InstrOpInfo(this.mnemonic, instruction, flags |= branchInfo << 7);
    }
}

