/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class MemorySizes {
    public static final Info[] allMemorySizes = MemorySizes.getMemorySizes();

    MemorySizes() {
    }

    private static Info[] getMemorySizes() {
        FormatterString byte_ = new FormatterString("byte");
        FormatterString dword = new FormatterString("dword");
        FormatterString far = new FormatterString("far");
        FormatterString fpuenv14 = new FormatterString("fpuenv14");
        FormatterString fpuenv28 = new FormatterString("fpuenv28");
        FormatterString fpustate108 = new FormatterString("fpustate108");
        FormatterString fpustate94 = new FormatterString("fpustate94");
        FormatterString oword = new FormatterString("oword");
        FormatterString qword = new FormatterString("qword");
        FormatterString tword = new FormatterString("tword");
        FormatterString word = new FormatterString("word");
        FormatterString yword = new FormatterString("yword");
        FormatterString zword = new FormatterString("zword");
        FormatterString mem384 = new FormatterString("mem384");
        FormatterString empty = new FormatterString("");
        FormatterString b1to2 = new FormatterString("1to2");
        FormatterString b1to4 = new FormatterString("1to4");
        FormatterString b1to8 = new FormatterString("1to8");
        FormatterString b1to16 = new FormatterString("1to16");
        FormatterString b1to32 = new FormatterString("1to32");
        byte[] bcstToData = new byte[]{1, 1, 1, 2, 1, 3, 3, 2, 2, 1, 1, 1, 3, 2, 1, 2, 1, 1, 2, 2, 4, 4, 3, 3, 2, 2, 2, 4, 3, 2, 3, 2, 2, 3, 3, 5, 5, 4, 4, 3, 3, 3, 5, 4, 3, 4, 4, 3, 3, 4};
        byte[] data = new byte[]{0, 1, 11, 2, 9, 9, 8, 12, 13, 1, 11, 2, 9, 8, 12, 13, 3, 3, 3, 11, 2, 9, 0, 0, 9, 8, 0, 0, 11, 2, 9, 10, 8, 11, 4, 5, 7, 6, 0, 0, 0, 0, 10, 13, 0, 10, 14, 13, 11, 11, 2, 2, 2, 2, 2, 2, 9, 9, 9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 2, 2, 11, 2, 11, 11, 2, 2, 9, 9, 9, 11, 2, 9, 2, 9, 9, 2, 2, 11, 11, 2, 2, 9, 9, 9, 11, 2, 9, 2, 9, 9, 2, 2, 11, 11, 2, 2, 9, 9, 9, 11, 2, 9, 2, 2, 9, 9, 2};
        Info[] infos = new Info[162];
        for (int i = 0; i < infos.length; ++i) {
            FormatterString bcstTo;
            FormatterString keyword;
            int d = data[i] & 0xFF;
            switch (d) {
                case 0: {
                    keyword = empty;
                    break;
                }
                case 1: {
                    keyword = byte_;
                    break;
                }
                case 2: {
                    keyword = dword;
                    break;
                }
                case 3: {
                    keyword = far;
                    break;
                }
                case 4: {
                    keyword = fpuenv14;
                    break;
                }
                case 5: {
                    keyword = fpuenv28;
                    break;
                }
                case 6: {
                    keyword = fpustate108;
                    break;
                }
                case 7: {
                    keyword = fpustate94;
                    break;
                }
                case 8: {
                    keyword = oword;
                    break;
                }
                case 9: {
                    keyword = qword;
                    break;
                }
                case 10: {
                    keyword = tword;
                    break;
                }
                case 11: {
                    keyword = word;
                    break;
                }
                case 12: {
                    keyword = yword;
                    break;
                }
                case 13: {
                    keyword = zword;
                    break;
                }
                case 14: {
                    keyword = mem384;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (i < 112) {
                bcstTo = empty;
            } else {
                switch (bcstToData[i - 112] & 0xFF) {
                    case 0: {
                        bcstTo = empty;
                        break;
                    }
                    case 1: {
                        bcstTo = b1to2;
                        break;
                    }
                    case 2: {
                        bcstTo = b1to4;
                        break;
                    }
                    case 3: {
                        bcstTo = b1to8;
                        break;
                    }
                    case 4: {
                        bcstTo = b1to16;
                        break;
                    }
                    case 5: {
                        bcstTo = b1to32;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            infos[i] = new Info(keyword, bcstTo);
        }
        return infos;
    }

    public static final class Info {
        public final FormatterString keyword;
        public final FormatterString bcstTo;

        public Info(FormatterString keyword, FormatterString bcstTo) {
            this.keyword = keyword;
            this.bcstTo = bcstTo;
        }
    }
}

