/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.masm;

import com.github.icedland.iced.x86.fmt.masm.InstrInfo;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_AX;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_AY;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_AamAad;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_DX;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_DeclareData;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_Int3;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_OpSize;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_OpSize2;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_OpSize_cc;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_Reg16;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_Reg32;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_STIG1;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_ST_STi;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_STi_ST;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_XLAT;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_XY;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_YA;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_YD;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_YX;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_bnd;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_cc;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_fword;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_imul;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_invlpga;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_jcc;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_maskmovq;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_memsize;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_monitor;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_mwait;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_mwaitx;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_nop;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_pblendvb;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_pclmulqdq;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_pops;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_reg;
import com.github.icedland.iced.x86.fmt.masm.SimpleInstrInfo_reverse;
import com.github.icedland.iced.x86.internal.DataReader;
import com.github.icedland.iced.x86.internal.ResourceReader;
import com.github.icedland.iced.x86.internal.fmt.FormatterConstants;
import com.github.icedland.iced.x86.internal.fmt.FormatterStringsTable;

final class InstrInfos {
    static final InstrInfo[] allInfos = InstrInfos.readInfos();

    InstrInfos() {
    }

    private static byte[] getSerializedInstrInfos() {
        return ResourceReader.readByteArray(InstrInfos.class.getClassLoader(), "com/github/icedland/iced/x86/fmt/masm/InstrInfos.bin");
    }

    private static String addSuffix(String s, char[] ca) {
        return (s + new String(ca)).intern();
    }

    private static String addPrefix(String s, char[] ca) {
        return (new String(ca) + s).intern();
    }

    private static InstrInfo[] readInfos() {
        DataReader reader = new DataReader(InstrInfos.getSerializedInstrInfos());
        InstrInfo[] infos = new InstrInfo[4936];
        String[] strings = FormatterStringsTable.getStringsTable();
        char[] ca = new char[1];
        int prevIndex = -1;
        for (int i = 0; i < infos.length; ++i) {
            InstrInfo instrInfo;
            int currentIndex;
            byte f = (byte)reader.readByte();
            byte ctorKind = (byte)(f & 0x7F);
            if (ctorKind == 0) {
                currentIndex = reader.getIndex();
                reader.setIndex(prevIndex);
                ctorKind = (byte)(reader.readByte() & 0x7F);
            } else {
                currentIndex = -1;
                prevIndex = reader.getIndex() - 1;
            }
            String s = strings[reader.readCompressedUInt32()];
            if ((f & 0x80) != 0) {
                ca[0] = 118;
                s = InstrInfos.addPrefix(s, ca);
            }
            switch (ctorKind) {
                case 1: {
                    instrInfo = new SimpleInstrInfo(s);
                    break;
                }
                case 2: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo(s, v);
                    break;
                }
                case 3: {
                    instrInfo = new SimpleInstrInfo_AamAad(s);
                    break;
                }
                case 4: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_AX(s, s2);
                    break;
                }
                case 5: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_AY(s, s2);
                    break;
                }
                case 6: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_bnd(s, v);
                    break;
                }
                case 8: {
                    instrInfo = new SimpleInstrInfo_DeclareData(i, s);
                    break;
                }
                case 9: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_DX(s, s2);
                    break;
                }
                case 10: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readByte();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_fword(v, v2, s, s2);
                    break;
                }
                case 11: {
                    instrInfo = new SimpleInstrInfo_Int3(s);
                    break;
                }
                case 12: {
                    instrInfo = new SimpleInstrInfo_imul(s);
                    break;
                }
                case 13: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_invlpga(v, s);
                    break;
                }
                case 14: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s});
                    break;
                }
                case 15: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2});
                    break;
                }
                case 16: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2, s3});
                    break;
                }
                case 17: {
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v2, new String[]{s}, v);
                    break;
                }
                case 18: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v2, new String[]{s, s2}, v);
                    break;
                }
                case 19: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v2, new String[]{s, s2, s3}, v);
                    break;
                }
                case 20: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_jcc(v, new String[]{s});
                    break;
                }
                case 21: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_jcc(v, new String[]{s, s2});
                    break;
                }
                case 22: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_jcc(v, new String[]{s, s2, s3});
                    break;
                }
                case 23: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2});
                    break;
                }
                case 24: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    ca[0] = (char)reader.readByte();
                    int v2 = reader.readCompressedUInt32();
                    String s3 = InstrInfos.addSuffix(s, ca);
                    String s4 = InstrInfos.addSuffix(s2, ca);
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_OpSize_cc(v, v2, new String[]{s, s2}, new String[]{s3, s4});
                    break;
                }
                case 25: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_maskmovq(s, v);
                    break;
                }
                case 26: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_memsize(v, s);
                    break;
                }
                case 29: {
                    int v = reader.readByte();
                    int v2 = reader.readByte();
                    int v3 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_monitor(s, v, v2, v3);
                    break;
                }
                case 30: {
                    instrInfo = new SimpleInstrInfo_mwait(s);
                    break;
                }
                case 31: {
                    instrInfo = new SimpleInstrInfo_mwaitx(s);
                    break;
                }
                case 32: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_nop(v, s, v2);
                    break;
                }
                case 33: {
                    int v = reader.readByte();
                    ca[0] = 119;
                    String s2 = InstrInfos.addSuffix(s, ca);
                    ca[0] = 100;
                    String s3 = InstrInfos.addSuffix(s, ca);
                    ca[0] = 113;
                    String s4 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_OpSize(v, s, s2, s3, s4);
                    break;
                }
                case 34: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_OpSize(v, s, s2, s2, s2);
                    break;
                }
                case 35: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    String s4 = strings[reader.readCompressedUInt32()];
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_OpSize2(s, s2, s3, s4, v != 0);
                    break;
                }
                case 37: {
                    instrInfo = new SimpleInstrInfo_pblendvb(s);
                    break;
                }
                case 38: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pclmulqdq(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 39: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pops(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 40: {
                    int v = reader.readByte();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_pops(s, FormatterConstants.getPseudoOps(v), v2);
                    break;
                }
                case 42: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_reg(s, v);
                    break;
                }
                case 43: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_Reg16(s, v);
                    break;
                }
                case 44: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_Reg32(s, v);
                    break;
                }
                case 45: {
                    instrInfo = new SimpleInstrInfo_reverse(s);
                    break;
                }
                case 46: {
                    instrInfo = new SimpleInstrInfo_ST_STi(s);
                    break;
                }
                case 47: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STi_ST(s, v != 0);
                    break;
                }
                case 7: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STIG1(s, v != 0);
                    break;
                }
                case 48: {
                    ca[0] = 98;
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_XLAT(s, s2);
                    break;
                }
                case 41: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_XY(s, s2);
                    break;
                }
                case 36: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_YA(s, s2);
                    break;
                }
                case 27: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_YD(s, s2);
                    break;
                }
                case 28: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_YX(s, s2);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            infos[i] = instrInfo;
            if (currentIndex < 0) continue;
            reader.setIndex(currentIndex);
        }
        if (reader.canRead()) {
            throw new UnsupportedOperationException();
        }
        return infos;
    }
}

