/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.intel.InstrInfo;
import com.github.icedland.iced.x86.fmt.intel.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_DeclareData
extends InstrInfo {
    private final FormatterString mnemonic;
    private final int opKind;

    SimpleInstrInfo_DeclareData(int code, String mnemonic) {
        this.mnemonic = new FormatterString(mnemonic);
        switch (code) {
            case 1: {
                this.opKind = 25;
                break;
            }
            case 2: {
                this.opKind = 26;
                break;
            }
            case 3: {
                this.opKind = 27;
                break;
            }
            case 4: {
                this.opKind = 28;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info = new InstrOpInfo(this.mnemonic, instruction, 32768);
        info.opCount = (byte)instruction.getDeclareDataCount();
        info.op0Kind = (byte)this.opKind;
        info.op1Kind = (byte)this.opKind;
        info.op2Kind = (byte)this.opKind;
        info.op3Kind = (byte)this.opKind;
        info.op4Kind = (byte)this.opKind;
        info.op0Index = (byte)-3;
        info.op1Index = (byte)-3;
        info.op2Index = (byte)-3;
        info.op3Index = (byte)-3;
        info.op4Index = (byte)-3;
        return info;
    }
}

