/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_nop
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;
    private final int register;
    private static final FormatterString str_xchg = new FormatterString("xchg");
    private static final FormatterString str_xchgw = new FormatterString("xchgw");
    private static final FormatterString str_xchgl = new FormatterString("xchgl");
    private static final FormatterString str_xchgq = new FormatterString("xchgq");

    SimpleInstrInfo_nop(int bitness, String mnemonic, int register) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
        this.register = register;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int instrBitness = SimpleInstrInfo_nop.getBitness(instruction.getCodeSize());
        if (instrBitness == 0 || (instrBitness & this.bitness) != 0) {
            return new InstrOpInfo(this.mnemonic, instruction, 0);
        }
        InstrOpInfo info = new InstrOpInfo();
        if (!options.getGasShowMnemonicSizeSuffix()) {
            info.mnemonic = str_xchg;
        } else if (this.register == 21) {
            info.mnemonic = str_xchgw;
        } else if (this.register == 37) {
            info.mnemonic = str_xchgl;
        } else if (this.register == 53) {
            info.mnemonic = str_xchgq;
        } else {
            throw new UnsupportedOperationException();
        }
        info.opCount = (byte)2;
        info.op0Register = (byte)this.register;
        info.op1Register = (byte)this.register;
        info.op0Index = (byte)-2;
        info.op1Index = (byte)-2;
        return info;
    }
}

