/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_far
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;
    private final FormatterString mnemonic_suffix;

    SimpleInstrInfo_far(int bitness, String mnemonic, String mnemonic_suffix) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
        this.mnemonic_suffix = new FormatterString(mnemonic_suffix);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        FormatterString mnemonic;
        int flags = 32;
        int instrBitness = SimpleInstrInfo_far.getBitness(instruction.getCodeSize());
        if (instrBitness == 0) {
            instrBitness = this.bitness;
        }
        if (this.bitness == 64) {
            flags |= 6;
            assert (this.mnemonic.get(false) == this.mnemonic_suffix.get(false));
            mnemonic = this.mnemonic;
        } else {
            mnemonic = this.bitness != instrBitness || options.getGasShowMnemonicSizeSuffix() ? this.mnemonic_suffix : this.mnemonic;
        }
        return new InstrOpInfo(mnemonic, instruction, flags);
    }
}

