/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_AamAad;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_DeclareData;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_OpSize;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_OpSize2_bnd;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_OpSize3;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_Reg16;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_Reg32;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_STIG1;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_ST_STi;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_STi_ST;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_as;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_bnd;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_cc;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_er;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_far;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_imul;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_maskmovq;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_mem16;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_movabs;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_nop;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_os;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_os2;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_os_jcc;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_os_loop;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_os_mem;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_os_mem2;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_pblendvb;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_pclmulqdq;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_pops;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_sae;
import com.github.icedland.iced.x86.internal.DataReader;
import com.github.icedland.iced.x86.internal.ResourceReader;
import com.github.icedland.iced.x86.internal.fmt.FormatterConstants;
import com.github.icedland.iced.x86.internal.fmt.FormatterStringsTable;

final class InstrInfos {
    static final InstrInfo[] allInfos = InstrInfos.readInfos();

    InstrInfos() {
    }

    private static byte[] getSerializedInstrInfos() {
        return ResourceReader.readByteArray(InstrInfos.class.getClassLoader(), "com/github/icedland/iced/x86/fmt/gas/InstrInfos.bin");
    }

    private static String addSuffix(String s, char[] ca) {
        return ca[0] == '\u0000' ? s : s + new String(ca).intern();
    }

    private static String addPrefix(String s, char[] ca) {
        return (new String(ca) + s).intern();
    }

    private static InstrInfo[] readInfos() {
        DataReader reader = new DataReader(InstrInfos.getSerializedInstrInfos());
        InstrInfo[] infos = new InstrInfo[4936];
        String[] strings = FormatterStringsTable.getStringsTable();
        char[] ca = new char[1];
        int prevIndex = -1;
        for (int i = 0; i < infos.length; ++i) {
            InstrInfo instrInfo;
            int currentIndex;
            byte f = (byte)reader.readByte();
            byte ctorKind = (byte)(f & 0x7F);
            if (ctorKind == 0) {
                currentIndex = reader.getIndex();
                reader.setIndex(prevIndex);
                ctorKind = (byte)(reader.readByte() & 0x7F);
            } else {
                currentIndex = -1;
                prevIndex = reader.getIndex() - 1;
            }
            String s = strings[reader.readCompressedUInt32()];
            if ((f & 0x80) != 0) {
                ca[0] = 118;
                s = InstrInfos.addPrefix(s, ca);
            }
            switch (ctorKind) {
                case 1: {
                    instrInfo = new SimpleInstrInfo(s);
                    break;
                }
                case 2: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo(s, s2);
                    break;
                }
                case 3: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo(s, v);
                    break;
                }
                case 4: {
                    ca[0] = (char)reader.readByte();
                    s = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo(s);
                    break;
                }
                case 5: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo(s, s2, v);
                    break;
                }
                case 6: {
                    instrInfo = new SimpleInstrInfo_AamAad(s);
                    break;
                }
                case 7: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_as(v, s);
                    break;
                }
                case 8: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_bnd(s, s2, v);
                    break;
                }
                case 10: {
                    instrInfo = new SimpleInstrInfo_DeclareData(i, s);
                    break;
                }
                case 11: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_er(v, s);
                    break;
                }
                case 12: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_er(v, s, s2, v2);
                    break;
                }
                case 13: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_far(v, s, s2);
                    break;
                }
                case 14: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_imul(s, s2);
                    break;
                }
                case 15: {
                    instrInfo = new SimpleInstrInfo_maskmovq(s);
                    break;
                }
                case 16: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    String s3 = strings[reader.readCompressedUInt32()];
                    String s4 = InstrInfos.addSuffix(s3, ca);
                    instrInfo = new SimpleInstrInfo_movabs(s, s2, s3, s4);
                    break;
                }
                case 17: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_nop(v, s, v2);
                    break;
                }
                case 18: {
                    int v = reader.readByte();
                    String s2 = (s + "w").intern();
                    String s3 = (s + "l").intern();
                    String s4 = (s + "q").intern();
                    instrInfo = new SimpleInstrInfo_OpSize(v, s, s2, s3, s4);
                    break;
                }
                case 19: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    String s4 = strings[reader.readCompressedUInt32()];
                    instrInfo = new SimpleInstrInfo_OpSize2_bnd(s, s2, s3, s4);
                    break;
                }
                case 20: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_OpSize3(v, s, s2);
                    break;
                }
                case 21: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    if (v2 > 1) {
                        throw new UnsupportedOperationException();
                    }
                    int v3 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os(v, s, v2 != 0, v3);
                    break;
                }
                case 24: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s}, new String[]{s2});
                    break;
                }
                case 25: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    ca[0] = (char)reader.readByte();
                    int v = reader.readCompressedUInt32();
                    String s3 = InstrInfos.addSuffix(s, ca);
                    String s4 = InstrInfos.addSuffix(s2, ca);
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2}, new String[]{s3, s4});
                    break;
                }
                case 26: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    ca[0] = (char)reader.readByte();
                    int v = reader.readCompressedUInt32();
                    String s4 = InstrInfos.addSuffix(s, ca);
                    String s5 = InstrInfos.addSuffix(s2, ca);
                    String s6 = InstrInfos.addSuffix(s3, ca);
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2, s3}, new String[]{s4, s5, s6});
                    break;
                }
                case 27: {
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s});
                    break;
                }
                case 28: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s, s2});
                    break;
                }
                case 29: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s, s2, s3});
                    break;
                }
                case 30: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    ca[0] = (char)reader.readByte();
                    String s3 = InstrInfos.addSuffix(s, ca);
                    String s4 = InstrInfos.addSuffix(s2, ca);
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_loop(v, v2, v3, new String[]{s, s2}, new String[]{s3, s4});
                    break;
                }
                case 31: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_loop(v, v2, -1, new String[]{s}, new String[]{s2});
                    break;
                }
                case 32: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_mem(v, s, s2);
                    break;
                }
                case 33: {
                    ca[0] = 119;
                    String s2 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_Reg16(s, s2);
                    break;
                }
                case 34: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_mem2(v, s, s2);
                    break;
                }
                case 35: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    if (v2 > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_os2(v, s, s2, v2 != 0, 0);
                    break;
                }
                case 36: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    if (v2 > 1) {
                        throw new UnsupportedOperationException();
                    }
                    int v3 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os2(v, s, s2, v2 != 0, v3);
                    break;
                }
                case 38: {
                    instrInfo = new SimpleInstrInfo_pblendvb(s);
                    break;
                }
                case 39: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pclmulqdq(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 40: {
                    int v = reader.readByte();
                    int v2 = reader.readByte();
                    if (v2 > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_pops(s, FormatterConstants.getPseudoOps(v), v2 != 0);
                    break;
                }
                case 41: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    ca[0] = 119;
                    String s3 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_mem16(s, s2, s3);
                    break;
                }
                case 42: {
                    instrInfo = new SimpleInstrInfo_Reg32(s);
                    break;
                }
                case 23: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_sae(v, s);
                    break;
                }
                case 9: {
                    instrInfo = new SimpleInstrInfo_ST_STi(s);
                    break;
                }
                case 22: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STi_ST(s, v != 0);
                    break;
                }
                case 37: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STIG1(s, v != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            infos[i] = instrInfo;
            if (currentIndex < 0) continue;
            reader.setIndex(currentIndex);
        }
        if (reader.canRead()) {
            throw new UnsupportedOperationException();
        }
        return infos;
    }
}

