/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.InternalInstructionUtils;
import com.github.icedland.iced.x86.fmt.Formatter;
import com.github.icedland.iced.x86.fmt.FormatterOperandOptions;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.FormatterOptionsProvider;
import com.github.icedland.iced.x86.fmt.FormatterOutput;
import com.github.icedland.iced.x86.fmt.NumberFormattingOptions;
import com.github.icedland.iced.x86.fmt.SymbolResolver;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrInfos;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.fmt.gas.MemorySizes;
import com.github.icedland.iced.x86.fmt.gas.Registers;
import com.github.icedland.iced.x86.internal.MvexInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterOutputExt;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;
import com.github.icedland.iced.x86.internal.fmt.MnemonicCC;
import com.github.icedland.iced.x86.internal.fmt.NumberFormatter;

public final class GasFormatter
extends Formatter {
    private static final String IMMEDIATE_VALUE_PREFIX = "$";
    private final FormatterOptions options = GasFormatter.createGas();
    private final SymbolResolver symbolResolver;
    private final FormatterOptionsProvider optionsProvider;
    private final FormatterString[] allRegisters;
    private final FormatterString[] allRegistersNaked;
    private final InstrInfo[] instrInfos;
    private final FormatterString[] allMemorySizes;
    private final NumberFormatter numberFormatter;
    private final FormatterString[] opSizeStrings;
    private final FormatterString[] addrSizeStrings;
    private final String[] scaleNumbers;
    private final FormatterString[] mvexRegMemConsts32;
    private final FormatterString[] mvexRegMemConsts64;
    private static final FormatterString str_bnd = new FormatterString("bnd");
    private static final FormatterString str_dot_byte = new FormatterString(".byte");
    private static final FormatterString str_lock = new FormatterString("lock");
    private static final FormatterString str_notrack = new FormatterString("notrack");
    private static final FormatterString str_pn = new FormatterString("pn");
    private static final FormatterString str_pt = new FormatterString("pt");
    private static final FormatterString str_rep = new FormatterString("rep");
    private static final FormatterString[] str_repe = new FormatterString[]{new FormatterString("repe"), new FormatterString("repz")};
    private static final FormatterString[] str_repne = new FormatterString[]{new FormatterString("repne"), new FormatterString("repnz")};
    private static final FormatterString str_rex_w = new FormatterString("rex.w");
    private static final FormatterString str_rn_sae = new FormatterString("rn-sae");
    private static final FormatterString str_rd_sae = new FormatterString("rd-sae");
    private static final FormatterString str_ru_sae = new FormatterString("ru-sae");
    private static final FormatterString str_rz_sae = new FormatterString("rz-sae");
    private static final FormatterString str_sae = new FormatterString("sae");
    private static final FormatterString str_rn = new FormatterString("rn");
    private static final FormatterString str_rd = new FormatterString("rd");
    private static final FormatterString str_ru = new FormatterString("ru");
    private static final FormatterString str_rz = new FormatterString("rz");
    private static final FormatterString str_xacquire = new FormatterString("xacquire");
    private static final FormatterString str_xrelease = new FormatterString("xrelease");
    private static final FormatterString str_z = new FormatterString("z");
    private static final FormatterString[] s_opSizeStrings = new FormatterString[]{new FormatterString(""), new FormatterString("data16"), new FormatterString("data32"), new FormatterString("rex.w")};
    private static final FormatterString[] s_addrSizeStrings = new FormatterString[]{new FormatterString(""), new FormatterString("addr16"), new FormatterString("addr32"), new FormatterString("addr64")};
    private static final String[] s_scaleNumbers = new String[]{"1", "2", "4", "8"};
    private static final FormatterString[] s_mvexRegMemConsts32 = new FormatterString[]{new FormatterString(""), new FormatterString(""), new FormatterString("cdab"), new FormatterString("badc"), new FormatterString("dacb"), new FormatterString("aaaa"), new FormatterString("bbbb"), new FormatterString("cccc"), new FormatterString("dddd"), new FormatterString(""), new FormatterString("1to16"), new FormatterString("4to16"), new FormatterString("float16"), new FormatterString("uint8"), new FormatterString("sint8"), new FormatterString("uint16"), new FormatterString("sint16")};
    private static final FormatterString[] s_mvexRegMemConsts64 = new FormatterString[]{new FormatterString(""), new FormatterString(""), new FormatterString("cdab"), new FormatterString("badc"), new FormatterString("dacb"), new FormatterString("aaaa"), new FormatterString("bbbb"), new FormatterString("cccc"), new FormatterString("dddd"), new FormatterString(""), new FormatterString("1to8"), new FormatterString("4to8"), new FormatterString("float16"), new FormatterString("uint8"), new FormatterString("sint8"), new FormatterString("uint16"), new FormatterString("sint16")};
    private static final FormatterString str_eh = new FormatterString("eh");

    @Override
    public FormatterOptions getOptions() {
        return this.options;
    }

    private FormatterString[] getAllRegisters() {
        return this.options.getGasNakedRegisters() ? this.allRegistersNaked : this.allRegisters;
    }

    public GasFormatter() {
        this(null, null);
    }

    public GasFormatter(SymbolResolver symbolResolver) {
        this(symbolResolver, null);
    }

    private static FormatterOptions createGas() {
        FormatterOptions options = new FormatterOptions();
        options.setHexPrefix("0x");
        options.setOctalPrefix("0");
        options.setBinaryPrefix("0b");
        return options;
    }

    public GasFormatter(SymbolResolver symbolResolver, FormatterOptionsProvider optionsProvider) {
        this.symbolResolver = symbolResolver;
        this.optionsProvider = optionsProvider;
        this.allRegisters = Registers.allRegisters;
        this.allRegistersNaked = Registers.allRegistersNaked;
        this.instrInfos = InstrInfos.allInfos;
        this.allMemorySizes = MemorySizes.allMemorySizes;
        this.numberFormatter = new NumberFormatter(true);
        this.opSizeStrings = s_opSizeStrings;
        this.addrSizeStrings = s_addrSizeStrings;
        this.scaleNumbers = s_scaleNumbers;
        this.mvexRegMemConsts32 = s_mvexRegMemConsts32;
        this.mvexRegMemConsts64 = s_mvexRegMemConsts64;
    }

    @Override
    public void formatMnemonic(Instruction instruction, FormatterOutput output, int options) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        this.formatMnemonic(instruction, output, opInfo, 0, options);
    }

    @Override
    public int getOperandCount(Instruction instruction) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        return opInfo.opCount;
    }

    @Override
    public Integer tryGetOpAccess(Instruction instruction, int operand) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        if (Integer.compareUnsigned(operand, opInfo.opCount) >= 0) {
            throw new IllegalArgumentException("operand");
        }
        return opInfo.tryGetOpAccess(operand);
    }

    @Override
    public int getInstructionOperand(Instruction instruction, int operand) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        if (Integer.compareUnsigned(operand, opInfo.opCount) >= 0) {
            throw new IllegalArgumentException("operand");
        }
        return opInfo.getInstructionIndex(operand);
    }

    @Override
    public int getFormatterOperand(Instruction instruction, int instructionOperand) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        if (Integer.compareUnsigned(instructionOperand, instruction.getOpCount()) >= 0) {
            throw new IllegalArgumentException("instructionOperand");
        }
        return opInfo.getOperandIndex(instructionOperand);
    }

    @Override
    public void formatOperand(Instruction instruction, FormatterOutput output, int operand) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        if (Integer.compareUnsigned(operand, opInfo.opCount) >= 0) {
            throw new IllegalArgumentException("operand");
        }
        this.formatOperand(instruction, output, opInfo, operand);
    }

    @Override
    public void formatOperandSeparator(Instruction instruction, FormatterOutput output) {
        if (output == null) {
            throw new NullPointerException("output");
        }
        output.write(",", 6);
        if (this.options.getSpaceAfterOperandSeparator()) {
            output.write(" ", 0);
        }
    }

    @Override
    public void formatAllOperands(Instruction instruction, FormatterOutput output) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        this.formatOperands(instruction, output, opInfo);
    }

    @Override
    public void format(Instruction instruction, FormatterOutput output) {
        assert (Integer.compareUnsigned(instruction.getCode(), this.instrInfos.length) < 0);
        InstrInfo instrInfo = this.instrInfos[instruction.getCode()];
        InstrOpInfo opInfo = instrInfo.getOpInfo(this.options, instruction);
        int column = this.formatMnemonic(instruction, output, opInfo, 0, 0);
        if (opInfo.opCount != 0) {
            FormatterUtils.addTabs(output, column, this.options.getFirstOperandCharIndex(), this.options.getTabSize());
            this.formatOperands(instruction, output, opInfo);
        }
    }

    private int formatMnemonic(Instruction instruction, FormatterOutput output, InstrOpInfo opInfo, int column, int mnemonicOptions) {
        block24: {
            boolean hasBnd;
            boolean hasNoTrackPrefix;
            FormatterString prefix;
            int prefixSeg;
            block26: {
                block25: {
                    if (output == null) {
                        throw new NullPointerException("output");
                    }
                    if ((mnemonicOptions & 1) != 0 || (opInfo.flags & 0x1000) != 0) break block24;
                    prefixSeg = instruction.getSegmentPrefix();
                    if ((opInfo.flags & 0x40) == 0) break block25;
                    switch (opInfo.flags >>> 1 & 3) {
                        case 0: {
                            break block26;
                        }
                        case 1: 
                        case 2: {
                            output.write(str_dot_byte.get(this.options.getUppercaseKeywords() || this.options.getUppercaseAll()), 1);
                            output.write(" ", 0);
                            NumberFormattingOptions numberOptions = NumberFormattingOptions.createImmediate(this.options);
                            String s = this.numberFormatter.formatUInt8(this.options, numberOptions, (byte)102);
                            output.write(s, 7);
                            output.write(";", 6);
                            output.write(" ", 0);
                            column += str_dot_byte.getLength() + 1 + s.length() + 1 + 1;
                            break block26;
                        }
                        case 3: {
                            column = this.formatPrefix(output, instruction, column, str_rex_w, 10);
                            break block26;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
                prefix = this.opSizeStrings[opInfo.flags >>> 1 & 3];
                if (prefix.getLength() != 0) {
                    column = this.formatPrefix(output, instruction, column, prefix, 10);
                }
            }
            prefix = this.addrSizeStrings[opInfo.flags >>> 3 & 3];
            if (prefix.getLength() != 0) {
                column = this.formatPrefix(output, instruction, column, prefix, 11);
            }
            boolean bl = hasNoTrackPrefix = prefixSeg == 74 && FormatterUtils.isNotrackPrefixBranch(instruction.getCode());
            if (!hasNoTrackPrefix && prefixSeg != 0 && this.showSegmentPrefix(instruction, opInfo)) {
                column = this.formatPrefix(output, instruction, column, this.allRegistersNaked[prefixSeg], FormatterUtils.getSegmentRegisterPrefixKind(prefixSeg));
            }
            if (instruction.getXacquirePrefix()) {
                column = this.formatPrefix(output, instruction, column, str_xacquire, 16);
            }
            if (instruction.getXreleasePrefix()) {
                column = this.formatPrefix(output, instruction, column, str_xrelease, 17);
            }
            if (instruction.getLockPrefix()) {
                column = this.formatPrefix(output, instruction, column, str_lock, 6);
            }
            if (hasNoTrackPrefix) {
                column = this.formatPrefix(output, instruction, column, str_notrack, 15);
            }
            boolean bl2 = hasBnd = (opInfo.flags & 0x400) != 0;
            if (hasBnd) {
                column = this.formatPrefix(output, instruction, column, str_bnd, 14);
            }
            if (instruction.getRepePrefix() && FormatterUtils.showRepOrRepePrefix(instruction.getCode(), this.options)) {
                column = FormatterUtils.isRepeOrRepneInstruction(instruction.getCode()) ? this.formatPrefix(output, instruction, column, MnemonicCC.getMnemonicCC(this.options, 4, str_repe), 8) : this.formatPrefix(output, instruction, column, str_rep, 7);
            }
            if (instruction.getRepnePrefix() && !hasBnd && FormatterUtils.showRepnePrefix(instruction.getCode(), this.options)) {
                column = this.formatPrefix(output, instruction, column, MnemonicCC.getMnemonicCC(this.options, 5, str_repne), 9);
            }
        }
        if ((mnemonicOptions & 2) == 0) {
            if (column < 0) {
                output.write(" ", 0);
                ++column;
            }
            FormatterString mnemonic = opInfo.mnemonic;
            if ((opInfo.flags & 0x1000) != 0) {
                output.write(mnemonic.get(this.options.getUppercaseKeywords() || this.options.getUppercaseAll()), 1);
            } else {
                output.writeMnemonic(instruction, mnemonic.get(this.options.getUppercaseMnemonics() || this.options.getUppercaseAll()));
            }
            column += mnemonic.getLength();
        }
        if ((mnemonicOptions & 1) == 0) {
            if ((opInfo.flags & 0x100) != 0) {
                column = this.formatBranchHint(output, column, str_pn);
            } else if ((opInfo.flags & 0x200) != 0) {
                column = this.formatBranchHint(output, column, str_pt);
            }
        }
        return column & Integer.MAX_VALUE;
    }

    private int formatBranchHint(FormatterOutput output, int column, FormatterString brHint) {
        output.write(",", 0);
        output.write(brHint.get(this.options.getUppercasePrefixes() || this.options.getUppercaseAll()), 4);
        return column += 1 + brHint.getLength();
    }

    private boolean showSegmentPrefix(Instruction instruction, InstrOpInfo opInfo) {
        if ((opInfo.flags & 0x300) != 0) {
            return false;
        }
        switch (instruction.getCode()) {
            case 818: 
            case 819: 
            case 820: 
            case 853: 
            case 854: 
            case 855: 
            case 858: 
            case 859: 
            case 860: 
            case 2038: 
            case 2039: 
            case 2040: 
            case 2507: 
            case 2508: 
            case 2509: {
                return FormatterUtils.showSegmentPrefix(74, instruction, this.options);
            }
        }
        block7: for (int i = 0; i < opInfo.opCount; ++i) {
            switch (opInfo.getOpKind(i)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    continue block7;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 24: {
                    return false;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this.options.getShowUselessPrefixes();
    }

    private int formatPrefix(FormatterOutput output, Instruction instruction, int column, FormatterString prefix, int prefixKind) {
        if (column < 0) {
            ++column;
            output.write(" ", 0);
        }
        output.writePrefix(instruction, prefix.get(this.options.getUppercasePrefixes() || this.options.getUppercaseAll()), prefixKind);
        column += prefix.getLength();
        return column |= Integer.MIN_VALUE;
    }

    private void formatOperands(Instruction instruction, FormatterOutput output, InstrOpInfo opInfo) {
        if (output == null) {
            throw new NullPointerException("output");
        }
        for (int i = 0; i < opInfo.opCount; ++i) {
            if (i > 0) {
                output.write(",", 6);
                if (this.options.getSpaceAfterOperandSeparator()) {
                    output.write(" ", 0);
                }
            }
            this.formatOperand(instruction, output, opInfo, i);
        }
    }

    private void formatOperand(Instruction instruction, FormatterOutput output, InstrOpInfo opInfo, int operand) {
        FormatterString[] tbl;
        FormatterString fs;
        int conv;
        int mvexRmOperand;
        assert (Integer.compareUnsigned(operand, opInfo.opCount) < 0) : operand;
        if (output == null) {
            throw new NullPointerException("output");
        }
        if (MvexInfo.isMvex(instruction.getCode())) {
            int opCount = instruction.getOpCount();
            assert (opCount != 0) : opCount;
            mvexRmOperand = instruction.getOpKind(opCount - 1) == 6 && opInfo.opCount == opCount ? 1 : 0;
        } else {
            mvexRmOperand = -1;
        }
        int instructionOperand = opInfo.getInstructionIndex(operand);
        if ((opInfo.flags & 0x20) != 0) {
            output.write("*", 5);
        }
        int opKind = opInfo.getOpKind(operand);
        switch (opKind) {
            case 0: {
                this.formatRegister(output, instruction, operand, instructionOperand, opInfo.getOpRegister(operand));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                SymbolResult symbol;
                int numberKind;
                long imm64;
                int immSize;
                if (opKind == 3) {
                    immSize = 8;
                    imm64 = instruction.getNearBranch64();
                    numberKind = 7;
                } else if (opKind == 2) {
                    immSize = 4;
                    imm64 = (long)instruction.getNearBranch32() & 0xFFFFFFFFL;
                    numberKind = 5;
                } else {
                    immSize = 2;
                    imm64 = instruction.getNearBranch16() & 0xFFFF;
                    numberKind = 3;
                }
                NumberFormattingOptions numberOptions = NumberFormattingOptions.createBranch(this.options);
                FormatterOperandOptions operandOptions = new FormatterOperandOptions();
                if (this.optionsProvider != null) {
                    this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
                }
                if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, instructionOperand, imm64, immSize)) != null) {
                    FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, imm64, symbol, this.options.getShowSymbolAddress());
                    break;
                }
                int flowControl = FormatterUtils.getFlowControl(instruction);
                String s = opKind == 2 ? this.numberFormatter.formatUInt32(this.options, numberOptions, instruction.getNearBranch32(), numberOptions.leadingZeros) : (opKind == 3 ? this.numberFormatter.formatUInt64(this.options, numberOptions, instruction.getNearBranch64(), numberOptions.leadingZeros) : this.numberFormatter.formatUInt16(this.options, numberOptions, instruction.getNearBranch16(), numberOptions.leadingZeros));
                output.writeNumber(instruction, operand, instructionOperand, s, imm64, numberKind, FormatterUtils.isCall(flowControl) ? 12 : 11);
                break;
            }
            case 4: 
            case 5: {
                SymbolResult symbol;
                int numberKind;
                long imm64;
                int immSize;
                if (opKind == 5) {
                    immSize = 4;
                    imm64 = (long)instruction.getFarBranch32() & 0xFFFFFFFFL;
                    numberKind = 5;
                } else {
                    immSize = 2;
                    imm64 = instruction.getFarBranch16() & 0xFFFF;
                    numberKind = 3;
                }
                NumberFormattingOptions numberOptions = NumberFormattingOptions.createBranch(this.options);
                FormatterOperandOptions operandOptions = new FormatterOperandOptions();
                if (this.optionsProvider != null) {
                    this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
                }
                if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, instructionOperand, imm64, immSize)) != null) {
                    output.write(IMMEDIATE_VALUE_PREFIX, 5);
                    assert (operand + 1 == 1) : operand;
                    SymbolResult selectorSymbol = this.symbolResolver.getSymbol(instruction, operand + 1, instructionOperand, instruction.getFarBranchSelector() & 0xFFFF, 2);
                    if (selectorSymbol == null) {
                        String s = this.numberFormatter.formatUInt16(this.options, numberOptions, instruction.getFarBranchSelector(), numberOptions.leadingZeros);
                        output.writeNumber(instruction, operand, instructionOperand, s, instruction.getFarBranchSelector() & 0xFFFF, 3, 10);
                    } else {
                        FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, instruction.getFarBranchSelector() & 0xFFFF, selectorSymbol, this.options.getShowSymbolAddress());
                    }
                    output.write(",", 6);
                    if (this.options.getSpaceAfterOperandSeparator()) {
                        output.write(" ", 0);
                    }
                    output.write(IMMEDIATE_VALUE_PREFIX, 5);
                    FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, imm64, symbol, this.options.getShowSymbolAddress());
                    break;
                }
                int flowControl = FormatterUtils.getFlowControl(instruction);
                String s = this.numberFormatter.formatUInt16(this.options, numberOptions, instruction.getFarBranchSelector(), numberOptions.leadingZeros);
                output.write(IMMEDIATE_VALUE_PREFIX, 5);
                output.writeNumber(instruction, operand, instructionOperand, s, instruction.getFarBranchSelector() & 0xFFFF, 3, 10);
                output.write(",", 6);
                if (this.options.getSpaceAfterOperandSeparator()) {
                    output.write(" ", 0);
                }
                s = opKind == 5 ? this.numberFormatter.formatUInt32(this.options, numberOptions, instruction.getFarBranch32(), numberOptions.leadingZeros) : this.numberFormatter.formatUInt16(this.options, numberOptions, instruction.getFarBranch16(), numberOptions.leadingZeros);
                output.write(IMMEDIATE_VALUE_PREFIX, 5);
                output.writeNumber(instruction, operand, instructionOperand, s, imm64, numberKind, FormatterUtils.isCall(flowControl) ? 12 : 11);
                break;
            }
            case 6: 
            case 7: 
            case 34: {
                int numberKind;
                long imm64;
                SymbolResult symbol;
                if (opKind != 34) {
                    output.write(IMMEDIATE_VALUE_PREFIX, 5);
                }
                byte imm8 = opKind == 6 ? instruction.getImmediate8() : (opKind == 7 ? instruction.getImmediate8_2nd() : instruction.getDeclareByteValue(operand));
                NumberFormattingOptions numberOptions = NumberFormattingOptions.createImmediate(this.options);
                FormatterOperandOptions operandOptions = new FormatterOperandOptions();
                if (this.optionsProvider != null) {
                    this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
                }
                if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, instructionOperand, imm8 & 0xFF, 1)) != null) {
                    FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, imm8 & 0xFF, symbol, this.options.getShowSymbolAddress());
                    break;
                }
                if (numberOptions.signedNumber) {
                    imm64 = imm8;
                    numberKind = 0;
                    if (imm8 < 0) {
                        output.write("-", 5);
                        imm8 = -imm8;
                    }
                } else {
                    imm64 = imm8 & 0xFF;
                    numberKind = 1;
                }
                String s = this.numberFormatter.formatUInt8(this.options, numberOptions, imm8);
                output.writeNumber(instruction, operand, instructionOperand, s, imm64, numberKind, 7);
                break;
            }
            case 8: 
            case 11: 
            case 35: {
                int numberKind;
                long imm64;
                SymbolResult symbol;
                if (opKind != 35) {
                    output.write(IMMEDIATE_VALUE_PREFIX, 5);
                }
                short imm16 = opKind == 8 ? instruction.getImmediate16() : (opKind == 11 ? instruction.getImmediate8to16() : instruction.getDeclareWordValue(operand));
                NumberFormattingOptions numberOptions = NumberFormattingOptions.createImmediate(this.options);
                FormatterOperandOptions operandOptions = new FormatterOperandOptions();
                if (this.optionsProvider != null) {
                    this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
                }
                if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, instructionOperand, imm16 & 0xFFFF, 2)) != null) {
                    FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, imm16 & 0xFFFF, symbol, this.options.getShowSymbolAddress());
                    break;
                }
                if (numberOptions.signedNumber) {
                    imm64 = imm16;
                    numberKind = 2;
                    if (imm16 < 0) {
                        output.write("-", 5);
                        imm16 = -imm16;
                    }
                } else {
                    imm64 = imm16 & 0xFFFF;
                    numberKind = 3;
                }
                String s = this.numberFormatter.formatUInt16(this.options, numberOptions, imm16);
                output.writeNumber(instruction, operand, instructionOperand, s, imm64, numberKind, 7);
                break;
            }
            case 9: 
            case 12: 
            case 36: {
                int numberKind;
                long imm64;
                SymbolResult symbol;
                if (opKind != 36) {
                    output.write(IMMEDIATE_VALUE_PREFIX, 5);
                }
                int imm32 = opKind == 9 ? instruction.getImmediate32() : (opKind == 12 ? instruction.getImmediate8to32() : instruction.getDeclareDwordValue(operand));
                NumberFormattingOptions numberOptions = NumberFormattingOptions.createImmediate(this.options);
                FormatterOperandOptions operandOptions = new FormatterOperandOptions();
                if (this.optionsProvider != null) {
                    this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
                }
                if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, instructionOperand, (long)imm32 & 0xFFFFFFFFL, 4)) != null) {
                    FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, (long)imm32 & 0xFFFFFFFFL, symbol, this.options.getShowSymbolAddress());
                    break;
                }
                if (numberOptions.signedNumber) {
                    imm64 = imm32;
                    numberKind = 4;
                    if (imm32 < 0) {
                        output.write("-", 5);
                        imm32 = -imm32;
                    }
                } else {
                    imm64 = (long)imm32 & 0xFFFFFFFFL;
                    numberKind = 5;
                }
                String s = this.numberFormatter.formatUInt32(this.options, numberOptions, imm32);
                output.writeNumber(instruction, operand, instructionOperand, s, imm64, numberKind, 7);
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 37: {
                int numberKind;
                SymbolResult symbol;
                if (opKind != 37) {
                    output.write(IMMEDIATE_VALUE_PREFIX, 5);
                }
                long imm64 = opKind == 14 ? instruction.getImmediate32to64() : (opKind == 13 ? instruction.getImmediate8to64() : (opKind == 10 ? instruction.getImmediate64() : instruction.getDeclareQwordValue(operand)));
                NumberFormattingOptions numberOptions = NumberFormattingOptions.createImmediate(this.options);
                FormatterOperandOptions operandOptions = new FormatterOperandOptions();
                if (this.optionsProvider != null) {
                    this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
                }
                if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, instructionOperand, imm64, 8)) != null) {
                    FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, imm64, symbol, this.options.getShowSymbolAddress());
                    break;
                }
                long value64 = imm64;
                if (numberOptions.signedNumber) {
                    numberKind = 6;
                    if (imm64 < 0L) {
                        output.write("-", 5);
                        imm64 = -imm64;
                    }
                } else {
                    numberKind = 7;
                }
                String s = this.numberFormatter.formatUInt64(this.options, numberOptions, imm64);
                output.writeNumber(instruction, operand, instructionOperand, s, value64, numberKind, 7);
                break;
            }
            case 15: {
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), 27, 0, 0, 0, 0L, 2);
                break;
            }
            case 16: {
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), 43, 0, 0, 0, 0L, 4);
                break;
            }
            case 17: {
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), 59, 0, 0, 0, 0L, 8);
                break;
            }
            case 18: {
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), 28, 0, 0, 0, 0L, 2);
                break;
            }
            case 19: {
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), 44, 0, 0, 0, 0L, 4);
                break;
            }
            case 20: {
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), 60, 0, 0, 0, 0L, 8);
                break;
            }
            case 21: {
                this.formatMemory(output, instruction, operand, instructionOperand, 71, 28, 0, 0, 0, 0L, 2);
                break;
            }
            case 22: {
                this.formatMemory(output, instruction, operand, instructionOperand, 71, 44, 0, 0, 0, 0L, 4);
                break;
            }
            case 23: {
                this.formatMemory(output, instruction, operand, instructionOperand, 71, 60, 0, 0, 0, 0L, 8);
                break;
            }
            case 24: {
                int displSize = instruction.getMemoryDisplSize();
                int baseReg = instruction.getMemoryBase();
                int indexReg = instruction.getMemoryIndex();
                int addrSize = InternalInstructionUtils.getAddressSizeInBytes(baseReg, indexReg, displSize, instruction.getCodeSize());
                long displ = addrSize == 8 ? instruction.getMemoryDisplacement64() : (long)instruction.getMemoryDisplacement32() & 0xFFFFFFFFL;
                if ((opInfo.flags & 0x800) != 0) {
                    indexReg = 0;
                }
                this.formatMemory(output, instruction, operand, instructionOperand, instruction.getMemorySegment(), baseReg, indexReg, instruction.getRawMemoryIndexScale(), displSize, displ, addrSize);
                break;
            }
            case 25: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_sae, 2);
                break;
            }
            case 26: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_rn_sae, 1);
                break;
            }
            case 27: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_rd_sae, 1);
                break;
            }
            case 28: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_ru_sae, 1);
                break;
            }
            case 29: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_rz_sae, 1);
                break;
            }
            case 30: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_rn, 1);
                break;
            }
            case 31: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_rd, 1);
                break;
            }
            case 32: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_ru, 1);
                break;
            }
            case 33: {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_rz, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (operand + 1 == opInfo.opCount && (instruction.hasOpMask() || instruction.getZeroingMasking())) {
            if (instruction.hasOpMask()) {
                output.write("{", 6);
                this.formatRegister(output, instruction, operand, instructionOperand, instruction.getOpMask());
                output.write("}", 6);
            }
            if (instruction.getZeroingMasking()) {
                this.formatDecorator(output, instruction, operand, instructionOperand, str_z, 3);
            }
        }
        if (mvexRmOperand == operand && (conv = instruction.getMvexRegMemConv()) != 0 && MvexInfo.getConvFn(instruction.getCode()) != 0 && (fs = (tbl = MvexInfo.isConvFn32(instruction.getCode()) ? this.mvexRegMemConsts32 : this.mvexRegMemConsts64)[conv]).getLength() != 0) {
            this.formatDecorator(output, instruction, operand, instructionOperand, fs, 4);
        }
    }

    private void formatDecorator(FormatterOutput output, Instruction instruction, int operand, int instructionOperand, FormatterString text, int decorator) {
        output.write("{", 6);
        output.writeDecorator(instruction, operand, instructionOperand, text.get(this.options.getUppercaseDecorators() || this.options.getUppercaseAll()), decorator);
        output.write("}", 6);
    }

    private String toRegisterString(int reg) {
        assert (Integer.compareUnsigned(reg, this.getAllRegisters().length) < 0) : reg;
        if (this.options.getPreferST0() && reg == 249) {
            reg = 217;
        }
        FormatterString regStr = this.getAllRegisters()[reg];
        return regStr.get(this.options.getUppercaseRegisters() || this.options.getUppercaseAll());
    }

    private void formatRegister(FormatterOutput output, Instruction instruction, int operand, int instructionOperand, int reg) {
        output.writeRegister(instruction, operand, instructionOperand, this.toRegisterString(reg), reg);
    }

    private void formatMemory(FormatterOutput output, Instruction instruction, int operand, int instructionOperand, int segReg, int baseReg, int indexReg, int scale, int displSize, long displ, int addrSize) {
        boolean noTrackPrefix;
        boolean useScale;
        long absAddr;
        assert (Integer.compareUnsigned(scale, this.scaleNumbers.length) < 0);
        assert (InternalInstructionUtils.getAddressSizeInBytes(baseReg, indexReg, displSize, instruction.getCodeSize()) == addrSize) : addrSize;
        NumberFormattingOptions numberOptions = NumberFormattingOptions.createDisplacement(this.options);
        FormatterOperandOptions operandOptions = FormatterOperandOptions.withMemorySizeOptions(this.options.getMemorySizeOptions());
        operandOptions.setRipRelativeAddresses(this.options.getRipRelativeAddresses());
        if (this.optionsProvider != null) {
            this.optionsProvider.getOperandOptions(instruction, operand, instructionOperand, operandOptions, numberOptions);
        }
        if (baseReg == 70) {
            absAddr = displ;
            if (this.options.getRipRelativeAddresses()) {
                displ -= instruction.getNextIP();
            } else {
                assert (indexReg == 0) : indexReg;
                baseReg = 0;
            }
            displSize = 8;
        } else if (baseReg == 69) {
            absAddr = displ & 0xFFFFFFFFL;
            if (this.options.getRipRelativeAddresses()) {
                displ = (int)displ - instruction.getNextIP32();
            } else {
                assert (indexReg == 0) : indexReg;
                baseReg = 0;
            }
            displSize = 4;
        } else {
            absAddr = displ;
        }
        SymbolResult symbol = this.symbolResolver != null ? this.symbolResolver.getSymbol(instruction, operand, instructionOperand, absAddr, addrSize) : null;
        boolean bl = useScale = scale != 0 || this.options.getAlwaysShowScale();
        if (addrSize == 2 || !FormatterUtils.showIndexScale(instruction, this.options)) {
            useScale = false;
        }
        boolean hasBaseOrIndexReg = baseReg != 0 || indexReg != 0;
        int codeSize = instruction.getCodeSize();
        int segOverride = instruction.getSegmentPrefix();
        boolean bl2 = noTrackPrefix = segOverride == 74 && FormatterUtils.isNotrackPrefixBranch(instruction.getCode()) && (codeSize != 1 && codeSize != 2 || baseReg != 26 && baseReg != 42 && baseReg != 41);
        if (this.options.getAlwaysShowSegmentRegister() || segOverride != 0 && !noTrackPrefix && FormatterUtils.showSegmentPrefix(0, instruction, this.options)) {
            this.formatRegister(output, instruction, operand, instructionOperand, segReg);
            output.write(":", 6);
        }
        if (symbol != null) {
            FormatterOutputExt.write(output, instruction, operand, instructionOperand, this.options, this.numberFormatter, numberOptions, absAddr, symbol, this.options.getShowSymbolAddress());
        } else if (!hasBaseOrIndexReg || displSize != 0 && (this.options.getShowZeroDisplacements() || displ != 0L)) {
            int displKind;
            String s;
            boolean isSigned;
            long origDispl = displ;
            if (hasBaseOrIndexReg) {
                isSigned = numberOptions.signedNumber;
                if (addrSize == 8) {
                    if (numberOptions.signedNumber && displ < 0L) {
                        output.write("-", 5);
                        displ = -displ;
                    }
                    if (numberOptions.displacementLeadingZeros) {
                        displSize = 4;
                    }
                } else if (addrSize == 4) {
                    if (numberOptions.signedNumber && (int)displ < 0) {
                        output.write("-", 5);
                        displ = (long)(-((int)displ)) & 0xFFFFFFFFL;
                    }
                    if (numberOptions.displacementLeadingZeros) {
                        displSize = 4;
                    }
                } else {
                    assert (addrSize == 2) : addrSize;
                    if (numberOptions.signedNumber && (short)displ < 0) {
                        output.write("-", 5);
                        displ = -((short)displ) & 0xFFFF;
                    }
                    if (numberOptions.displacementLeadingZeros) {
                        displSize = 2;
                    }
                }
            } else {
                isSigned = false;
            }
            if (displSize <= 1 && Long.compareUnsigned(displ, 255L) <= 0) {
                s = this.numberFormatter.formatDisplUInt8(this.options, numberOptions, (byte)displ);
                displKind = isSigned ? 0 : 1;
            } else if (displSize <= 2 && Long.compareUnsigned(displ, 65535L) <= 0) {
                s = this.numberFormatter.formatDisplUInt16(this.options, numberOptions, (short)displ);
                displKind = isSigned ? 2 : 3;
            } else if (displSize <= 4 && Long.compareUnsigned(displ, 0xFFFFFFFFL) <= 0) {
                s = this.numberFormatter.formatDisplUInt32(this.options, numberOptions, (int)displ);
                displKind = isSigned ? 4 : 5;
            } else if (displSize <= 8) {
                s = this.numberFormatter.formatDisplUInt64(this.options, numberOptions, displ);
                displKind = isSigned ? 6 : 7;
            } else {
                throw new UnsupportedOperationException();
            }
            output.writeNumber(instruction, operand, instructionOperand, s, origDispl, displKind, 7);
        }
        if (hasBaseOrIndexReg) {
            output.write("(", 6);
            if (this.options.getSpaceAfterMemoryBracket()) {
                output.write(" ", 0);
            }
            if (baseReg != 0 && indexReg == 0 && !useScale) {
                this.formatRegister(output, instruction, operand, instructionOperand, baseReg);
            } else {
                if (baseReg != 0) {
                    this.formatRegister(output, instruction, operand, instructionOperand, baseReg);
                }
                output.write(",", 6);
                if (this.options.getGasSpaceAfterMemoryOperandComma()) {
                    output.write(" ", 0);
                }
                if (indexReg != 0) {
                    this.formatRegister(output, instruction, operand, instructionOperand, indexReg);
                    if (useScale) {
                        output.write(",", 6);
                        if (this.options.getGasSpaceAfterMemoryOperandComma()) {
                            output.write(" ", 0);
                        }
                        output.writeNumber(instruction, operand, instructionOperand, this.scaleNumbers[scale], 1 << scale, 4, 7);
                    }
                }
            }
            if (this.options.getSpaceAfterMemoryBracket()) {
                output.write(" ", 0);
            }
            output.write(")", 6);
        }
        int memSize = instruction.getMemorySize();
        assert (Integer.compareUnsigned(memSize, this.allMemorySizes.length) < 0);
        FormatterString bcstTo = this.allMemorySizes[memSize];
        if (bcstTo.getLength() != 0) {
            this.formatDecorator(output, instruction, operand, instructionOperand, bcstTo, 0);
        }
        if (instruction.getMvexEvictionHint()) {
            this.formatDecorator(output, instruction, operand, instructionOperand, str_eh, 5);
        }
    }

    @Override
    public String formatRegister(int register) {
        return this.toRegisterString(register);
    }

    @Override
    public String formatInt8(byte value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatInt8(this.options, numberOptions, value);
    }

    @Override
    public String formatInt16(short value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatInt16(this.options, numberOptions, value);
    }

    @Override
    public String formatInt32(int value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatInt32(this.options, numberOptions, value);
    }

    @Override
    public String formatInt64(long value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatInt64(this.options, numberOptions, value);
    }

    @Override
    public String formatUInt8(byte value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatUInt8(this.options, numberOptions, value);
    }

    @Override
    public String formatUInt16(short value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatUInt16(this.options, numberOptions, value);
    }

    @Override
    public String formatUInt32(int value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatUInt32(this.options, numberOptions, value);
    }

    @Override
    public String formatUInt64(long value, NumberFormattingOptions numberOptions) {
        return this.numberFormatter.formatUInt64(this.options, numberOptions, value);
    }
}

