/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class SimpleInstr
extends Instr {
    private Instruction instruction;

    SimpleInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        this.done = true;
        this.instruction = instruction;
        this.size = blockEncoder.getInstructionSize(instruction, instruction.getIP());
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
    }

    @Override
    boolean optimize(long gained) {
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        result.isOriginalInstruction = true;
        Object encResult = encoder.tryEncode(this.instruction, this.ip);
        if (encResult instanceof Integer) {
            result.constantOffsets = encoder.getConstantOffsets();
            return null;
        }
        return SimpleInstr.createErrorMessage((String)encResult, this.instruction);
    }
}

