/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpX
extends Op {
    OpX() {
    }

    static int getXRegSize(int opKind) {
        if (opKind == 17) {
            return 8;
        }
        if (opKind == 16) {
            return 4;
        }
        if (opKind == 15) {
            return 2;
        }
        return 0;
    }

    static int getYRegSize(int opKind) {
        if (opKind == 23) {
            return 8;
        }
        if (opKind == 22) {
            return 4;
        }
        if (opKind == 21) {
            return 2;
        }
        return 0;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        int regXSize = OpX.getXRegSize(instruction.getOpKind(operand));
        if (regXSize == 0) {
            encoder.setErrorMessage(String.format("Operand %d: expected OpKind = MEMORY_SEG_SI, MEMORY_SEG_ESI or MEMORY_SEG_RSI", operand));
            return;
        }
        switch (instruction.getCode()) {
            case 331: 
            case 332: 
            case 333: 
            case 334: {
                int regYSize = OpX.getYRegSize(instruction.getOp0Kind());
                if (regXSize == regYSize) break;
                encoder.setErrorMessage(String.format("Same sized register must be used: reg #1 size = %d, reg #2 size = %d", regYSize * 8, regXSize * 8));
                return;
            }
        }
        encoder.setAddrSize(regXSize);
    }
}

