/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpHx
extends Op {
    private final int regLo;
    private final int regHi;

    OpHx(int regLo, int regHi) {
        this.regLo = regLo;
        this.regHi = regHi;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        if (!encoder.verifyOpKind(operand, 0, instruction.getOpKind(operand))) {
            return;
        }
        int reg = instruction.getOpRegister(operand);
        if (!encoder.verify(operand, reg, this.regLo, this.regHi)) {
            return;
        }
        encoder.encoderFlags |= reg - this.regLo << 27;
    }
}

