/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockData;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.CallInstr;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.IpRelMemOpInstr;
import com.github.icedland.iced.x86.enc.JccInstr;
import com.github.icedland.iced.x86.enc.JmpInstr;
import com.github.icedland.iced.x86.enc.RelocInfo;
import com.github.icedland.iced.x86.enc.SimpleBranchInstr;
import com.github.icedland.iced.x86.enc.SimpleInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;
import com.github.icedland.iced.x86.enc.XbeginInstr;

abstract class Instr {
    final Block block;
    int size;
    long ip;
    final long origIP;
    boolean done;
    static final int CALL_OR_JMP_POINTER_DATA_INSTRUCTION_SIZE64 = 6;

    Instr(Block block, long origIp) {
        this.origIP = origIp;
        this.block = block;
    }

    abstract void initialize(BlockEncoder var1);

    abstract boolean optimize(long var1);

    abstract String tryEncode(Encoder var1, TryEncodeResult var2);

    protected static String createErrorMessage(String errorMessage, Instruction instruction) {
        return String.format("%s : 0x%X %s", errorMessage, instruction.getIP(), instruction.toString());
    }

    static Instr create(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        switch (instruction.getCode()) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 1854: 
            case 1855: 
            case 1856: 
            case 1857: 
            case 1858: 
            case 1859: 
            case 1860: 
            case 1861: 
            case 1862: 
            case 1863: 
            case 1864: 
            case 1865: 
            case 1866: 
            case 1867: 
            case 1868: 
            case 1869: 
            case 1870: 
            case 1871: 
            case 1872: 
            case 1873: 
            case 1874: 
            case 1875: 
            case 1876: 
            case 1877: 
            case 1878: 
            case 1879: 
            case 1880: 
            case 1881: 
            case 1882: 
            case 1883: 
            case 1884: 
            case 1885: 
            case 1886: 
            case 1887: 
            case 1888: 
            case 1889: 
            case 1890: 
            case 1891: 
            case 1892: 
            case 1893: 
            case 1894: 
            case 1895: 
            case 1896: 
            case 1897: 
            case 1898: 
            case 1899: 
            case 1900: 
            case 1901: 
            case 4563: 
            case 4564: 
            case 4582: 
            case 4583: {
                return new JccInstr(blockEncoder, block, instruction);
            }
            case 657: 
            case 658: 
            case 659: 
            case 660: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 673: 
            case 674: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 683: 
            case 684: {
                return new SimpleBranchInstr(blockEncoder, block, instruction);
            }
            case 691: 
            case 692: 
            case 693: {
                return new CallInstr(blockEncoder, block, instruction);
            }
            case 694: 
            case 695: 
            case 696: 
            case 699: 
            case 700: 
            case 701: {
                return new JmpInstr(blockEncoder, block, instruction);
            }
            case 406: 
            case 407: {
                return new XbeginInstr(blockEncoder, block, instruction);
            }
        }
        if (blockEncoder.getBitness() == 64) {
            int ops = instruction.getOpCount();
            for (int i = 0; i < ops; ++i) {
                if (instruction.getOpKind(i) != 24) continue;
                if (!instruction.isIPRelativeMemoryOperand()) break;
                return new IpRelMemOpInstr(blockEncoder, block, instruction);
            }
        }
        return new SimpleInstr(blockEncoder, block, instruction);
    }

    Object encodeBranchToPointerData(Encoder encoder, boolean isCall, long ip, BlockData pointerData, int minSize) {
        int relocKind;
        if (minSize < 0) {
            throw new IllegalArgumentException("minSize");
        }
        Instruction instr = new Instruction();
        instr.setOp0Kind(24);
        instr.setMemoryDisplSize(encoder.getBitness() / 8);
        switch (encoder.getBitness()) {
            case 64: {
                instr.setCode(isCall ? 759 : 765);
                instr.setMemoryBase(70);
                long nextRip = ip + 6L;
                long diff = pointerData.getAddress() - nextRip;
                if (Integer.MIN_VALUE > diff || diff > Integer.MAX_VALUE) {
                    return "Block is too big";
                }
                instr.setMemoryDisplacement64(pointerData.getAddress());
                relocKind = 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        Object result = encoder.tryEncode(instr, ip);
        if (result instanceof String) {
            return (String)result;
        }
        int size = (Integer)result;
        if (this.block.canAddRelocInfos() && relocKind != 0) {
            ConstantOffsets constantOffsets = encoder.getConstantOffsets();
            if (!constantOffsets.hasDisplacement()) {
                return "Internal error: no displ";
            }
            this.block.addRelocInfo(new RelocInfo(relocKind, ip + (long)constantOffsets.displacementOffset));
        }
        while (size < minSize) {
            ++size;
            this.block.codeWriter.writeByte((byte)-112);
        }
        return null;
    }

    protected static long correctDiff(boolean inBlock, long diff, long gained) {
        if (inBlock && diff >= 0L) {
            assert (Long.compareUnsigned(diff, gained) >= 0);
            return diff - gained;
        }
        return diff;
    }

    protected static long convertDiffToBitnessDiff(int bitness, long diff) {
        switch (bitness) {
            case 16: {
                return (short)diff;
            }
            case 32: {
                return (int)diff;
            }
        }
        return diff;
    }
}

