/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;
import com.github.icedland.iced.x86.internal.MvexInfo;

final class OpCodeHandler_MVEX_KHW
extends OpCodeHandlerModRM {
    private final int code;

    OpCodeHandler_MVEX_KHW(int code) {
        assert (!MvexInfo.getIgnoresOpMaskRegister(code));
        assert (MvexInfo.canUseEvictionHint(code));
        assert (!MvexInfo.getIgnoresEvictionHint(code));
        this.code = code;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        instruction.setCode(this.code);
        instruction.setOp0Register(decoder.state_reg + 173);
        instruction.setOp1Register(decoder.state_vvvv + 141);
        if (((decoder.state_zs_extraRegisterBase | decoder.state_extraRegisterBaseEVEX) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        int sss = decoder.getSss();
        if (decoder.state_mod == 3) {
            instruction.setOp2Register(decoder.state_rm + decoder.state_extraBaseRegisterBaseEVEX + 141);
            if ((decoder.state_zs_flags & 0x80000) != 0) {
                if (MvexInfo.canUseSuppressAllExceptions(this.code)) {
                    if ((sss & 4) != 0) {
                        instruction.setSuppressAllExceptions(true);
                    }
                    if (MvexInfo.canUseRoundingControl(this.code)) {
                        instruction.setRoundingControl((sss & 3) + 1);
                    }
                } else if (MvexInfo.getNoSaeRc(this.code) && (sss & decoder.invalidCheckMask) != 0) {
                    decoder.setInvalidInstruction();
                }
            } else {
                if ((MvexInfo.getInvalidSwizzleFns(this.code) & 1 << sss & decoder.invalidCheckMask) != 0) {
                    decoder.setInvalidInstruction();
                }
                assert (Integer.compareUnsigned(sss, 7) <= 0) : sss;
                instruction.setMvexRegMemConv(1 + sss);
            }
        } else {
            instruction.setOp2Kind(24);
            if ((decoder.state_zs_flags & 0x80000) != 0) {
                instruction.setMvexEvictionHint(true);
            }
            if ((MvexInfo.getInvalidConvFns(this.code) & 1 << sss & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            instruction.setMvexRegMemConv(9 + sss);
            decoder.readOpMem(instruction, MvexInfo.getTupleType(this.code, sss));
        }
    }
}

