/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Gv_Ev_32_64
extends OpCodeHandlerModRM {
    private final int code32;
    private final int code64;
    private final int disallowReg;
    private final int disallowMem;

    OpCodeHandler_Gv_Ev_32_64(int code32, int code64, boolean allowReg, boolean allowMem) {
        this.code32 = code32;
        this.code64 = code64;
        this.disallowMem = allowMem ? 0 : -1;
        this.disallowReg = allowReg ? 0 : -1;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        int baseReg;
        if (decoder.is64bMode) {
            instruction.setCode(this.code64);
            baseReg = 53;
        } else {
            instruction.setCode(this.code32);
            baseReg = 37;
        }
        instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + baseReg);
        if (decoder.state_mod == 3) {
            instruction.setOp1Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + baseReg);
            if ((this.disallowReg & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
        } else {
            if ((this.disallowMem & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            instruction.setOp1Kind(24);
            decoder.readOpMem(instruction);
        }
    }
}

