/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Gv_Eb
extends OpCodeHandlerModRM {
    private final int[] codes;

    OpCodeHandler_Gv_Eb(int code16, int code32, int code64) {
        this.codes = new int[]{code16, code32, code64};
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        byte operandSize = decoder.state_operandSize;
        instruction.setCode(this.codes[operandSize]);
        instruction.setOp0Register((operandSize << 4) + decoder.state_reg + decoder.state_zs_extraRegisterBase + 21);
        if (decoder.state_mod == 3) {
            int index = decoder.state_rm + decoder.state_zs_extraBaseRegisterBase;
            if ((decoder.state_zs_flags & 8) != 0 && index >= 4) {
                index += 4;
            }
            instruction.setOp1Register(index + 1);
        } else {
            instruction.setOp1Kind(24);
            decoder.readOpMem(instruction);
        }
    }
}

