/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_VkHWIb_er
extends OpCodeHandlerModRM {
    private final int baseReg1;
    private final int baseReg2;
    private final int baseReg3;
    private final int code;
    private final int tupleType;
    private final boolean canBroadcast;

    OpCodeHandler_EVEX_VkHWIb_er(int baseReg, int code, int tupleType, boolean canBroadcast) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.baseReg3 = baseReg;
        this.code = code;
        this.tupleType = tupleType;
        this.canBroadcast = canBroadcast;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        instruction.setCode(this.code);
        instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + this.baseReg1);
        instruction.setOp1Register(decoder.state_vvvv + this.baseReg2);
        if (decoder.state_mod == 3) {
            instruction.setOp2Register(decoder.state_rm + decoder.state_extraBaseRegisterBaseEVEX + this.baseReg3);
            if ((decoder.state_zs_flags & 0x10) != 0) {
                instruction.setSuppressAllExceptions(true);
            }
        } else {
            instruction.setOp2Kind(24);
            if ((decoder.state_zs_flags & 0x10) != 0) {
                if (this.canBroadcast) {
                    instruction.setBroadcast(true);
                } else if (decoder.invalidCheckMask != 0) {
                    decoder.setInvalidInstruction();
                }
            }
            decoder.readOpMem(instruction, this.tupleType);
        }
        instruction.setOp3Kind(6);
        instruction.setImmediate8((byte)decoder.readByte());
    }
}

