/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.dec.OpCodeHandler;
import com.github.icedland.iced.x86.dec.OpCodeHandlerReader;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_Ed_V_Ib;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_Ev_VX;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_Ev_VX_Ib;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_GvM_VX_Ib;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_Gv_W_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_HWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_HkWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_KP1HW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_KR;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_KkHW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_KkHWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_KkHWIb_sae;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_KkWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_MV;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VHM;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VHW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VHWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VK;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VM;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VSIB_k1;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VSIB_k1_VX;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VW_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VX_Ev;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_V_H_Ev_Ib;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_V_H_Ev_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkEv_REXW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkHM;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkHW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkHWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkHWIb_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkHW_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkHW_er_ur;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkM;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkWIb_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_VkW_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_Vk_VSIB;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_WV;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_WkHV;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_WkV;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_WkVIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EVEX_WkVIb_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_Group;
import com.github.icedland.iced.x86.dec.OpCodeHandler_Invalid;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MandatoryPrefix2;
import com.github.icedland.iced.x86.dec.OpCodeHandler_RM;
import com.github.icedland.iced.x86.dec.OpCodeHandler_VectorLength_EVEX;
import com.github.icedland.iced.x86.dec.OpCodeHandler_VectorLength_EVEX_er;
import com.github.icedland.iced.x86.dec.OpCodeHandler_W;
import com.github.icedland.iced.x86.dec.TableDeserializer;

final class EvexOpCodeHandlerReader
extends OpCodeHandlerReader {
    EvexOpCodeHandlerReader() {
    }

    @Override
    int readHandlers(TableDeserializer deserializer, OpCodeHandler[] result, int resultIndex) {
        OpCodeHandler elem;
        switch (deserializer.readEvexOpCodeHandlerKind()) {
            case 0: {
                elem = OpCodeHandler_Invalid.Instance;
                break;
            }
            case 1: {
                result[resultIndex] = OpCodeHandler_Invalid.Instance;
                result[resultIndex + 1] = OpCodeHandler_Invalid.Instance;
                return 2;
            }
            case 2: {
                int count = deserializer.readInt32();
                OpCodeHandler handler = deserializer.readHandler();
                for (int i = 0; i < count; ++i) {
                    result[resultIndex + i] = handler;
                }
                return count;
            }
            case 3: {
                elem = deserializer.readHandlerReference();
                break;
            }
            case 4: {
                throw new UnsupportedOperationException();
            }
            case 5: {
                elem = new OpCodeHandler_RM(deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 6: {
                elem = new OpCodeHandler_Group(deserializer.readArrayReference(4));
                break;
            }
            case 7: {
                elem = new OpCodeHandler_W(deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 8: {
                elem = new OpCodeHandler_MandatoryPrefix2(deserializer.readHandler(), deserializer.readHandler(), deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 9: {
                elem = new OpCodeHandler_VectorLength_EVEX(deserializer.readHandler(), deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 10: {
                elem = new OpCodeHandler_VectorLength_EVEX_er(deserializer.readHandler(), deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 11: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_Ed_V_Ib(deserializer.readRegister(), code, code + 1, deserializer.readTupleType(), deserializer.readTupleType());
                break;
            }
            case 12: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_Ev_VX(code, code + 1, deserializer.readTupleType(), deserializer.readTupleType());
                break;
            }
            case 13: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_Ev_VX_Ib(deserializer.readRegister(), code, code + 1);
                break;
            }
            case 14: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_Gv_W_er(deserializer.readRegister(), code, code + 1, deserializer.readTupleType(), deserializer.readBoolean());
                break;
            }
            case 15: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_GvM_VX_Ib(deserializer.readRegister(), code, code + 1, deserializer.readTupleType(), deserializer.readTupleType());
                break;
            }
            case 16: {
                elem = new OpCodeHandler_EVEX_HkWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 17: {
                elem = new OpCodeHandler_EVEX_HkWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 18: {
                elem = new OpCodeHandler_EVEX_HWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 19: {
                elem = new OpCodeHandler_EVEX_KkHW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 20: {
                elem = new OpCodeHandler_EVEX_KkHW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 21: {
                elem = new OpCodeHandler_EVEX_KkHWIb_sae(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 22: {
                elem = new OpCodeHandler_EVEX_KkHWIb_sae(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 23: {
                elem = new OpCodeHandler_EVEX_KkHWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 24: {
                elem = new OpCodeHandler_EVEX_KkHWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 25: {
                elem = new OpCodeHandler_EVEX_KkWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 26: {
                elem = new OpCodeHandler_EVEX_KkWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 27: {
                elem = new OpCodeHandler_EVEX_KP1HW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 28: {
                elem = new OpCodeHandler_EVEX_KR(deserializer.readRegister(), deserializer.readCode());
                break;
            }
            case 29: {
                elem = new OpCodeHandler_EVEX_MV(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 30: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_V_H_Ev_er(deserializer.readRegister(), code, code + 1, deserializer.readTupleType(), deserializer.readTupleType());
                break;
            }
            case 31: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_V_H_Ev_Ib(deserializer.readRegister(), code, code + 1, deserializer.readTupleType(), deserializer.readTupleType());
                break;
            }
            case 32: {
                elem = new OpCodeHandler_EVEX_VHM(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 33: {
                elem = new OpCodeHandler_EVEX_VHW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 34: {
                elem = new OpCodeHandler_EVEX_VHW(deserializer.readRegister(), deserializer.readCode(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 35: {
                elem = new OpCodeHandler_EVEX_VHWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 36: {
                elem = new OpCodeHandler_EVEX_VK(deserializer.readRegister(), deserializer.readCode());
                break;
            }
            case 37: {
                elem = new OpCodeHandler_EVEX_Vk_VSIB(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 38: {
                elem = new OpCodeHandler_EVEX_VkEv_REXW(deserializer.readRegister(), deserializer.readCode());
                break;
            }
            case 39: {
                elem = new OpCodeHandler_EVEX_VkEv_REXW(deserializer.readRegister(), deserializer.readCode(), deserializer.readCode());
                break;
            }
            case 40: {
                elem = new OpCodeHandler_EVEX_VkHM(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 41: {
                elem = new OpCodeHandler_EVEX_VkHW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 42: {
                elem = new OpCodeHandler_EVEX_VkHW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 43: {
                elem = new OpCodeHandler_EVEX_VkHW(deserializer.readRegister(), deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 44: {
                elem = new OpCodeHandler_EVEX_VkHW_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), deserializer.readBoolean(), false);
                break;
            }
            case 45: {
                elem = new OpCodeHandler_EVEX_VkHW_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), deserializer.readBoolean(), true);
                break;
            }
            case 75: {
                elem = new OpCodeHandler_EVEX_VkHW_er_ur(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 76: {
                elem = new OpCodeHandler_EVEX_VkHW_er_ur(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 46: {
                elem = new OpCodeHandler_EVEX_VkHWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 47: {
                elem = new OpCodeHandler_EVEX_VkHWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 48: {
                elem = new OpCodeHandler_EVEX_VkHWIb(deserializer.readRegister(), deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 49: {
                elem = new OpCodeHandler_EVEX_VkHWIb_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 50: {
                elem = new OpCodeHandler_EVEX_VkHWIb_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 51: {
                elem = new OpCodeHandler_EVEX_VkM(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 52: {
                elem = new OpCodeHandler_EVEX_VkW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 53: {
                elem = new OpCodeHandler_EVEX_VkW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 54: {
                elem = new OpCodeHandler_EVEX_VkW(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 55: {
                elem = new OpCodeHandler_EVEX_VkW(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 56: {
                elem = new OpCodeHandler_EVEX_VkW_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), deserializer.readBoolean());
                break;
            }
            case 57: {
                elem = new OpCodeHandler_EVEX_VkW_er(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), deserializer.readBoolean());
                break;
            }
            case 58: {
                elem = new OpCodeHandler_EVEX_VkW_er(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), deserializer.readBoolean(), deserializer.readBoolean());
                break;
            }
            case 59: {
                elem = new OpCodeHandler_EVEX_VkWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), false);
                break;
            }
            case 60: {
                elem = new OpCodeHandler_EVEX_VkWIb(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), true);
                break;
            }
            case 61: {
                elem = new OpCodeHandler_EVEX_VkWIb_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 62: {
                elem = new OpCodeHandler_EVEX_VM(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 63: {
                elem = new OpCodeHandler_EVEX_VSIB_k1(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 64: {
                elem = new OpCodeHandler_EVEX_VSIB_k1_VX(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 65: {
                elem = new OpCodeHandler_EVEX_VW(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 66: {
                elem = new OpCodeHandler_EVEX_VW_er(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 67: {
                int code = deserializer.readCode();
                elem = new OpCodeHandler_EVEX_VX_Ev(code, code + 1, deserializer.readTupleType(), deserializer.readTupleType());
                break;
            }
            case 68: {
                elem = new OpCodeHandler_EVEX_WkHV(deserializer.readRegister(), deserializer.readCode());
                break;
            }
            case 69: {
                elem = new OpCodeHandler_EVEX_WkV(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 70: {
                elem = new OpCodeHandler_EVEX_WkV(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 71: {
                elem = new OpCodeHandler_EVEX_WkV(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType(), deserializer.readBoolean());
                break;
            }
            case 72: {
                elem = new OpCodeHandler_EVEX_WkVIb(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 73: {
                elem = new OpCodeHandler_EVEX_WkVIb_er(deserializer.readRegister(), deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            case 74: {
                elem = new OpCodeHandler_EVEX_WV(deserializer.readRegister(), deserializer.readCode(), deserializer.readTupleType());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        result[resultIndex] = elem;
        return 1;
    }
}

