/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.asm.CodeLabel;
import com.github.icedland.iced.x86.enc.BlockEncoderResult;

public final class CodeAssemblerResult {
    public final BlockEncoderResult[] result;

    CodeAssemblerResult(BlockEncoderResult[] result) {
        this.result = result;
    }

    public long getLabelRIP(CodeLabel label) {
        return this.getLabelRIP(label, 0);
    }

    public long getLabelRIP(CodeLabel label, int index) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid label. Must be created via CodeAssembler.createLabel()");
        }
        if (label.getInstructionIndex() < 0) {
            throw new IllegalArgumentException("The label is not associated with an instruction index. It must be emitted via CodeAssembler.label().");
        }
        if (this.result == null || Integer.compareUnsigned(index, this.result.length) >= 0) {
            throw new IllegalArgumentException("index");
        }
        BlockEncoderResult result = this.result[index];
        if (result.newInstructionOffsets == null || Integer.compareUnsigned(label.getInstructionIndex(), result.newInstructionOffsets.length) >= 0) {
            throw new IllegalArgumentException(String.format("The label instruction index %d is out of range of the instruction offsets results %d. Did you forget to pass BlockEncoderOptions.RETURN_NEW_INSTRUCTION_OFFSETS to CodeAssembler.assemble()?", label.getInstructionIndex(), result.newInstructionOffsets == null ? 0 : result.newInstructionOffsets.length));
        }
        return result.rip + (long)result.newInstructionOffsets[label.getInstructionIndex()];
    }
}

