/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86;

import com.github.icedland.iced.x86.MemorySizeInfo;

public final class MemorySize {
    public static final int UNKNOWN = 0;
    public static final int UINT8 = 1;
    public static final int UINT16 = 2;
    public static final int UINT32 = 3;
    public static final int UINT52 = 4;
    public static final int UINT64 = 5;
    public static final int UINT128 = 6;
    public static final int UINT256 = 7;
    public static final int UINT512 = 8;
    public static final int INT8 = 9;
    public static final int INT16 = 10;
    public static final int INT32 = 11;
    public static final int INT64 = 12;
    public static final int INT128 = 13;
    public static final int INT256 = 14;
    public static final int INT512 = 15;
    public static final int SEG_PTR16 = 16;
    public static final int SEG_PTR32 = 17;
    public static final int SEG_PTR64 = 18;
    public static final int WORD_OFFSET = 19;
    public static final int DWORD_OFFSET = 20;
    public static final int QWORD_OFFSET = 21;
    public static final int BOUND16_WORD_WORD = 22;
    public static final int BOUND32_DWORD_DWORD = 23;
    public static final int BND32 = 24;
    public static final int BND64 = 25;
    public static final int FWORD6 = 26;
    public static final int FWORD10 = 27;
    public static final int FLOAT16 = 28;
    public static final int FLOAT32 = 29;
    public static final int FLOAT64 = 30;
    public static final int FLOAT80 = 31;
    public static final int FLOAT128 = 32;
    public static final int BFLOAT16 = 33;
    public static final int FPU_ENV14 = 34;
    public static final int FPU_ENV28 = 35;
    public static final int FPU_STATE94 = 36;
    public static final int FPU_STATE108 = 37;
    public static final int FXSAVE_512BYTE = 38;
    public static final int FXSAVE64_512BYTE = 39;
    public static final int XSAVE = 40;
    public static final int XSAVE64 = 41;
    public static final int BCD = 42;
    public static final int TILECFG = 43;
    public static final int TILE = 44;
    public static final int SEGMENT_DESC_SELECTOR = 45;
    public static final int KLHANDLE_AES128 = 46;
    public static final int KLHANDLE_AES256 = 47;
    public static final int PACKED16_UINT8 = 48;
    public static final int PACKED16_INT8 = 49;
    public static final int PACKED32_UINT8 = 50;
    public static final int PACKED32_INT8 = 51;
    public static final int PACKED32_UINT16 = 52;
    public static final int PACKED32_INT16 = 53;
    public static final int PACKED32_FLOAT16 = 54;
    public static final int PACKED32_BFLOAT16 = 55;
    public static final int PACKED64_UINT8 = 56;
    public static final int PACKED64_INT8 = 57;
    public static final int PACKED64_UINT16 = 58;
    public static final int PACKED64_INT16 = 59;
    public static final int PACKED64_UINT32 = 60;
    public static final int PACKED64_INT32 = 61;
    public static final int PACKED64_FLOAT16 = 62;
    public static final int PACKED64_FLOAT32 = 63;
    public static final int PACKED128_UINT8 = 64;
    public static final int PACKED128_INT8 = 65;
    public static final int PACKED128_UINT16 = 66;
    public static final int PACKED128_INT16 = 67;
    public static final int PACKED128_UINT32 = 68;
    public static final int PACKED128_INT32 = 69;
    public static final int PACKED128_UINT52 = 70;
    public static final int PACKED128_UINT64 = 71;
    public static final int PACKED128_INT64 = 72;
    public static final int PACKED128_FLOAT16 = 73;
    public static final int PACKED128_FLOAT32 = 74;
    public static final int PACKED128_FLOAT64 = 75;
    public static final int PACKED128_BFLOAT16 = 76;
    public static final int PACKED128_2X_FLOAT16 = 77;
    public static final int PACKED128_2X_BFLOAT16 = 78;
    public static final int PACKED256_UINT8 = 79;
    public static final int PACKED256_INT8 = 80;
    public static final int PACKED256_UINT16 = 81;
    public static final int PACKED256_INT16 = 82;
    public static final int PACKED256_UINT32 = 83;
    public static final int PACKED256_INT32 = 84;
    public static final int PACKED256_UINT52 = 85;
    public static final int PACKED256_UINT64 = 86;
    public static final int PACKED256_INT64 = 87;
    public static final int PACKED256_UINT128 = 88;
    public static final int PACKED256_INT128 = 89;
    public static final int PACKED256_FLOAT16 = 90;
    public static final int PACKED256_FLOAT32 = 91;
    public static final int PACKED256_FLOAT64 = 92;
    public static final int PACKED256_FLOAT128 = 93;
    public static final int PACKED256_BFLOAT16 = 94;
    public static final int PACKED256_2X_FLOAT16 = 95;
    public static final int PACKED256_2X_BFLOAT16 = 96;
    public static final int PACKED512_UINT8 = 97;
    public static final int PACKED512_INT8 = 98;
    public static final int PACKED512_UINT16 = 99;
    public static final int PACKED512_INT16 = 100;
    public static final int PACKED512_UINT32 = 101;
    public static final int PACKED512_INT32 = 102;
    public static final int PACKED512_UINT52 = 103;
    public static final int PACKED512_UINT64 = 104;
    public static final int PACKED512_INT64 = 105;
    public static final int PACKED512_UINT128 = 106;
    public static final int PACKED512_FLOAT16 = 107;
    public static final int PACKED512_FLOAT32 = 108;
    public static final int PACKED512_FLOAT64 = 109;
    public static final int PACKED512_2X_FLOAT16 = 110;
    public static final int PACKED512_2X_BFLOAT16 = 111;
    public static final int BROADCAST32_FLOAT16 = 112;
    public static final int BROADCAST64_UINT32 = 113;
    public static final int BROADCAST64_INT32 = 114;
    public static final int BROADCAST64_FLOAT16 = 115;
    public static final int BROADCAST64_FLOAT32 = 116;
    public static final int BROADCAST128_INT16 = 117;
    public static final int BROADCAST128_UINT16 = 118;
    public static final int BROADCAST128_UINT32 = 119;
    public static final int BROADCAST128_INT32 = 120;
    public static final int BROADCAST128_UINT52 = 121;
    public static final int BROADCAST128_UINT64 = 122;
    public static final int BROADCAST128_INT64 = 123;
    public static final int BROADCAST128_FLOAT16 = 124;
    public static final int BROADCAST128_FLOAT32 = 125;
    public static final int BROADCAST128_FLOAT64 = 126;
    public static final int BROADCAST128_2X_INT16 = 127;
    public static final int BROADCAST128_2X_INT32 = 128;
    public static final int BROADCAST128_2X_UINT32 = 129;
    public static final int BROADCAST128_2X_FLOAT16 = 130;
    public static final int BROADCAST128_2X_BFLOAT16 = 131;
    public static final int BROADCAST256_INT16 = 132;
    public static final int BROADCAST256_UINT16 = 133;
    public static final int BROADCAST256_UINT32 = 134;
    public static final int BROADCAST256_INT32 = 135;
    public static final int BROADCAST256_UINT52 = 136;
    public static final int BROADCAST256_UINT64 = 137;
    public static final int BROADCAST256_INT64 = 138;
    public static final int BROADCAST256_FLOAT16 = 139;
    public static final int BROADCAST256_FLOAT32 = 140;
    public static final int BROADCAST256_FLOAT64 = 141;
    public static final int BROADCAST256_2X_INT16 = 142;
    public static final int BROADCAST256_2X_INT32 = 143;
    public static final int BROADCAST256_2X_UINT32 = 144;
    public static final int BROADCAST256_2X_FLOAT16 = 145;
    public static final int BROADCAST256_2X_BFLOAT16 = 146;
    public static final int BROADCAST512_INT16 = 147;
    public static final int BROADCAST512_UINT16 = 148;
    public static final int BROADCAST512_UINT32 = 149;
    public static final int BROADCAST512_INT32 = 150;
    public static final int BROADCAST512_UINT52 = 151;
    public static final int BROADCAST512_UINT64 = 152;
    public static final int BROADCAST512_INT64 = 153;
    public static final int BROADCAST512_FLOAT16 = 154;
    public static final int BROADCAST512_FLOAT32 = 155;
    public static final int BROADCAST512_FLOAT64 = 156;
    public static final int BROADCAST512_2X_FLOAT16 = 157;
    public static final int BROADCAST512_2X_INT16 = 158;
    public static final int BROADCAST512_2X_UINT32 = 159;
    public static final int BROADCAST512_2X_INT32 = 160;
    public static final int BROADCAST512_2X_BFLOAT16 = 161;

    private MemorySize() {
    }

    public static MemorySizeInfo getInfo(int memorySize) {
        MemorySizeInfo[] infos = MemorySizeInfo.infos;
        return infos[memorySize];
    }

    public static int getSize(int memorySize) {
        return MemorySize.getInfo(memorySize).getSize();
    }

    public static int getElementSize(int memorySize) {
        return MemorySize.getInfo(memorySize).getElementSize();
    }

    public static int getElementType(int memorySize) {
        return MemorySize.getInfo(memorySize).getElementType();
    }

    public static MemorySizeInfo getElementTypeInfo(int memorySize) {
        return MemorySize.getInfo(MemorySize.getInfo(memorySize).getElementType());
    }

    public static boolean isSigned(int memorySize) {
        return MemorySize.getInfo(memorySize).isSigned();
    }

    public static boolean isBroadcast(int memorySize) {
        return Integer.compareUnsigned(memorySize, 112) >= 0;
    }

    public static boolean isPacked(int memorySize) {
        return MemorySize.getInfo(memorySize).isPacked();
    }

    public static int getElementCount(int memorySize) {
        return MemorySize.getInfo(memorySize).getElementCount();
    }
}

