/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86;

import com.github.icedland.iced.x86.Code;
import com.github.icedland.iced.x86.FpuStackIncrementInfo;
import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.InternalInstructionUtils;
import com.github.icedland.iced.x86.MemoryOperand;
import com.github.icedland.iced.x86.VAGetRegisterValue;
import com.github.icedland.iced.x86.enc.InternalEncoderOpCodeHandlers;
import com.github.icedland.iced.x86.enc.Op;
import com.github.icedland.iced.x86.enc.OpCodeHandler;
import com.github.icedland.iced.x86.fmt.StringOutput;
import com.github.icedland.iced.x86.fmt.masm.MasmFormatter;
import com.github.icedland.iced.x86.info.OpCodeInfo;
import com.github.icedland.iced.x86.internal.InstrInfoTable;
import com.github.icedland.iced.x86.internal.InstructionMemorySizes;
import com.github.icedland.iced.x86.internal.InstructionOpCounts;
import com.github.icedland.iced.x86.internal.MvexInfo;
import com.github.icedland.iced.x86.internal.MvexMemorySizeLut;
import com.github.icedland.iced.x86.internal.info.RflagsInfoConstants;

public final class Instruction {
    long nextRip;
    long memDispl;
    int flags1;
    int immediate;
    short code;
    byte memBaseReg;
    byte memIndexReg;
    byte reg0;
    byte reg1;
    byte reg2;
    byte reg3;
    byte opKind0;
    byte opKind1;
    byte opKind2;
    byte opKind3;
    byte scale;
    byte displSize;
    byte len;
    byte pad;

    public Instruction copy() {
        Instruction instr = new Instruction();
        instr.nextRip = this.nextRip;
        instr.memDispl = this.memDispl;
        instr.flags1 = this.flags1;
        instr.immediate = this.immediate;
        instr.code = this.code;
        instr.memBaseReg = this.memBaseReg;
        instr.memIndexReg = this.memIndexReg;
        instr.reg0 = this.reg0;
        instr.reg1 = this.reg1;
        instr.reg2 = this.reg2;
        instr.reg3 = this.reg3;
        instr.opKind0 = this.opKind0;
        instr.opKind1 = this.opKind1;
        instr.opKind2 = this.opKind2;
        instr.opKind3 = this.opKind3;
        instr.scale = this.scale;
        instr.displSize = this.displSize;
        instr.len = this.len;
        instr.pad = this.pad;
        return instr;
    }

    public void clear() {
        this.nextRip = 0L;
        this.memDispl = 0L;
        this.flags1 = 0;
        this.immediate = 0;
        this.code = 0;
        this.memBaseReg = 0;
        this.memIndexReg = 0;
        this.reg0 = 0;
        this.reg1 = 0;
        this.reg2 = 0;
        this.reg3 = 0;
        this.opKind0 = 0;
        this.opKind1 = 0;
        this.opKind2 = 0;
        this.opKind3 = 0;
        this.scale = 0;
        this.displSize = 0;
        this.len = 0;
        this.pad = 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((int)this.memDispl ^ (int)(this.memDispl >>> 32));
        result = 31 * result + (this.flags1 & 0xFFF3FFFF);
        result = 31 * result + this.immediate;
        result = 31 * result + this.code;
        result = 31 * result + this.memBaseReg;
        result = 31 * result + this.memIndexReg;
        result = 31 * result + this.reg3;
        result = 31 * result + this.reg2;
        result = 31 * result + this.reg1;
        result = 31 * result + this.reg0;
        result = 31 * result + this.opKind3;
        result = 31 * result + this.opKind2;
        result = 31 * result + this.opKind1;
        result = 31 * result + this.opKind0;
        result = 31 * result + this.scale;
        result = 31 * result + this.displSize;
        result = 31 * result + this.pad;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instruction other = (Instruction)obj;
        return this.memDispl == other.memDispl && ((this.flags1 ^ other.flags1) & 0xFFF3FFFF) == 0 && this.immediate == other.immediate && this.code == other.code && this.memBaseReg == other.memBaseReg && this.memIndexReg == other.memIndexReg && this.reg0 == other.reg0 && this.reg1 == other.reg1 && this.reg2 == other.reg2 && this.reg3 == other.reg3 && this.opKind0 == other.opKind0 && this.opKind1 == other.opKind1 && this.opKind2 == other.opKind2 && this.opKind3 == other.opKind3 && this.scale == other.scale && this.displSize == other.displSize && this.pad == other.pad;
    }

    public boolean equalsAllBits(Instruction other) {
        if (other == null) {
            return false;
        }
        return this.nextRip == other.nextRip && this.memDispl == other.memDispl && this.flags1 == other.flags1 && this.immediate == other.immediate && this.code == other.code && this.memBaseReg == other.memBaseReg && this.memIndexReg == other.memIndexReg && this.reg0 == other.reg0 && this.reg1 == other.reg1 && this.reg2 == other.reg2 && this.reg3 == other.reg3 && this.opKind0 == other.opKind0 && this.opKind1 == other.opKind1 && this.opKind2 == other.opKind2 && this.opKind3 == other.opKind3 && this.scale == other.scale && this.displSize == other.displSize && this.len == other.len && this.pad == other.pad;
    }

    public String toString() {
        MasmFormatter formatter = new MasmFormatter();
        StringOutput output = new StringOutput();
        formatter.format(this, output);
        return output.toString();
    }

    public short getIP16() {
        return (short)((int)this.nextRip - this.getLength());
    }

    public void setIP16(short value) {
        this.nextRip = value + this.getLength() & 0xFFFF;
    }

    public int getIP32() {
        return (int)this.nextRip - this.getLength();
    }

    public void setIP32(int value) {
        this.nextRip = (long)(value + this.getLength()) & 0xFFFFFFFFL;
    }

    public long getIP() {
        return this.nextRip - (long)this.getLength();
    }

    public void setIP(long value) {
        this.nextRip = value + (long)this.getLength();
    }

    public short getNextIP16() {
        return (short)this.nextRip;
    }

    public void setNextIP16(short value) {
        this.nextRip = value & 0xFFFF;
    }

    public int getNextIP32() {
        return (int)this.nextRip;
    }

    public void setNextIP32(int value) {
        this.nextRip = (long)value & 0xFFFFFFFFL;
    }

    public long getNextIP() {
        return this.nextRip;
    }

    public void setNextIP(long value) {
        this.nextRip = value;
    }

    public int getCodeSize() {
        return this.flags1 >>> 18 & 3;
    }

    public void setCodeSize(int value) {
        this.flags1 = this.flags1 & 0xFFF3FFFF | (value & 3) << 18;
    }

    public boolean isInvalid() {
        return this.code == 0;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int value) {
        if (Integer.compareUnsigned(value, 4936) >= 0) {
            throw new IllegalArgumentException();
        }
        this.code = (short)value;
    }

    public int getMnemonic() {
        return Code.mnemonic(this.getCode());
    }

    public int getOpCount() {
        return InstructionOpCounts.opCount[this.code] & 0xFF;
    }

    public int getLength() {
        return this.len & 0xFF;
    }

    public void setLength(int value) {
        this.len = (byte)value;
    }

    private boolean isXacquireInstr() {
        if (this.getOp0Kind() != 24) {
            return false;
        }
        if (this.getLockPrefix()) {
            return this.getCode() != 2189;
        }
        return this.getMnemonic() == 1509;
    }

    private boolean isXreleaseInstr() {
        if (this.getOp0Kind() != 24) {
            return false;
        }
        if (this.getLockPrefix()) {
            return this.getCode() != 2189;
        }
        switch (this.getCode()) {
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 401: 
            case 403: 
            case 404: 
            case 405: {
                return true;
            }
        }
        return false;
    }

    public boolean getXacquirePrefix() {
        return (this.flags1 & 0x40000000) != 0 && this.isXacquireInstr();
    }

    public void setXacquirePrefix(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x40000000) : (this.flags1 &= 0xBFFFFFFF);
    }

    public boolean getXreleasePrefix() {
        return (this.flags1 & 0x20000000) != 0 && this.isXreleaseInstr();
    }

    public void setXreleasePrefix(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x20000000) : (this.flags1 &= 0xDFFFFFFF);
    }

    public boolean getRepPrefix() {
        return (this.flags1 & 0x20000000) != 0;
    }

    public void setRepPrefix(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x20000000) : (this.flags1 &= 0xDFFFFFFF);
    }

    public boolean getRepePrefix() {
        return (this.flags1 & 0x20000000) != 0;
    }

    public void setRepePrefix(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x20000000) : (this.flags1 &= 0xDFFFFFFF);
    }

    public boolean getRepnePrefix() {
        return (this.flags1 & 0x40000000) != 0;
    }

    public void setRepnePrefix(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x40000000) : (this.flags1 &= 0xBFFFFFFF);
    }

    public boolean getLockPrefix() {
        return (this.flags1 & Integer.MIN_VALUE) != 0;
    }

    public void setLockPrefix(boolean value) {
        this.flags1 = value ? (this.flags1 |= Integer.MIN_VALUE) : (this.flags1 &= Integer.MAX_VALUE);
    }

    public int getOp0Kind() {
        return this.opKind0;
    }

    public void setOp0Kind(int value) {
        this.opKind0 = (byte)value;
    }

    public int getOp1Kind() {
        return this.opKind1;
    }

    public void setOp1Kind(int value) {
        this.opKind1 = (byte)value;
    }

    public int getOp2Kind() {
        return this.opKind2;
    }

    public void setOp2Kind(int value) {
        this.opKind2 = (byte)value;
    }

    public int getOp3Kind() {
        return this.opKind3;
    }

    public void setOp3Kind(int value) {
        this.opKind3 = (byte)value;
    }

    public int getOp4Kind() {
        return 6;
    }

    public void setOp4Kind(int value) {
        if (value != 6) {
            throw new IllegalArgumentException();
        }
    }

    public int getOpKind(int operand) {
        switch (operand) {
            case 0: {
                return this.getOp0Kind();
            }
            case 1: {
                return this.getOp1Kind();
            }
            case 2: {
                return this.getOp2Kind();
            }
            case 3: {
                return this.getOp3Kind();
            }
            case 4: {
                return this.getOp4Kind();
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean hasOpKind(int opKind) {
        for (int i = 0; i < this.getOpCount(); ++i) {
            if (this.getOpKind(i) != opKind) continue;
            return true;
        }
        return false;
    }

    public void setOpKind(int operand, int opKind) {
        switch (operand) {
            case 0: {
                this.setOp0Kind(opKind);
                break;
            }
            case 1: {
                this.setOp1Kind(opKind);
                break;
            }
            case 2: {
                this.setOp2Kind(opKind);
                break;
            }
            case 3: {
                this.setOp3Kind(opKind);
                break;
            }
            case 4: {
                this.setOp4Kind(opKind);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean hasSegmentPrefix() {
        return Integer.compareUnsigned((this.flags1 >>> 5 & 7) - 1, 6) < 0;
    }

    public int getSegmentPrefix() {
        int index = (this.flags1 >>> 5 & 7) - 1;
        return Integer.compareUnsigned(index, 6) < 0 ? 71 + index : 0;
    }

    public void setSegmentPrefix(int value) {
        int encValue = value == 0 ? 0 : value - 71 + 1 & 7;
        this.flags1 = this.flags1 & 0xFFFFFF1F | encValue << 5;
    }

    public int getMemorySegment() {
        int segReg = this.getSegmentPrefix();
        if (segReg != 0) {
            return segReg;
        }
        int baseReg = this.getMemoryBase();
        if (baseReg == 26 || baseReg == 42 || baseReg == 41 || baseReg == 58 || baseReg == 57) {
            return 73;
        }
        return 74;
    }

    public int getMemoryDisplSize() {
        switch (this.displSize) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 8;
    }

    public void setMemoryDisplSize(int value) {
        switch (value) {
            case 0: {
                this.displSize = 0;
                break;
            }
            case 1: {
                this.displSize = 1;
                break;
            }
            case 2: {
                this.displSize = (byte)2;
                break;
            }
            case 4: {
                this.displSize = (byte)3;
                break;
            }
            default: {
                this.displSize = (byte)4;
            }
        }
    }

    public boolean getBroadcast() {
        return (this.flags1 & 0x4000000) != 0;
    }

    public void setBroadcast(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x4000000) : (this.flags1 &= 0xFBFFFFFF);
    }

    public boolean getMvexEvictionHint() {
        return MvexInfo.isMvex(this.getCode()) && (this.immediate & Integer.MIN_VALUE) != 0;
    }

    public void setMvexEvictionHint(boolean value) {
        this.immediate = value ? (this.immediate |= Integer.MIN_VALUE) : (this.immediate &= Integer.MAX_VALUE);
    }

    public int getMvexRegMemConv() {
        if (!MvexInfo.isMvex(this.getCode())) {
            return 0;
        }
        return this.immediate >>> 16 & 0x1F;
    }

    public void setMvexRegMemConv(int value) {
        this.immediate = this.immediate & 0xFFE0FFFF | value << 16;
    }

    public int getMemorySize() {
        int index = this.getCode();
        if (MvexInfo.isMvex(index)) {
            int sss = this.getMvexRegMemConv() - 9 & 7;
            return MvexMemorySizeLut.data[MvexInfo.getTupleTypeLutKind(index) * 8 + sss];
        }
        if (this.getBroadcast()) {
            return InstructionMemorySizes.sizesBcst[index] & 0xFF;
        }
        return InstructionMemorySizes.sizesNormal[index] & 0xFF;
    }

    public int getMemoryIndexScale() {
        return 1 << this.scale;
    }

    public void setMemoryIndexScale(int value) {
        if (value == 1) {
            this.scale = 0;
        } else if (value == 2) {
            this.scale = 1;
        } else if (value == 4) {
            this.scale = (byte)2;
        } else {
            assert (value == 8) : value;
            this.scale = (byte)3;
        }
    }

    public int getRawMemoryIndexScale() {
        return this.scale;
    }

    public void setRawMemoryIndexScale(int value) {
        this.scale = (byte)(value & 3);
    }

    public int getMemoryDisplacement32() {
        return (int)this.memDispl;
    }

    public void setMemoryDisplacement32(int value) {
        this.memDispl = (long)value & 0xFFFFFFFFL;
    }

    public long getMemoryDisplacement64() {
        return this.memDispl;
    }

    public void setMemoryDisplacement64(long value) {
        this.memDispl = value;
    }

    public long getImmediate(int operand) {
        switch (this.getOpKind(operand)) {
            case 6: {
                return this.getImmediate8() & 0xFF;
            }
            case 7: {
                return this.getImmediate8_2nd() & 0xFF;
            }
            case 8: {
                return this.getImmediate16() & 0xFFFF;
            }
            case 9: {
                return (long)this.getImmediate32() & 0xFFFFFFFFL;
            }
            case 10: {
                return this.getImmediate64();
            }
            case 11: {
                return this.getImmediate8to16();
            }
            case 12: {
                return this.getImmediate8to32();
            }
            case 13: {
                return this.getImmediate8to64();
            }
            case 14: {
                return this.getImmediate32to64();
            }
        }
        throw new IllegalArgumentException();
    }

    public void setImmediate(int operand, int immediate) {
        this.setImmediate(operand, (long)immediate);
    }

    public void setImmediate(int operand, long immediate) {
        switch (this.getOpKind(operand)) {
            case 6: {
                this.setImmediate8((byte)immediate);
                break;
            }
            case 11: {
                this.setImmediate8to16((short)immediate);
                break;
            }
            case 12: {
                this.setImmediate8to32((int)immediate);
                break;
            }
            case 13: {
                this.setImmediate8to64(immediate);
                break;
            }
            case 7: {
                this.setImmediate8_2nd((byte)immediate);
                break;
            }
            case 8: {
                this.setImmediate16((short)immediate);
                break;
            }
            case 14: {
                this.setImmediate32to64(immediate);
                break;
            }
            case 9: {
                this.setImmediate32((int)immediate);
                break;
            }
            case 10: {
                this.setImmediate64(immediate);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public byte getImmediate8() {
        return (byte)this.immediate;
    }

    public void setImmediate8(byte value) {
        this.immediate = this.immediate & 0xFFFFFF00 | value & 0xFF;
    }

    public byte getImmediate8_2nd() {
        return (byte)this.memDispl;
    }

    public void setImmediate8_2nd(byte value) {
        this.memDispl = value & 0xFF;
    }

    public short getImmediate16() {
        return (short)this.immediate;
    }

    public void setImmediate16(short value) {
        this.immediate = value & 0xFFFF;
    }

    public int getImmediate32() {
        return this.immediate;
    }

    public void setImmediate32(int value) {
        this.immediate = value;
    }

    public long getImmediate64() {
        return this.memDispl << 32 | (long)this.immediate & 0xFFFFFFFFL;
    }

    public void setImmediate64(long value) {
        this.immediate = (int)value;
        this.memDispl = value >>> 32;
    }

    public short getImmediate8to16() {
        return (byte)this.immediate;
    }

    public void setImmediate8to16(short value) {
        this.immediate = (byte)value;
    }

    public int getImmediate8to32() {
        return (byte)this.immediate;
    }

    public void setImmediate8to32(int value) {
        this.immediate = (byte)value;
    }

    public long getImmediate8to64() {
        return (byte)this.immediate;
    }

    public void setImmediate8to64(long value) {
        this.immediate = (byte)value;
    }

    public long getImmediate32to64() {
        return this.immediate;
    }

    public void setImmediate32to64(long value) {
        this.immediate = (int)value;
    }

    public short getNearBranch16() {
        return (short)this.memDispl;
    }

    public void setNearBranch16(short value) {
        this.memDispl = value & 0xFFFF;
    }

    public int getNearBranch32() {
        return (int)this.memDispl;
    }

    public void setNearBranch32(int value) {
        this.memDispl = (long)value & 0xFFFFFFFFL;
    }

    public long getNearBranch64() {
        return this.memDispl;
    }

    public void setNearBranch64(long value) {
        this.memDispl = value;
    }

    public long getNearBranchTarget() {
        int opKind = this.getOp0Kind();
        if (this.getOpCount() == 2) {
            opKind = this.getOp1Kind();
        }
        switch (opKind) {
            case 1: {
                return this.getNearBranch16() & 0xFFFF;
            }
            case 2: {
                return (long)this.getNearBranch32() & 0xFFFFFFFFL;
            }
            case 3: {
                return this.getNearBranch64();
            }
        }
        return 0L;
    }

    public short getFarBranch16() {
        return (short)this.immediate;
    }

    public void setFarBranch16(short value) {
        this.immediate = value & 0xFFFF;
    }

    public int getFarBranch32() {
        return this.immediate;
    }

    public void setFarBranch32(int value) {
        this.immediate = value;
    }

    public short getFarBranchSelector() {
        return (short)this.memDispl;
    }

    public void setFarBranchSelector(short value) {
        this.memDispl = value & 0xFFFF;
    }

    public int getMemoryBase() {
        return this.memBaseReg & 0xFF;
    }

    public void setMemoryBase(int value) {
        this.memBaseReg = (byte)value;
    }

    public int getMemoryIndex() {
        return this.memIndexReg & 0xFF;
    }

    public void setMemoryIndex(int value) {
        this.memIndexReg = (byte)value;
    }

    public int getOp0Register() {
        return this.reg0 & 0xFF;
    }

    public void setOp0Register(int value) {
        this.reg0 = (byte)value;
    }

    public int getOp1Register() {
        return this.reg1 & 0xFF;
    }

    public void setOp1Register(int value) {
        this.reg1 = (byte)value;
    }

    public int getOp2Register() {
        return this.reg2 & 0xFF;
    }

    public void setOp2Register(int value) {
        this.reg2 = (byte)value;
    }

    public int getOp3Register() {
        return this.reg3 & 0xFF;
    }

    public void setOp3Register(int value) {
        this.reg3 = (byte)value;
    }

    public int getOp4Register() {
        return 0;
    }

    public void setOp4Register(int value) {
        if (value != 0) {
            throw new IllegalArgumentException();
        }
    }

    public int getOpRegister(int operand) {
        switch (operand) {
            case 0: {
                return this.getOp0Register();
            }
            case 1: {
                return this.getOp1Register();
            }
            case 2: {
                return this.getOp2Register();
            }
            case 3: {
                return this.getOp3Register();
            }
            case 4: {
                return this.getOp4Register();
            }
        }
        throw new IllegalArgumentException();
    }

    public void setOpRegister(int operand, int register) {
        switch (operand) {
            case 0: {
                this.setOp0Register(register);
                break;
            }
            case 1: {
                this.setOp1Register(register);
                break;
            }
            case 2: {
                this.setOp2Register(register);
                break;
            }
            case 3: {
                this.setOp3Register(register);
                break;
            }
            case 4: {
                this.setOp4Register(register);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getOpMask() {
        int r = this.flags1 >>> 15 & 7;
        return r == 0 ? 0 : r + 173;
    }

    public void setOpMask(int value) {
        int r = value == 0 ? 0 : value - 173 & 7;
        this.flags1 = this.flags1 & 0xFFFC7FFF | r << 15;
    }

    public int getRawOpMask() {
        return this.flags1 >>> 15 & 7;
    }

    public void setRawOpMask(int value) {
        int r = value & 7;
        this.flags1 = this.flags1 & 0xFFFC7FFF | r << 15;
    }

    public boolean hasOpMask() {
        return (this.flags1 & 0x38000) != 0;
    }

    public boolean getZeroingMasking() {
        return (this.flags1 & 0x10000000) != 0;
    }

    public void setZeroingMasking(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x10000000) : (this.flags1 &= 0xEFFFFFFF);
    }

    public boolean getMergingMasking() {
        return (this.flags1 & 0x10000000) == 0;
    }

    public void setMergingMasking(boolean value) {
        this.flags1 = value ? (this.flags1 &= 0xEFFFFFFF) : (this.flags1 |= 0x10000000);
    }

    public int getRoundingControl() {
        return this.flags1 >>> 12 & 7;
    }

    public void setRoundingControl(int value) {
        this.flags1 = this.flags1 & 0xFFFF8FFF | value << 12;
    }

    public int getDeclareDataCount() {
        return (this.flags1 >>> 8 & 0xF) + 1;
    }

    public void setDeclareDataCount(int value) {
        this.flags1 = this.flags1 & 0xFFFFF0FF | (value - 1 & 0xF) << 8;
    }

    public void setDeclareByteValue(int index, int value) {
        byte v = Instruction.toByte(value);
        switch (index) {
            case 0: {
                this.reg0 = v;
                break;
            }
            case 1: {
                this.reg1 = v;
                break;
            }
            case 2: {
                this.reg2 = v;
                break;
            }
            case 3: {
                this.reg3 = v;
                break;
            }
            case 4: {
                this.immediate = this.immediate & 0xFFFFFF00 | value & 0xFF;
                break;
            }
            case 5: {
                this.immediate = this.immediate & 0xFFFF00FF | (value & 0xFF) << 8;
                break;
            }
            case 6: {
                this.immediate = this.immediate & 0xFF00FFFF | (value & 0xFF) << 16;
                break;
            }
            case 7: {
                this.immediate = this.immediate & 0xFFFFFF | (value & 0xFF) << 24;
                break;
            }
            case 8: {
                this.memDispl = this.memDispl & 0xFFFFFFFFFFFFFF00L | (long)(value & 0xFF);
                break;
            }
            case 9: {
                this.memDispl = this.memDispl & 0xFFFFFFFFFFFF00FFL | (long)(value & 0xFF) << 8;
                break;
            }
            case 10: {
                this.memDispl = this.memDispl & 0xFFFFFFFFFF00FFFFL | (long)(value & 0xFF) << 16;
                break;
            }
            case 11: {
                this.memDispl = this.memDispl & 0xFFFFFFFF00FFFFFFL | (long)(value & 0xFF) << 24;
                break;
            }
            case 12: {
                this.memDispl = this.memDispl & 0xFFFFFF00FFFFFFFFL | (long)(value & 0xFF) << 32;
                break;
            }
            case 13: {
                this.memDispl = this.memDispl & 0xFFFF00FFFFFFFFFFL | (long)(value & 0xFF) << 40;
                break;
            }
            case 14: {
                this.memDispl = this.memDispl & 0xFF00FFFFFFFFFFFFL | (long)(value & 0xFF) << 48;
                break;
            }
            case 15: {
                this.memDispl = this.memDispl & 0xFFFFFFFFFFFFFFL | (long)value << 56;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public byte getDeclareByteValue(int index) {
        switch (index) {
            case 0: {
                return this.reg0;
            }
            case 1: {
                return this.reg1;
            }
            case 2: {
                return this.reg2;
            }
            case 3: {
                return this.reg3;
            }
            case 4: {
                return (byte)this.immediate;
            }
            case 5: {
                return (byte)(this.immediate >>> 8);
            }
            case 6: {
                return (byte)(this.immediate >>> 16);
            }
            case 7: {
                return (byte)(this.immediate >>> 24);
            }
            case 8: {
                return (byte)this.memDispl;
            }
            case 9: {
                return (byte)((int)this.memDispl >>> 8);
            }
            case 10: {
                return (byte)((int)this.memDispl >>> 16);
            }
            case 11: {
                return (byte)((int)this.memDispl >>> 24);
            }
            case 12: {
                return (byte)(this.memDispl >>> 32);
            }
            case 13: {
                return (byte)(this.memDispl >>> 40);
            }
            case 14: {
                return (byte)(this.memDispl >>> 48);
            }
            case 15: {
                return (byte)(this.memDispl >>> 56);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setDeclareWordValue(int index, int value) {
        Instruction.toShort(value);
        switch (index) {
            case 0: {
                this.reg0 = (byte)value;
                this.reg1 = (byte)(value >>> 8);
                break;
            }
            case 1: {
                this.reg2 = (byte)value;
                this.reg3 = (byte)(value >>> 8);
                break;
            }
            case 2: {
                this.immediate = this.immediate & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 3: {
                this.immediate = this.immediate & 0xFFFF | value << 16;
                break;
            }
            case 4: {
                this.memDispl = this.memDispl & 0xFFFFFFFFFFFF0000L | (long)(value & 0xFFFF);
                break;
            }
            case 5: {
                this.memDispl = this.memDispl & 0xFFFFFFFF0000FFFFL | (long)(value & 0xFFFF) << 16;
                break;
            }
            case 6: {
                this.memDispl = this.memDispl & 0xFFFF0000FFFFFFFFL | (long)(value & 0xFFFF) << 32;
                break;
            }
            case 7: {
                this.memDispl = this.memDispl & 0xFFFFFFFFFFFFL | (long)value << 48;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public short getDeclareWordValue(int index) {
        switch (index) {
            case 0: {
                return (short)(this.reg0 & 0xFF | (this.reg1 & 0xFF) << 8);
            }
            case 1: {
                return (short)(this.reg2 & 0xFF | (this.reg3 & 0xFF) << 8);
            }
            case 2: {
                return (short)this.immediate;
            }
            case 3: {
                return (short)(this.immediate >>> 16);
            }
            case 4: {
                return (short)this.memDispl;
            }
            case 5: {
                return (short)((int)this.memDispl >>> 16);
            }
            case 6: {
                return (short)(this.memDispl >>> 32);
            }
            case 7: {
                return (short)(this.memDispl >>> 48);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setDeclareDwordValue(int index, int value) {
        switch (index) {
            case 0: {
                this.reg0 = (byte)value;
                this.reg1 = (byte)(value >>> 8);
                this.reg2 = (byte)(value >>> 16);
                this.reg3 = (byte)(value >>> 24);
                break;
            }
            case 1: {
                this.immediate = value;
                break;
            }
            case 2: {
                this.memDispl = this.memDispl & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
                break;
            }
            case 3: {
                this.memDispl = this.memDispl & 0xFFFFFFFFL | (long)value << 32;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getDeclareDwordValue(int index) {
        switch (index) {
            case 0: {
                return this.reg0 & 0xFF | (this.reg1 & 0xFF) << 8 | (this.reg2 & 0xFF) << 16 | this.reg3 << 24;
            }
            case 1: {
                return this.immediate;
            }
            case 2: {
                return (int)this.memDispl;
            }
            case 3: {
                return (int)(this.memDispl >>> 32);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setDeclareQwordValue(int index, long value) {
        switch (index) {
            case 0: {
                int v = (int)value;
                this.reg0 = (byte)v;
                this.reg1 = (byte)(v >>> 8);
                this.reg2 = (byte)(v >>> 16);
                this.reg3 = (byte)(v >>> 24);
                this.immediate = (int)(value >>> 32);
                break;
            }
            case 1: {
                this.memDispl = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public long getDeclareQwordValue(int index) {
        switch (index) {
            case 0: {
                return (long)(this.reg0 & 0xFF) | (long)((this.reg1 & 0xFF) << 8) | (long)((this.reg2 & 0xFF) << 16) | ((long)this.reg3 & 0xFFL) << 24 | (long)this.immediate << 32;
            }
            case 1: {
                return this.memDispl;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isVsib() {
        return (this.getVsib() & 1) != 0;
    }

    public boolean isVsib32() {
        return (this.getVsib() & 2) != 0;
    }

    public boolean isVsib64() {
        return (this.getVsib() & 4) != 0;
    }

    public int getVsib() {
        switch (this.getCode()) {
            case 3288: 
            case 3289: 
            case 3290: 
            case 3291: 
            case 3292: 
            case 3293: 
            case 3294: 
            case 3295: 
            case 3296: 
            case 3297: 
            case 3308: 
            case 3309: 
            case 3310: 
            case 3311: 
            case 3312: 
            case 3313: 
            case 3314: 
            case 3315: 
            case 3316: 
            case 3317: 
            case 3406: 
            case 3407: 
            case 3408: 
            case 3409: 
            case 3410: 
            case 3411: 
            case 3418: 
            case 3419: 
            case 3420: 
            case 3421: 
            case 3422: 
            case 3423: 
            case 3596: 
            case 3597: 
            case 3598: 
            case 3599: 
            case 3600: 
            case 3601: 
            case 3602: 
            case 3603: 
            case 4723: 
            case 4724: 
            case 4725: 
            case 4726: 
            case 4737: 
            case 4738: 
            case 4739: 
            case 4740: 
            case 4750: 
            case 4751: 
            case 4762: 
            case 4763: 
            case 4764: 
            case 4765: 
            case 4766: 
            case 4767: 
            case 4768: 
            case 4769: 
            case 4770: {
                return 3;
            }
            case 3298: 
            case 3299: 
            case 3300: 
            case 3301: 
            case 3302: 
            case 3303: 
            case 3304: 
            case 3305: 
            case 3306: 
            case 3307: 
            case 3318: 
            case 3319: 
            case 3320: 
            case 3321: 
            case 3322: 
            case 3323: 
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: 
            case 3412: 
            case 3413: 
            case 3414: 
            case 3415: 
            case 3416: 
            case 3417: 
            case 3424: 
            case 3425: 
            case 3426: 
            case 3427: 
            case 3428: 
            case 3429: 
            case 3604: 
            case 3605: 
            case 3606: 
            case 3607: 
            case 3608: 
            case 3609: 
            case 3610: 
            case 3611: {
                return 5;
            }
        }
        return 0;
    }

    public boolean getSuppressAllExceptions() {
        return (this.flags1 & 0x8000000) != 0;
    }

    public void setSuppressAllExceptions(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x8000000) : (this.flags1 &= 0xF7FFFFFF);
    }

    public boolean isIPRelativeMemoryOperand() {
        return this.getMemoryBase() == 70 || this.getMemoryBase() == 69;
    }

    public long ipRelativeMemoryAddress() {
        return this.getMemoryBase() == 69 ? (long)this.getMemoryDisplacement32() & 0xFFFFFFFFL : this.getMemoryDisplacement64();
    }

    public OpCodeInfo getOpCode() {
        return Code.toOpCode(this.getCode());
    }

    public int getStackPointerIncrement() {
        switch (this.getCode()) {
            case 131: {
                return -32;
            }
            case 130: 
            case 762: {
                return -16;
            }
            case 126: 
            case 143: 
            case 149: 
            case 313: 
            case 317: 
            case 693: 
            case 759: 
            case 761: 
            case 771: 
            case 1944: 
            case 1994: {
                return -8;
            }
            case 18: 
            case 34: 
            case 49: 
            case 65: 
            case 125: 
            case 142: 
            case 148: 
            case 312: 
            case 316: 
            case 692: 
            case 758: 
            case 760: 
            case 770: 
            case 1943: 
            case 1993: {
                return -4;
            }
            case 17: 
            case 33: 
            case 48: 
            case 64: 
            case 124: 
            case 141: 
            case 147: 
            case 315: 
            case 691: 
            case 757: 
            case 769: 
            case 1942: 
            case 1992: {
                return -2;
            }
            case 19: 
            case 35: 
            case 50: 
            case 66: 
            case 127: 
            case 296: 
            case 318: 
            case 394: 
            case 1945: 
            case 1995: {
                return 2;
            }
            case 20: 
            case 51: 
            case 67: 
            case 128: 
            case 297: 
            case 319: 
            case 395: 
            case 417: 
            case 1946: 
            case 1996: {
                return 4;
            }
            case 129: 
            case 298: 
            case 320: 
            case 396: 
            case 418: 
            case 1947: 
            case 1997: {
                return 8;
            }
            case 132: 
            case 419: {
                return 16;
            }
            case 4298: {
                return 24;
            }
            case 133: {
                return 32;
            }
            case 425: {
                return 40;
            }
            case 4321: 
            case 4322: {
                return 48;
            }
            case 408: {
                return -(2 + (this.getImmediate8_2nd() & 0x1F) * 2 + (this.getImmediate16() & 0xFFFF));
            }
            case 409: {
                return -(4 + (this.getImmediate8_2nd() & 0x1F) * 4 + (this.getImmediate16() & 0xFFFF));
            }
            case 410: {
                return -(8 + (this.getImmediate8_2nd() & 0x1F) * 8 + (this.getImmediate16() & 0xFFFF));
            }
            case 423: {
                return this.getCodeSize() == 3 ? 10 : 6;
            }
            case 424: {
                return this.getCodeSize() == 3 ? 20 : 12;
            }
            case 391: {
                return 2 + (this.getImmediate16() & 0xFFFF);
            }
            case 392: 
            case 414: {
                return 4 + (this.getImmediate16() & 0xFFFF);
            }
            case 393: 
            case 415: {
                return 8 + (this.getImmediate16() & 0xFFFF);
            }
            case 416: {
                return 16 + (this.getImmediate16() & 0xFFFF);
            }
        }
        return 0;
    }

    public FpuStackIncrementInfo getFpuStackIncrementInfo() {
        switch (this.getCode()) {
            case 510: 
            case 522: 
            case 530: 
            case 531: 
            case 532: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 541: 
            case 543: 
            case 566: 
            case 570: 
            case 605: 
            case 639: 
            case 643: 
            case 644: {
                return new FpuStackIncrementInfo(-1, false, true);
            }
            case 539: 
            case 548: {
                return new FpuStackIncrementInfo(-1, true, true);
            }
            case 513: 
            case 514: 
            case 582: 
            case 583: 
            case 609: 
            case 610: 
            case 611: 
            case 612: 
            case 613: 
            case 614: {
                return new FpuStackIncrementInfo(0, false, true);
            }
            case 497: 
            case 505: 
            case 512: 
            case 525: 
            case 538: 
            case 540: 
            case 544: 
            case 546: 
            case 556: 
            case 567: 
            case 569: 
            case 571: 
            case 592: 
            case 600: 
            case 606: 
            case 608: 
            case 620: 
            case 622: 
            case 626: 
            case 631: 
            case 632: 
            case 633: 
            case 635: 
            case 636: 
            case 637: 
            case 638: 
            case 640: 
            case 642: 
            case 645: 
            case 646: 
            case 647: 
            case 649: 
            case 650: 
            case 655: 
            case 656: 
            case 4269: {
                return new FpuStackIncrementInfo(1, false, true);
            }
            case 565: 
            case 634: {
                return new FpuStackIncrementInfo(2, false, true);
            }
        }
        return new FpuStackIncrementInfo(0, false, false);
    }

    public int getEncoding() {
        return Code.encoding(this.getCode());
    }

    public int[] getCpuidFeatures() {
        return Code.cpuidFeatures(this.getCode());
    }

    public int getFlowControl() {
        return Code.flowControl(this.getCode());
    }

    public boolean isPrivileged() {
        return Code.isPrivileged(this.getCode());
    }

    public boolean isStackInstruction() {
        return Code.isStackInstruction(this.getCode());
    }

    public boolean isSaveRestoreInstruction() {
        return Code.isSaveRestoreInstruction(this.getCode());
    }

    private int getRflagsInfo() {
        int flags1 = InstrInfoTable.data[this.getCode() << 1];
        int impliedAccess = flags1 >>> 20 & 0xFF;
        int result = flags1 >>> 13 & 0x7F;
        int e = impliedAccess - 1;
        switch (e) {
            case 0: 
            case 1: {
                int m = e == 0 ? 9 : 17;
                switch ((this.getImmediate8() & 0x1F) % m) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 25;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                int mask = e == 2 ? 31 : 63;
                switch (this.getImmediate8() & mask) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        if (result == 60) {
                            return 61;
                        }
                        if (result == 24) {
                            return 25;
                        }
                        assert (result == 65) : result;
                        return 63;
                    }
                }
                break;
            }
            case 4: {
                if (this.getOp0Register() != this.getOp1Register() || this.getOp0Kind() != 0 || this.getOp1Kind() != 0) break;
                if (this.getMnemonic() == 1518) {
                    return 8;
                }
                return 6;
            }
        }
        return result;
    }

    public int getRflagsRead() {
        int index = this.getRflagsInfo();
        return RflagsInfoConstants.flagsRead[index];
    }

    public int getRflagsWritten() {
        int index = this.getRflagsInfo();
        return RflagsInfoConstants.flagsWritten[index];
    }

    public int getRflagsCleared() {
        int index = this.getRflagsInfo();
        return RflagsInfoConstants.flagsCleared[index];
    }

    public int getRflagsSet() {
        int index = this.getRflagsInfo();
        return RflagsInfoConstants.flagsSet[index];
    }

    public int getRflagsUndefined() {
        int index = this.getRflagsInfo();
        return RflagsInfoConstants.flagsUndefined[index];
    }

    public int getRflagsModified() {
        int index = this.getRflagsInfo();
        return RflagsInfoConstants.flagsModified[index];
    }

    public boolean isJccShortOrNear() {
        return Code.isJccShortOrNear(this.getCode());
    }

    public boolean isJccNear() {
        return Code.isJccNear(this.getCode());
    }

    public boolean isJccShort() {
        return Code.isJccShort(this.getCode());
    }

    public boolean isJmpShort() {
        return Code.isJmpShort(this.getCode());
    }

    public boolean isJmpNear() {
        return Code.isJmpNear(this.getCode());
    }

    public boolean isJmpShortOrNear() {
        return Code.isJmpShortOrNear(this.getCode());
    }

    public boolean isJmpFar() {
        return Code.isJmpFar(this.getCode());
    }

    public boolean isCallNear() {
        return Code.isCallNear(this.getCode());
    }

    public boolean isCallFar() {
        return Code.isCallFar(this.getCode());
    }

    public boolean isJmpNearIndirect() {
        return Code.isJmpNearIndirect(this.getCode());
    }

    public boolean isJmpFarIndirect() {
        return Code.isJmpFarIndirect(this.getCode());
    }

    public boolean isCallNearIndirect() {
        return Code.isCallNearIndirect(this.getCode());
    }

    public boolean isCallFarIndirect() {
        return Code.isCallFarIndirect(this.getCode());
    }

    public boolean isJkccShortOrNear() {
        return Code.isJkccShortOrNear(this.getCode());
    }

    public boolean isJkccNear() {
        return Code.isJkccNear(this.getCode());
    }

    public boolean isJkccShort() {
        return Code.isJkccShort(this.getCode());
    }

    public boolean isJcxShort() {
        return Code.isJcxShort(this.getCode());
    }

    public boolean isLoopcc() {
        return Code.isLoopcc(this.getCode());
    }

    public boolean isLoop() {
        return Code.isLoop(this.getCode());
    }

    public void negateConditionCode() {
        this.setCode(Code.negateConditionCode(this.getCode()));
    }

    public void toShortBranch() {
        this.setCode(Code.toShortBranch(this.getCode()));
    }

    public void toNearBranch() {
        this.setCode(Code.toNearBranch(this.getCode()));
    }

    public int getConditionCode() {
        return Code.conditionCode(this.getCode());
    }

    public boolean isStringInstruction() {
        return Code.isStringInstruction(this.getCode());
    }

    public Long getVirtualAddress(int operand, int elementIndex, VAGetRegisterValue getRegisterValue) {
        if (getRegisterValue == null) {
            throw new NullPointerException("getRegisterValue");
        }
        switch (this.getOpKind(operand)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 0L;
            }
            case 15: {
                Long base;
                Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                if (seg == null || (base = getRegisterValue.get(27, 0, 0)) == null) break;
                return seg + (base & 0xFFFFL);
            }
            case 16: {
                Long base;
                Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                if (seg == null || (base = getRegisterValue.get(43, 0, 0)) == null) break;
                return seg + (base & 0xFFFFFFFFL);
            }
            case 17: {
                Long base;
                Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                if (seg == null || (base = getRegisterValue.get(59, 0, 0)) == null) break;
                return seg + base;
            }
            case 18: {
                Long base;
                Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                if (seg == null || (base = getRegisterValue.get(28, 0, 0)) == null) break;
                return seg + (base & 0xFFFFL);
            }
            case 19: {
                Long base;
                Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                if (seg == null || (base = getRegisterValue.get(44, 0, 0)) == null) break;
                return seg + (base & 0xFFFFFFFFL);
            }
            case 20: {
                Long base;
                Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                if (seg == null || (base = getRegisterValue.get(60, 0, 0)) == null) break;
                return seg + base;
            }
            case 21: {
                Long base;
                Long seg = getRegisterValue.get(71, 0, 0);
                if (seg == null || (base = getRegisterValue.get(28, 0, 0)) == null) break;
                return seg + (base & 0xFFFFL);
            }
            case 22: {
                Long base;
                Long seg = getRegisterValue.get(71, 0, 0);
                if (seg == null || (base = getRegisterValue.get(44, 0, 0)) == null) break;
                return seg + (base & 0xFFFFFFFFL);
            }
            case 23: {
                Long base;
                Long seg = getRegisterValue.get(71, 0, 0);
                if (seg == null || (base = getRegisterValue.get(60, 0, 0)) == null) break;
                return seg + base;
            }
            case 24: {
                Long base;
                long offsetMask;
                int baseReg = this.getMemoryBase();
                int indexReg = this.getMemoryIndex();
                int addrSize = InternalInstructionUtils.getAddressSizeInBytes(baseReg, indexReg, this.getMemoryDisplSize(), this.getCodeSize());
                long offset = this.getMemoryDisplacement64();
                if (addrSize == 8) {
                    offsetMask = -1L;
                } else if (addrSize == 4) {
                    offsetMask = 0xFFFFFFFFL;
                } else {
                    assert (addrSize == 2) : addrSize;
                    offsetMask = 65535L;
                }
                if (baseReg != 0 && baseReg != 70 && baseReg != 69) {
                    base = getRegisterValue.get(baseReg, 0, 0);
                    if (base == null) break;
                    offset += base.longValue();
                }
                int code = this.getCode();
                if (indexReg != 0 && !Code.ignoresIndex(code) && !Code.isTileStrideIndex(code)) {
                    int vsib = this.getVsib();
                    if ((vsib & 1) != 0) {
                        long base2;
                        if ((vsib & 4) != 0) {
                            base = getRegisterValue.get(indexReg, elementIndex, 8);
                            if (base == null) break;
                            base2 = base;
                        } else {
                            base = getRegisterValue.get(indexReg, elementIndex, 4);
                            if (base == null) break;
                            base2 = (int)base.longValue();
                        }
                        offset += base2 << this.getRawMemoryIndexScale();
                    } else {
                        base = getRegisterValue.get(indexReg, 0, 0);
                        if (base == null) break;
                        offset += base << this.getRawMemoryIndexScale();
                    }
                }
                if (code >= 4791 && code <= 4798) {
                    offset -= 64L;
                }
                offset &= offsetMask;
                if (!Code.ignoresSegment(code)) {
                    Long seg = getRegisterValue.get(this.getMemorySegment(), 0, 0);
                    if (seg == null) break;
                    offset += seg.longValue();
                }
                return offset;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    private static byte toByte(int value) {
        if (-128 <= value && value <= 255) {
            return (byte)value;
        }
        throw new IllegalArgumentException("Invalid byte value, must fit in 8 bits: -0x80 .. 0xFF");
    }

    private static short toShort(int value) {
        if (Short.MIN_VALUE <= value && value <= 65535) {
            return (short)value;
        }
        throw new IllegalArgumentException("Invalid short value, must fit in 16 bits: -0x8000 .. 0xFFFF");
    }

    private static void initializeSignedImmediate(Instruction instruction, int operand, long immediate) {
        int opKind = Instruction.getImmediateOpKind(instruction.getCode(), operand);
        instruction.setOpKind(operand, opKind);
        switch (opKind) {
            case 6: {
                if (-128L > immediate || immediate > 255L) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate8((byte)immediate);
                break;
            }
            case 7: {
                if (-128L > immediate || immediate > 255L) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate8_2nd((byte)immediate);
                break;
            }
            case 11: {
                if (!(-128L <= immediate && immediate <= 127L || 65408L <= immediate && immediate <= 65535L)) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate8((byte)immediate);
                break;
            }
            case 12: {
                if (!(-128L <= immediate && immediate <= 127L || 0xFFFFFF80L <= immediate && immediate <= 0xFFFFFFFFL)) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate8((byte)immediate);
                break;
            }
            case 13: {
                if (-128L > immediate || immediate > 127L) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate8((byte)immediate);
                break;
            }
            case 8: {
                if (-32768L > immediate || immediate > 65535L) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate16((short)immediate);
                break;
            }
            case 9: {
                if (Integer.MIN_VALUE > immediate || immediate > 0xFFFFFFFFL) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate32((int)immediate);
                break;
            }
            case 14: {
                if (Integer.MIN_VALUE > immediate || immediate > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("immediate");
                }
                instruction.setImmediate32((int)immediate);
                break;
            }
            case 10: {
                instruction.setImmediate64(immediate);
                break;
            }
            default: {
                throw new IllegalArgumentException("instruction");
            }
        }
    }

    private static int getImmediateOpKind(int code, int operand) {
        int opKindPrev;
        OpCodeHandler[] handlers = InternalEncoderOpCodeHandlers.handlers;
        if (Integer.compareUnsigned(code, handlers.length) >= 0) {
            throw new IllegalArgumentException("code");
        }
        Op[] operands = handlers[code].operands;
        if (Integer.compareUnsigned(operand, operands.length) >= 0) {
            throw new IllegalArgumentException(String.format("Code %d doesn't have at least %d operands", code, operand + 1));
        }
        int opKind = operands[operand].getImmediateOpKind();
        if (opKind == 6 && operand > 0 && operand + 1 == operands.length && ((opKindPrev = operands[operand - 1].getImmediateOpKind()) == 6 || opKindPrev == 8)) {
            opKind = 7;
        }
        if (opKind == -1) {
            throw new IllegalArgumentException(String.format("Code %d's op%d isn't an immediate operand", code, operand));
        }
        return opKind;
    }

    private static int getNearBranchOpKind(int code, int operand) {
        OpCodeHandler[] handlers = InternalEncoderOpCodeHandlers.handlers;
        if (Integer.compareUnsigned(code, handlers.length) >= 0) {
            throw new IllegalArgumentException("code");
        }
        Op[] operands = handlers[code].operands;
        if (Integer.compareUnsigned(operand, operands.length) >= 0) {
            throw new IllegalArgumentException(String.format("Code %d doesn't have at least %d operands", code, operand + 1));
        }
        int opKind = operands[operand].getNearBranchOpKind();
        if (opKind == -1) {
            throw new IllegalArgumentException(String.format("Code %d's op%d isn't a near branch operand", code, operand));
        }
        return opKind;
    }

    private static int getFarBranchOpKind(int code, int operand) {
        OpCodeHandler[] handlers = InternalEncoderOpCodeHandlers.handlers;
        if (Integer.compareUnsigned(code, handlers.length) >= 0) {
            throw new IllegalArgumentException("code");
        }
        Op[] operands = handlers[code].operands;
        if (Integer.compareUnsigned(operand, operands.length) >= 0) {
            throw new IllegalArgumentException(String.format("Code %d doesn't have at least %d operands", code, operand + 1));
        }
        int opKind = operands[operand].getFarBranchOpKind();
        if (opKind == -1) {
            throw new IllegalArgumentException(String.format("Code %d's op%d isn't a far branch operand", code, operand));
        }
        return opKind;
    }

    private static Instruction createString_Reg_SegRSI(int code, int addressSize, int register, int segmentPrefix, int repPrefix) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        if (repPrefix == 1) {
            instruction.setRepePrefix(true);
        } else if (repPrefix == 2) {
            instruction.setRepnePrefix(true);
        } else assert (repPrefix == 0) : repPrefix;
        instruction.setOp0Register(register);
        if (addressSize == 64) {
            instruction.setOp1Kind(17);
        } else if (addressSize == 32) {
            instruction.setOp1Kind(16);
        } else if (addressSize == 16) {
            instruction.setOp1Kind(15);
        } else {
            throw new IllegalArgumentException("addressSize");
        }
        instruction.setSegmentPrefix(segmentPrefix);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    private static Instruction createString_Reg_ESRDI(int code, int addressSize, int register, int repPrefix) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        if (repPrefix == 1) {
            instruction.setRepePrefix(true);
        } else if (repPrefix == 2) {
            instruction.setRepnePrefix(true);
        } else assert (repPrefix == 0) : repPrefix;
        instruction.setOp0Register(register);
        if (addressSize == 64) {
            instruction.setOp1Kind(23);
        } else if (addressSize == 32) {
            instruction.setOp1Kind(22);
        } else if (addressSize == 16) {
            instruction.setOp1Kind(21);
        } else {
            throw new IllegalArgumentException("addressSize");
        }
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    private static Instruction createString_ESRDI_Reg(int code, int addressSize, int register, int repPrefix) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        if (repPrefix == 1) {
            instruction.setRepePrefix(true);
        } else if (repPrefix == 2) {
            instruction.setRepnePrefix(true);
        } else assert (repPrefix == 0) : repPrefix;
        if (addressSize == 64) {
            instruction.setOp0Kind(23);
        } else if (addressSize == 32) {
            instruction.setOp0Kind(22);
        } else if (addressSize == 16) {
            instruction.setOp0Kind(21);
        } else {
            throw new IllegalArgumentException("addressSize");
        }
        instruction.setOp1Register(register);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    private static Instruction createString_SegRSI_ESRDI(int code, int addressSize, int segmentPrefix, int repPrefix) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        if (repPrefix == 1) {
            instruction.setRepePrefix(true);
        } else if (repPrefix == 2) {
            instruction.setRepnePrefix(true);
        } else assert (repPrefix == 0) : repPrefix;
        if (addressSize == 64) {
            instruction.setOp0Kind(17);
            instruction.setOp1Kind(23);
        } else if (addressSize == 32) {
            instruction.setOp0Kind(16);
            instruction.setOp1Kind(22);
        } else if (addressSize == 16) {
            instruction.setOp0Kind(15);
            instruction.setOp1Kind(21);
        } else {
            throw new IllegalArgumentException("addressSize");
        }
        instruction.setSegmentPrefix(segmentPrefix);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    private static Instruction createString_ESRDI_SegRSI(int code, int addressSize, int segmentPrefix, int repPrefix) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        if (repPrefix == 1) {
            instruction.setRepePrefix(true);
        } else if (repPrefix == 2) {
            instruction.setRepnePrefix(true);
        } else assert (repPrefix == 0) : repPrefix;
        if (addressSize == 64) {
            instruction.setOp0Kind(23);
            instruction.setOp1Kind(17);
        } else if (addressSize == 32) {
            instruction.setOp0Kind(22);
            instruction.setOp1Kind(16);
        } else if (addressSize == 16) {
            instruction.setOp0Kind(21);
            instruction.setOp1Kind(15);
        } else {
            throw new IllegalArgumentException("addressSize");
        }
        instruction.setSegmentPrefix(segmentPrefix);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    private static Instruction createMaskmov(int code, int addressSize, int register1, int register2, int segmentPrefix) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        if (addressSize == 64) {
            instruction.setOp0Kind(20);
        } else if (addressSize == 32) {
            instruction.setOp0Kind(19);
        } else if (addressSize == 16) {
            instruction.setOp0Kind(18);
        } else {
            throw new IllegalArgumentException("addressSize");
        }
        instruction.setOp1Register(register1);
        instruction.setOp2Register(register2);
        instruction.setSegmentPrefix(segmentPrefix);
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    private static void initMemoryOperand(Instruction instruction, MemoryOperand memory) {
        instruction.setMemoryBase(memory.base.get());
        instruction.setMemoryIndex(memory.index.get());
        instruction.setMemoryIndexScale(memory.scale);
        instruction.setMemoryDisplSize(memory.displSize);
        instruction.setMemoryDisplacement64(memory.displacement);
        instruction.setBroadcast(memory.isBroadcast);
        instruction.setSegmentPrefix(memory.segmentPrefix.get());
    }

    public static Instruction create(int code) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register.get());
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        Instruction.initializeSignedImmediate(instruction, 0, immediate);
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, MemoryOperand memory) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register.get());
        Instruction.initializeSignedImmediate(instruction, 1, immediate);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register, long immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register.get());
        Instruction.initializeSignedImmediate(instruction, 1, immediate);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register, MemoryOperand memory) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register.get());
        instruction.setOp1Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, int immediate, ICRegister register) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        Instruction.initializeSignedImmediate(instruction, 0, immediate);
        instruction.setOp1Register(register.get());
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, int immediate1, int immediate2) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        Instruction.initializeSignedImmediate(instruction, 0, immediate1);
        Instruction.initializeSignedImmediate(instruction, 1, immediate2);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, MemoryOperand memory, ICRegister register) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        instruction.setOp1Register(register.get());
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, MemoryOperand memory, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        Instruction.initializeSignedImmediate(instruction, 1, immediate);
        assert (instruction.getOpCount() == 2) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, ICRegister register3) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Register(register3.get());
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        Instruction.initializeSignedImmediate(instruction, 2, immediate);
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, MemoryOperand memory) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register, int immediate1, int immediate2) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register.get());
        Instruction.initializeSignedImmediate(instruction, 1, immediate1);
        Instruction.initializeSignedImmediate(instruction, 2, immediate2);
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, MemoryOperand memory, ICRegister register2) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        instruction.setOp2Register(register2.get());
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register, MemoryOperand memory, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register.get());
        instruction.setOp1Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        Instruction.initializeSignedImmediate(instruction, 2, immediate);
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, MemoryOperand memory, ICRegister register1, ICRegister register2) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        instruction.setOp1Register(register1.get());
        instruction.setOp2Register(register2.get());
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, MemoryOperand memory, ICRegister register, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        instruction.setOp1Register(register.get());
        Instruction.initializeSignedImmediate(instruction, 2, immediate);
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, ICRegister register3, ICRegister register4) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Register(register3.get());
        instruction.setOp3Register(register4.get());
        assert (instruction.getOpCount() == 4) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, ICRegister register3, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Register(register3.get());
        Instruction.initializeSignedImmediate(instruction, 3, immediate);
        assert (instruction.getOpCount() == 4) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, ICRegister register3, MemoryOperand memory) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Register(register3.get());
        instruction.setOp3Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        assert (instruction.getOpCount() == 4) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, int immediate1, int immediate2) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        Instruction.initializeSignedImmediate(instruction, 2, immediate1);
        Instruction.initializeSignedImmediate(instruction, 3, immediate2);
        assert (instruction.getOpCount() == 4) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, MemoryOperand memory, ICRegister register3) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        instruction.setOp3Register(register3.get());
        assert (instruction.getOpCount() == 4) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, MemoryOperand memory, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        Instruction.initializeSignedImmediate(instruction, 3, immediate);
        assert (instruction.getOpCount() == 4) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, ICRegister register3, ICRegister register4, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Register(register3.get());
        instruction.setOp3Register(register4.get());
        Instruction.initializeSignedImmediate(instruction, 4, immediate);
        assert (instruction.getOpCount() == 5) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, ICRegister register3, MemoryOperand memory, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Register(register3.get());
        instruction.setOp3Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        Instruction.initializeSignedImmediate(instruction, 4, immediate);
        assert (instruction.getOpCount() == 5) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction create(int code, ICRegister register1, ICRegister register2, MemoryOperand memory, ICRegister register3, int immediate) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Register(register1.get());
        instruction.setOp1Register(register2.get());
        instruction.setOp2Kind(24);
        Instruction.initMemoryOperand(instruction, memory);
        instruction.setOp3Register(register3.get());
        Instruction.initializeSignedImmediate(instruction, 4, immediate);
        assert (instruction.getOpCount() == 5) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createBranch(int code, long target) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(Instruction.getNearBranchOpKind(code, 0));
        instruction.setNearBranch64(target);
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createBranch(int code, int selector, int offset) {
        Instruction instruction = new Instruction();
        instruction.setCode(code);
        instruction.setOp0Kind(Instruction.getFarBranchOpKind(code, 0));
        instruction.setFarBranchSelector(Instruction.toShort(selector));
        instruction.setFarBranch32(offset);
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createXbegin(int bitness, long target) {
        Instruction instruction = new Instruction();
        switch (bitness) {
            case 16: {
                instruction.setCode(406);
                instruction.setOp0Kind(2);
                instruction.setNearBranch32((int)target);
                break;
            }
            case 32: {
                instruction.setCode(407);
                instruction.setOp0Kind(2);
                instruction.setNearBranch32((int)target);
                break;
            }
            case 64: {
                instruction.setCode(407);
                instruction.setOp0Kind(3);
                instruction.setNearBranch64(target);
                break;
            }
            default: {
                throw new IllegalArgumentException("bitness");
            }
        }
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createOutsb(int addressSize) {
        return Instruction.createString_Reg_SegRSI(156, addressSize, 23, 0, 0);
    }

    public static Instruction createOutsb(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(156, addressSize, 23, segmentPrefix.get(), 0);
    }

    public static Instruction createOutsb(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(156, addressSize, 23, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepOutsb(int addressSize) {
        return Instruction.createString_Reg_SegRSI(156, addressSize, 23, 0, 1);
    }

    public static Instruction createOutsw(int addressSize) {
        return Instruction.createString_Reg_SegRSI(157, addressSize, 23, 0, 0);
    }

    public static Instruction createOutsw(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(157, addressSize, 23, segmentPrefix.get(), 0);
    }

    public static Instruction createOutsw(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(157, addressSize, 23, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepOutsw(int addressSize) {
        return Instruction.createString_Reg_SegRSI(157, addressSize, 23, 0, 1);
    }

    public static Instruction createOutsd(int addressSize) {
        return Instruction.createString_Reg_SegRSI(158, addressSize, 23, 0, 0);
    }

    public static Instruction createOutsd(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(158, addressSize, 23, segmentPrefix.get(), 0);
    }

    public static Instruction createOutsd(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(158, addressSize, 23, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepOutsd(int addressSize) {
        return Instruction.createString_Reg_SegRSI(158, addressSize, 23, 0, 1);
    }

    public static Instruction createLodsb(int addressSize) {
        return Instruction.createString_Reg_SegRSI(347, addressSize, 1, 0, 0);
    }

    public static Instruction createLodsb(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(347, addressSize, 1, segmentPrefix.get(), 0);
    }

    public static Instruction createLodsb(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(347, addressSize, 1, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepLodsb(int addressSize) {
        return Instruction.createString_Reg_SegRSI(347, addressSize, 1, 0, 1);
    }

    public static Instruction createLodsw(int addressSize) {
        return Instruction.createString_Reg_SegRSI(348, addressSize, 21, 0, 0);
    }

    public static Instruction createLodsw(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(348, addressSize, 21, segmentPrefix.get(), 0);
    }

    public static Instruction createLodsw(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(348, addressSize, 21, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepLodsw(int addressSize) {
        return Instruction.createString_Reg_SegRSI(348, addressSize, 21, 0, 1);
    }

    public static Instruction createLodsd(int addressSize) {
        return Instruction.createString_Reg_SegRSI(349, addressSize, 37, 0, 0);
    }

    public static Instruction createLodsd(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(349, addressSize, 37, segmentPrefix.get(), 0);
    }

    public static Instruction createLodsd(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(349, addressSize, 37, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepLodsd(int addressSize) {
        return Instruction.createString_Reg_SegRSI(349, addressSize, 37, 0, 1);
    }

    public static Instruction createLodsq(int addressSize) {
        return Instruction.createString_Reg_SegRSI(350, addressSize, 53, 0, 0);
    }

    public static Instruction createLodsq(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_Reg_SegRSI(350, addressSize, 53, segmentPrefix.get(), 0);
    }

    public static Instruction createLodsq(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_Reg_SegRSI(350, addressSize, 53, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepLodsq(int addressSize) {
        return Instruction.createString_Reg_SegRSI(350, addressSize, 53, 0, 1);
    }

    public static Instruction createScasb(int addressSize) {
        return Instruction.createString_Reg_ESRDI(351, addressSize, 1, 0);
    }

    public static Instruction createScasb(int addressSize, int repPrefix) {
        return Instruction.createString_Reg_ESRDI(351, addressSize, 1, repPrefix);
    }

    public static Instruction createRepeScasb(int addressSize) {
        return Instruction.createString_Reg_ESRDI(351, addressSize, 1, 1);
    }

    public static Instruction createRepneScasb(int addressSize) {
        return Instruction.createString_Reg_ESRDI(351, addressSize, 1, 2);
    }

    public static Instruction createScasw(int addressSize) {
        return Instruction.createString_Reg_ESRDI(352, addressSize, 21, 0);
    }

    public static Instruction createScasw(int addressSize, int repPrefix) {
        return Instruction.createString_Reg_ESRDI(352, addressSize, 21, repPrefix);
    }

    public static Instruction createRepeScasw(int addressSize) {
        return Instruction.createString_Reg_ESRDI(352, addressSize, 21, 1);
    }

    public static Instruction createRepneScasw(int addressSize) {
        return Instruction.createString_Reg_ESRDI(352, addressSize, 21, 2);
    }

    public static Instruction createScasd(int addressSize) {
        return Instruction.createString_Reg_ESRDI(353, addressSize, 37, 0);
    }

    public static Instruction createScasd(int addressSize, int repPrefix) {
        return Instruction.createString_Reg_ESRDI(353, addressSize, 37, repPrefix);
    }

    public static Instruction createRepeScasd(int addressSize) {
        return Instruction.createString_Reg_ESRDI(353, addressSize, 37, 1);
    }

    public static Instruction createRepneScasd(int addressSize) {
        return Instruction.createString_Reg_ESRDI(353, addressSize, 37, 2);
    }

    public static Instruction createScasq(int addressSize) {
        return Instruction.createString_Reg_ESRDI(354, addressSize, 53, 0);
    }

    public static Instruction createScasq(int addressSize, int repPrefix) {
        return Instruction.createString_Reg_ESRDI(354, addressSize, 53, repPrefix);
    }

    public static Instruction createRepeScasq(int addressSize) {
        return Instruction.createString_Reg_ESRDI(354, addressSize, 53, 1);
    }

    public static Instruction createRepneScasq(int addressSize) {
        return Instruction.createString_Reg_ESRDI(354, addressSize, 53, 2);
    }

    public static Instruction createInsb(int addressSize) {
        return Instruction.createString_ESRDI_Reg(153, addressSize, 23, 0);
    }

    public static Instruction createInsb(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(153, addressSize, 23, repPrefix);
    }

    public static Instruction createRepInsb(int addressSize) {
        return Instruction.createString_ESRDI_Reg(153, addressSize, 23, 1);
    }

    public static Instruction createInsw(int addressSize) {
        return Instruction.createString_ESRDI_Reg(154, addressSize, 23, 0);
    }

    public static Instruction createInsw(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(154, addressSize, 23, repPrefix);
    }

    public static Instruction createRepInsw(int addressSize) {
        return Instruction.createString_ESRDI_Reg(154, addressSize, 23, 1);
    }

    public static Instruction createInsd(int addressSize) {
        return Instruction.createString_ESRDI_Reg(155, addressSize, 23, 0);
    }

    public static Instruction createInsd(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(155, addressSize, 23, repPrefix);
    }

    public static Instruction createRepInsd(int addressSize) {
        return Instruction.createString_ESRDI_Reg(155, addressSize, 23, 1);
    }

    public static Instruction createStosb(int addressSize) {
        return Instruction.createString_ESRDI_Reg(343, addressSize, 1, 0);
    }

    public static Instruction createStosb(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(343, addressSize, 1, repPrefix);
    }

    public static Instruction createRepStosb(int addressSize) {
        return Instruction.createString_ESRDI_Reg(343, addressSize, 1, 1);
    }

    public static Instruction createStosw(int addressSize) {
        return Instruction.createString_ESRDI_Reg(344, addressSize, 21, 0);
    }

    public static Instruction createStosw(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(344, addressSize, 21, repPrefix);
    }

    public static Instruction createRepStosw(int addressSize) {
        return Instruction.createString_ESRDI_Reg(344, addressSize, 21, 1);
    }

    public static Instruction createStosd(int addressSize) {
        return Instruction.createString_ESRDI_Reg(345, addressSize, 37, 0);
    }

    public static Instruction createStosd(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(345, addressSize, 37, repPrefix);
    }

    public static Instruction createRepStosd(int addressSize) {
        return Instruction.createString_ESRDI_Reg(345, addressSize, 37, 1);
    }

    public static Instruction createStosq(int addressSize) {
        return Instruction.createString_ESRDI_Reg(346, addressSize, 53, 0);
    }

    public static Instruction createStosq(int addressSize, int repPrefix) {
        return Instruction.createString_ESRDI_Reg(346, addressSize, 53, repPrefix);
    }

    public static Instruction createRepStosq(int addressSize) {
        return Instruction.createString_ESRDI_Reg(346, addressSize, 53, 1);
    }

    public static Instruction createCmpsb(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(335, addressSize, 0, 0);
    }

    public static Instruction createCmpsb(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_SegRSI_ESRDI(335, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createCmpsb(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_SegRSI_ESRDI(335, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepeCmpsb(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(335, addressSize, 0, 1);
    }

    public static Instruction createRepneCmpsb(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(335, addressSize, 0, 2);
    }

    public static Instruction createCmpsw(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(336, addressSize, 0, 0);
    }

    public static Instruction createCmpsw(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_SegRSI_ESRDI(336, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createCmpsw(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_SegRSI_ESRDI(336, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepeCmpsw(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(336, addressSize, 0, 1);
    }

    public static Instruction createRepneCmpsw(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(336, addressSize, 0, 2);
    }

    public static Instruction createCmpsd(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(337, addressSize, 0, 0);
    }

    public static Instruction createCmpsd(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_SegRSI_ESRDI(337, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createCmpsd(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_SegRSI_ESRDI(337, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepeCmpsd(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(337, addressSize, 0, 1);
    }

    public static Instruction createRepneCmpsd(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(337, addressSize, 0, 2);
    }

    public static Instruction createCmpsq(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(338, addressSize, 0, 0);
    }

    public static Instruction createCmpsq(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_SegRSI_ESRDI(338, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createCmpsq(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_SegRSI_ESRDI(338, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepeCmpsq(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(338, addressSize, 0, 1);
    }

    public static Instruction createRepneCmpsq(int addressSize) {
        return Instruction.createString_SegRSI_ESRDI(338, addressSize, 0, 2);
    }

    public static Instruction createMovsb(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(331, addressSize, 0, 0);
    }

    public static Instruction createMovsb(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_ESRDI_SegRSI(331, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createMovsb(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_ESRDI_SegRSI(331, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepMovsb(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(331, addressSize, 0, 1);
    }

    public static Instruction createMovsw(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(332, addressSize, 0, 0);
    }

    public static Instruction createMovsw(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_ESRDI_SegRSI(332, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createMovsw(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_ESRDI_SegRSI(332, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepMovsw(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(332, addressSize, 0, 1);
    }

    public static Instruction createMovsd(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(333, addressSize, 0, 0);
    }

    public static Instruction createMovsd(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_ESRDI_SegRSI(333, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createMovsd(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_ESRDI_SegRSI(333, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepMovsd(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(333, addressSize, 0, 1);
    }

    public static Instruction createMovsq(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(334, addressSize, 0, 0);
    }

    public static Instruction createMovsq(int addressSize, ICRegister segmentPrefix) {
        return Instruction.createString_ESRDI_SegRSI(334, addressSize, segmentPrefix.get(), 0);
    }

    public static Instruction createMovsq(int addressSize, ICRegister segmentPrefix, int repPrefix) {
        return Instruction.createString_ESRDI_SegRSI(334, addressSize, segmentPrefix.get(), repPrefix);
    }

    public static Instruction createRepMovsq(int addressSize) {
        return Instruction.createString_ESRDI_SegRSI(334, addressSize, 0, 1);
    }

    public static Instruction createMaskmovq(int addressSize, ICRegister register1, ICRegister register2) {
        return Instruction.createMaskmov(2507, addressSize, register1.get(), register2.get(), 0);
    }

    public static Instruction createMaskmovq(int addressSize, ICRegister register1, ICRegister register2, ICRegister segmentPrefix) {
        return Instruction.createMaskmov(2507, addressSize, register1.get(), register2.get(), segmentPrefix.get());
    }

    public static Instruction createMaskmovdqu(int addressSize, ICRegister register1, ICRegister register2) {
        return Instruction.createMaskmov(2508, addressSize, register1.get(), register2.get(), 0);
    }

    public static Instruction createMaskmovdqu(int addressSize, ICRegister register1, ICRegister register2, ICRegister segmentPrefix) {
        return Instruction.createMaskmov(2508, addressSize, register1.get(), register2.get(), segmentPrefix.get());
    }

    public static Instruction createVmaskmovdqu(int addressSize, ICRegister register1, ICRegister register2) {
        return Instruction.createMaskmov(2509, addressSize, register1.get(), register2.get(), 0);
    }

    public static Instruction createVmaskmovdqu(int addressSize, ICRegister register1, ICRegister register2, ICRegister segmentPrefix) {
        return Instruction.createMaskmov(2509, addressSize, register1.get(), register2.get(), segmentPrefix.get());
    }

    public static Instruction createDeclareByte(int b0) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(1);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(2);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(3);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(4);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(5);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(6);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(7);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(8);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(9);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(10);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(11);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        instruction.setDeclareByteValue(10, Instruction.toByte(b10));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10, int b11) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(12);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        instruction.setDeclareByteValue(10, Instruction.toByte(b10));
        instruction.setDeclareByteValue(11, Instruction.toByte(b11));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10, int b11, int b12) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(13);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        instruction.setDeclareByteValue(10, Instruction.toByte(b10));
        instruction.setDeclareByteValue(11, Instruction.toByte(b11));
        instruction.setDeclareByteValue(12, Instruction.toByte(b12));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10, int b11, int b12, int b13) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(14);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        instruction.setDeclareByteValue(10, Instruction.toByte(b10));
        instruction.setDeclareByteValue(11, Instruction.toByte(b11));
        instruction.setDeclareByteValue(12, Instruction.toByte(b12));
        instruction.setDeclareByteValue(13, Instruction.toByte(b13));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10, int b11, int b12, int b13, int b14) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(15);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        instruction.setDeclareByteValue(10, Instruction.toByte(b10));
        instruction.setDeclareByteValue(11, Instruction.toByte(b11));
        instruction.setDeclareByteValue(12, Instruction.toByte(b12));
        instruction.setDeclareByteValue(13, Instruction.toByte(b13));
        instruction.setDeclareByteValue(14, Instruction.toByte(b14));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10, int b11, int b12, int b13, int b14, int b15) {
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(16);
        instruction.setDeclareByteValue(0, Instruction.toByte(b0));
        instruction.setDeclareByteValue(1, Instruction.toByte(b1));
        instruction.setDeclareByteValue(2, Instruction.toByte(b2));
        instruction.setDeclareByteValue(3, Instruction.toByte(b3));
        instruction.setDeclareByteValue(4, Instruction.toByte(b4));
        instruction.setDeclareByteValue(5, Instruction.toByte(b5));
        instruction.setDeclareByteValue(6, Instruction.toByte(b6));
        instruction.setDeclareByteValue(7, Instruction.toByte(b7));
        instruction.setDeclareByteValue(8, Instruction.toByte(b8));
        instruction.setDeclareByteValue(9, Instruction.toByte(b9));
        instruction.setDeclareByteValue(10, Instruction.toByte(b10));
        instruction.setDeclareByteValue(11, Instruction.toByte(b11));
        instruction.setDeclareByteValue(12, Instruction.toByte(b12));
        instruction.setDeclareByteValue(13, Instruction.toByte(b13));
        instruction.setDeclareByteValue(14, Instruction.toByte(b14));
        instruction.setDeclareByteValue(15, Instruction.toByte(b15));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareByte(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareByte(data, 0, data.length);
    }

    public static Instruction createDeclareByte(byte[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 15) > 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(1);
        instruction.setDeclareDataCount(length);
        for (int i = 0; i < length; ++i) {
            instruction.setDeclareByteValue(i, data[index + i]);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(1);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(2);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1, int w2) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(3);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        instruction.setDeclareWordValue(2, Instruction.toShort(w2));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1, int w2, int w3) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(4);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        instruction.setDeclareWordValue(2, Instruction.toShort(w2));
        instruction.setDeclareWordValue(3, Instruction.toShort(w3));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1, int w2, int w3, int w4) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(5);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        instruction.setDeclareWordValue(2, Instruction.toShort(w2));
        instruction.setDeclareWordValue(3, Instruction.toShort(w3));
        instruction.setDeclareWordValue(4, Instruction.toShort(w4));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1, int w2, int w3, int w4, int w5) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(6);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        instruction.setDeclareWordValue(2, Instruction.toShort(w2));
        instruction.setDeclareWordValue(3, Instruction.toShort(w3));
        instruction.setDeclareWordValue(4, Instruction.toShort(w4));
        instruction.setDeclareWordValue(5, Instruction.toShort(w5));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1, int w2, int w3, int w4, int w5, int w6) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(7);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        instruction.setDeclareWordValue(2, Instruction.toShort(w2));
        instruction.setDeclareWordValue(3, Instruction.toShort(w3));
        instruction.setDeclareWordValue(4, Instruction.toShort(w4));
        instruction.setDeclareWordValue(5, Instruction.toShort(w5));
        instruction.setDeclareWordValue(6, Instruction.toShort(w6));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(int w0, int w1, int w2, int w3, int w4, int w5, int w6, int w7) {
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(8);
        instruction.setDeclareWordValue(0, Instruction.toShort(w0));
        instruction.setDeclareWordValue(1, Instruction.toShort(w1));
        instruction.setDeclareWordValue(2, Instruction.toShort(w2));
        instruction.setDeclareWordValue(3, Instruction.toShort(w3));
        instruction.setDeclareWordValue(4, Instruction.toShort(w4));
        instruction.setDeclareWordValue(5, Instruction.toShort(w5));
        instruction.setDeclareWordValue(6, Instruction.toShort(w6));
        instruction.setDeclareWordValue(7, Instruction.toShort(w7));
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareWord(data, 0, data.length);
    }

    public static Instruction createDeclareWord(byte[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 15) > 0 || (length & 1) != 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(length / 2);
        for (int i = 0; i < length; i += 2) {
            int v = data[index + i] & 0xFF | (data[index + i + 1] & 0xFF) << 8;
            instruction.setDeclareWordValue(i / 2, (short)v);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareWord(short[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareWord(data, 0, data.length);
    }

    public static Instruction createDeclareWord(short[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 7) > 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(2);
        instruction.setDeclareDataCount(length);
        for (int i = 0; i < length; ++i) {
            instruction.setDeclareWordValue(i, data[index + i]);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareDword(int d0) {
        Instruction instruction = new Instruction();
        instruction.setCode(3);
        instruction.setDeclareDataCount(1);
        instruction.setDeclareDwordValue(0, d0);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareDword(int d0, int d1) {
        Instruction instruction = new Instruction();
        instruction.setCode(3);
        instruction.setDeclareDataCount(2);
        instruction.setDeclareDwordValue(0, d0);
        instruction.setDeclareDwordValue(1, d1);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareDword(int d0, int d1, int d2) {
        Instruction instruction = new Instruction();
        instruction.setCode(3);
        instruction.setDeclareDataCount(3);
        instruction.setDeclareDwordValue(0, d0);
        instruction.setDeclareDwordValue(1, d1);
        instruction.setDeclareDwordValue(2, d2);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareDword(int d0, int d1, int d2, int d3) {
        Instruction instruction = new Instruction();
        instruction.setCode(3);
        instruction.setDeclareDataCount(4);
        instruction.setDeclareDwordValue(0, d0);
        instruction.setDeclareDwordValue(1, d1);
        instruction.setDeclareDwordValue(2, d2);
        instruction.setDeclareDwordValue(3, d3);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareDword(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareDword(data, 0, data.length);
    }

    public static Instruction createDeclareDword(byte[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 15) > 0 || (length & 3) != 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(3);
        instruction.setDeclareDataCount(length / 4);
        for (int i = 0; i < length; i += 4) {
            int v = data[index + i] & 0xFF | (data[index + i + 1] & 0xFF) << 8 | (data[index + i + 2] & 0xFF) << 16 | data[index + i + 3] << 24;
            instruction.setDeclareDwordValue(i / 4, v);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareDword(int[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareDword(data, 0, data.length);
    }

    public static Instruction createDeclareDword(int[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 3) > 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(3);
        instruction.setDeclareDataCount(length);
        for (int i = 0; i < length; ++i) {
            instruction.setDeclareDwordValue(i, data[index + i]);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareQword(long q0) {
        Instruction instruction = new Instruction();
        instruction.setCode(4);
        instruction.setDeclareDataCount(1);
        instruction.setDeclareQwordValue(0, q0);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareQword(long q0, long q1) {
        Instruction instruction = new Instruction();
        instruction.setCode(4);
        instruction.setDeclareDataCount(2);
        instruction.setDeclareQwordValue(0, q0);
        instruction.setDeclareQwordValue(1, q1);
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareQword(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareQword(data, 0, data.length);
    }

    public static Instruction createDeclareQword(byte[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 15) > 0 || (length & 7) != 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(4);
        instruction.setDeclareDataCount(length / 8);
        for (int i = 0; i < length; i += 8) {
            int v1 = data[index + i] & 0xFF | (data[index + i + 1] & 0xFF) << 8 | (data[index + i + 2] & 0xFF) << 16 | data[index + i + 3] << 24;
            int v2 = data[index + i + 4] & 0xFF | (data[index + i + 5] & 0xFF) << 8 | (data[index + i + 6] & 0xFF) << 16 | data[index + i + 7] << 24;
            instruction.setDeclareQwordValue(i / 8, (long)v1 & 0xFFFFFFFFL | (long)v2 << 32);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }

    public static Instruction createDeclareQword(long[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return Instruction.createDeclareQword(data, 0, data.length);
    }

    public static Instruction createDeclareQword(long[] data, int index, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (Integer.compareUnsigned(length - 1, 1) > 0) {
            throw new IllegalArgumentException("length");
        }
        if (Long.compareUnsigned(((long)index & 0xFFFFFFFFL) + ((long)length & 0xFFFFFFFFL), (long)data.length & 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("index");
        }
        Instruction instruction = new Instruction();
        instruction.setCode(4);
        instruction.setDeclareDataCount(length);
        for (int i = 0; i < length; ++i) {
            instruction.setDeclareQwordValue(i, data[index + i]);
        }
        assert (instruction.getOpCount() == 0) : instruction.getOpCount();
        return instruction;
    }
}

