/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal.fmt;

import java.util.Locale;

public final class FormatterString {
    private final String lower;
    private final String upper;

    public int getLength() {
        return this.lower.length();
    }

    public FormatterString(String lower) {
        assert (lower.toLowerCase(Locale.ROOT) == lower) : lower;
        this.lower = lower;
        this.upper = lower.toUpperCase(Locale.ROOT).intern();
    }

    public static FormatterString[] create(String[] strings) {
        FormatterString[] res = new FormatterString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            res[i] = new FormatterString(strings[i]);
        }
        return res;
    }

    public String get(boolean upper) {
        return upper ? this.upper : this.lower;
    }

    public String getLower() {
        return this.lower;
    }
}

