/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal.fmt;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.FormatterOutput;
import com.github.icedland.iced.x86.fmt.NumberFormattingOptions;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import com.github.icedland.iced.x86.internal.fmt.NumberFormatter;

@Deprecated
public final class FormatterOutputExt {
    private FormatterOutputExt() {
    }

    public static void write(FormatterOutput output, Instruction instruction, int operand, int instructionOperand, FormatterOptions options, NumberFormatter numberFormatter, NumberFormattingOptions numberOptions, long address, SymbolResult symbol, boolean showSymbolAddress) {
        FormatterOutputExt.write(output, instruction, operand, instructionOperand, options, numberFormatter, numberOptions, address, symbol, showSymbolAddress, true, false);
    }

    public static void write(FormatterOutput output, Instruction instruction, int operand, int instructionOperand, FormatterOptions options, NumberFormatter numberFormatter, NumberFormattingOptions numberOptions, long address, SymbolResult symbol, boolean showSymbolAddress, boolean writeMinusIfSigned, boolean spacesBetweenOp) {
        int numberKind;
        long displ = address - symbol.address;
        if ((symbol.flags & 2) != 0) {
            if (writeMinusIfSigned) {
                output.write("-", 5);
            }
            displ = -displ;
        }
        output.writeSymbol(instruction, operand, instructionOperand, address, symbol);
        if (displ != 0L) {
            if (spacesBetweenOp) {
                output.write(" ", 0);
            }
            long origDispl = displ;
            if (displ < 0L) {
                output.write("-", 5);
                displ = -displ;
                numberKind = displ <= 128L ? 0 : (displ <= 32768L ? 2 : (displ <= 0x80000000L ? 4 : 6));
            } else {
                output.write("+", 5);
                numberKind = displ <= 127L ? 0 : (displ <= 32767L ? 2 : (displ <= Integer.MAX_VALUE ? 4 : 6));
            }
            if (spacesBetweenOp) {
                output.write(" ", 0);
            }
            String s = numberFormatter.formatUInt64(options, numberOptions, displ, false);
            output.writeNumber(instruction, operand, instructionOperand, s, origDispl, numberKind, 7);
        }
        if (showSymbolAddress) {
            String s;
            output.write(" ", 0);
            output.write("(", 6);
            if (Long.compareUnsigned(address, 65535L) <= 0) {
                s = numberFormatter.formatUInt16(options, numberOptions, (short)address, true);
                numberKind = 3;
            } else if (Long.compareUnsigned(address, 0xFFFFFFFFL) <= 0) {
                s = numberFormatter.formatUInt32(options, numberOptions, (int)address, true);
                numberKind = 5;
            } else {
                s = numberFormatter.formatUInt64(options, numberOptions, address, true);
                numberKind = 7;
            }
            output.writeNumber(instruction, operand, instructionOperand, s, address, numberKind, 7);
            output.write(")", 6);
        }
    }
}

