/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ResourceReader {
    private static byte[] readAllBytes(InputStream stream) throws IOException {
        int read;
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while ((read = stream.read(buffer)) != -1) {
            result.write(buffer, 0, read);
        }
        return result.toByteArray();
    }

    public static byte[] readByteArray(ClassLoader classLoader, String resourceName) {
        byte[] byArray;
        block9: {
            InputStream stream = classLoader.getResourceAsStream(resourceName);
            try {
                if (stream == null) {
                    throw new IllegalArgumentException(String.format("Missing resource: %s", resourceName));
                }
                byArray = ResourceReader.readAllBytes(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioex) {
                    throw new IllegalArgumentException(ioex);
                }
            }
            stream.close();
        }
        return byArray;
    }

    public static short[] readShortArray(ClassLoader classLoader, String resourceName) {
        byte[] bytes;
        try (InputStream stream = classLoader.getResourceAsStream(resourceName);){
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Missing resource: %s", resourceName));
            }
            bytes = ResourceReader.readAllBytes(stream);
        }
        catch (IOException ioex) {
            throw new IllegalArgumentException(ioex);
        }
        if ((bytes.length & 1) != 0) {
            throw new IllegalArgumentException();
        }
        short[] result = new short[bytes.length / 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            result[j] = (short)(bytes[i] & 0xFF | bytes[i + 1] << 8);
            i += 2;
            ++j;
        }
        return result;
    }

    public static int[] readIntArray(ClassLoader classLoader, String resourceName) {
        byte[] bytes;
        try (InputStream stream = classLoader.getResourceAsStream(resourceName);){
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Missing resource: %s", resourceName));
            }
            bytes = ResourceReader.readAllBytes(stream);
        }
        catch (IOException ioex) {
            throw new IllegalArgumentException(ioex);
        }
        if ((bytes.length & 3) != 0) {
            throw new IllegalArgumentException();
        }
        int[] result = new int[bytes.length / 4];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            result[j] = bytes[i] & 0xFF | (bytes[i + 1] & 0xFF) << 8 | (bytes[i + 2] & 0xFF) << 16 | bytes[i + 3] << 24;
            i += 4;
            ++j;
        }
        return result;
    }
}

