/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal;

import com.github.icedland.iced.x86.internal.MvexTupleTypeLut;
import com.github.icedland.iced.x86.internal.ResourceReader;

public final class MvexInfo {
    private static final byte[] data = ResourceReader.readByteArray(MvexInfo.class.getClassLoader(), "com/github/icedland/iced/x86/MvexInfoData.bin");

    public static boolean isMvex(int code) {
        return Integer.compareUnsigned(code - 4611, 207) < 0;
    }

    public static int getTupleTypeLutKind(int code) {
        int index = code - 4611;
        return data[index * 8 + 0];
    }

    public static int getEHBit(int code) {
        int index = code - 4611;
        return data[index * 8 + 1];
    }

    public static int getConvFn(int code) {
        int index = code - 4611;
        return data[index * 8 + 2];
    }

    public static int getInvalidConvFns(int code) {
        int index = code - 4611;
        return data[index * 8 + 3];
    }

    public static int getInvalidSwizzleFns(int code) {
        int index = code - 4611;
        return data[index * 8 + 4];
    }

    public static boolean isNDD(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 1) != 0;
    }

    public static boolean isNDS(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 2) != 0;
    }

    public static boolean canUseEvictionHint(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 4) != 0;
    }

    public static boolean canUseImmRoundingControl(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 8) != 0;
    }

    public static boolean canUseRoundingControl(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 0x10) != 0;
    }

    public static boolean canUseSuppressAllExceptions(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 0x20) != 0;
    }

    public static boolean getIgnoresOpMaskRegister(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 0x40) != 0;
    }

    public static boolean getRequireOpMaskRegister(int code) {
        int index = code - 4611;
        return (data[index * 8 + 5] & 0x80) != 0;
    }

    public static boolean getNoSaeRc(int code) {
        int index = code - 4611;
        return (data[index * 8 + 6] & 1) != 0;
    }

    public static boolean isConvFn32(int code) {
        int index = code - 4611;
        return (data[index * 8 + 6] & 2) != 0;
    }

    public static boolean getIgnoresEvictionHint(int code) {
        int index = code - 4611;
        return (data[index * 8 + 6] & 4) != 0;
    }

    public static int getTupleType(int code, int sss) {
        return MvexTupleTypeLut.data[MvexInfo.getTupleTypeLutKind(code) * 8 + sss];
    }
}

