/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.info;

import com.github.icedland.iced.x86.info.OpCodeInfo;
import com.github.icedland.iced.x86.internal.MvexInfo;

final class OpCodeFormatter {
    private final OpCodeInfo opCode;
    private final StringBuilder sb;
    private final int lkind;
    private final boolean hasModrmInfo;

    public OpCodeFormatter(OpCodeInfo opCode, StringBuilder sb, int lkind, boolean hasModrmInfo) {
        this.opCode = opCode;
        this.sb = sb;
        this.lkind = lkind;
        this.hasModrmInfo = hasModrmInfo;
    }

    public String format() {
        if (!this.opCode.isInstruction()) {
            switch (this.opCode.getCode()) {
                case 0: {
                    return "<invalid>";
                }
                case 1: {
                    return "<db>";
                }
                case 2: {
                    return "<dw>";
                }
                case 3: {
                    return "<dd>";
                }
                case 4: {
                    return "<dq>";
                }
                case 4833: {
                    return "<zero_bytes>";
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (this.opCode.getEncoding()) {
            case 0: {
                return this.format_Legacy();
            }
            case 1: {
                return this.formatVecEncoding("VEX");
            }
            case 2: {
                return this.formatVecEncoding("EVEX");
            }
            case 3: {
                return this.formatVecEncoding("XOP");
            }
            case 4: {
                return this.format_3DNow();
            }
            case 5: {
                return this.formatVecEncoding("MVEX");
            }
        }
        throw new UnsupportedOperationException();
    }

    private void appendHexByte(int value) {
        this.sb.append(String.format("%02X", value & 0xFF));
    }

    private void appendOpCode(int value, int valueLen, boolean sep) {
        if (valueLen == 1) {
            this.appendHexByte((byte)value);
        } else {
            assert (valueLen == 2) : valueLen;
            this.appendHexByte((byte)(value >>> 8));
            if (sep) {
                this.sb.append(' ');
            }
            this.appendHexByte((byte)value);
        }
    }

    private void appendTable(boolean sep) {
        switch (this.opCode.getTable()) {
            case 0: {
                break;
            }
            case 1: {
                this.appendOpCode(15, 1, sep);
                break;
            }
            case 2: {
                this.appendOpCode(3896, 2, sep);
                break;
            }
            case 3: {
                this.appendOpCode(3898, 2, sep);
                break;
            }
            case 4: {
                this.sb.append("MAP5");
                break;
            }
            case 5: {
                this.sb.append("MAP6");
                break;
            }
            case 6: {
                this.sb.append("X8");
                break;
            }
            case 7: {
                this.sb.append("X9");
                break;
            }
            case 8: {
                this.sb.append("XA");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private boolean hasModRM() {
        int opCount = this.opCode.getOpCount();
        if (opCount == 0) {
            return false;
        }
        switch (this.opCode.getEncoding()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        for (int i = 0; i < opCount; ++i) {
            switch (this.opCode.getOpKind(i)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 33: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 54: 
                case 55: 
                case 59: 
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 105: 
                case 106: 
                case 107: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasVsib() {
        int opCount = this.opCode.getOpCount();
        for (int i = 0; i < opCount; ++i) {
            switch (this.opCode.getOpKind(i)) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return true;
                }
            }
        }
        return false;
    }

    private int getOpCodeBitsOperand() {
        int opCount = this.opCode.getOpCount();
        for (int i = 0; i < opCount; ++i) {
            int opKind = this.opCode.getOpKind(i);
            switch (opKind) {
                case 26: 
                case 30: 
                case 34: 
                case 39: {
                    return opKind;
                }
            }
        }
        return 0;
    }

    private ModrmInfo tryGetModrmInfo() {
        boolean isRegOnly = true;
        int rrr = this.opCode.getGroupIndex();
        int bbb = this.opCode.getRmGroupIndex();
        if (!this.hasModrmInfo) {
            return null;
        }
        int opCount = this.opCode.getOpCount();
        block4: for (int i = 0; i < opCount; ++i) {
            switch (this.opCode.getOpKind(i)) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    isRegOnly = false;
                    continue block4;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 105: {
                    isRegOnly = false;
                    bbb = 4;
                }
            }
        }
        return new ModrmInfo(isRegOnly, rrr, bbb);
    }

    private void appendBits(String name, int bits, int numBits) {
        if (bits < 0) {
            this.sb.append(name);
        } else {
            for (int i = numBits - 1; i >= 0; --i) {
                if ((bits >>> i & 1) != 0) {
                    this.sb.append('1');
                    continue;
                }
                this.sb.append('0');
            }
        }
    }

    private void appendRest() {
        ModrmInfo info = this.tryGetModrmInfo();
        if (info != null) {
            if (info.isRegOnly) {
                this.sb.append(" 11:");
            } else {
                this.sb.append(" !(11):");
            }
            this.appendBits("rrr", info.rrr, 3);
            this.sb.append(':');
            this.appendBits("bbb", info.bbb, 3);
        } else {
            boolean isVsib;
            boolean bl = isVsib = (this.opCode.getEncoding() == 2 || this.opCode.getEncoding() == 5) && this.hasVsib();
            if (this.opCode.isGroup()) {
                this.sb.append(" /");
                this.sb.append(this.opCode.getGroupIndex());
            } else if (!isVsib && this.hasModRM()) {
                this.sb.append(" /r");
            }
            if (isVsib) {
                this.sb.append(" /vsib");
            }
        }
        int opCount = this.opCode.getOpCount();
        block13: for (int i = 0; i < opCount; ++i) {
            switch (this.opCode.getOpKind(i)) {
                case 95: 
                case 96: 
                case 97: {
                    this.sb.append(" cb");
                    continue block13;
                }
                case 98: 
                case 101: 
                case 103: {
                    this.sb.append(" cw");
                    continue block13;
                }
                case 1: 
                case 99: 
                case 100: 
                case 102: 
                case 104: {
                    this.sb.append(" cd");
                    continue block13;
                }
                case 2: {
                    this.sb.append(" cp");
                    continue block13;
                }
                case 82: 
                case 84: 
                case 85: 
                case 86: {
                    this.sb.append(" ib");
                    continue block13;
                }
                case 87: {
                    this.sb.append(" iw");
                    continue block13;
                }
                case 88: 
                case 89: {
                    this.sb.append(" id");
                    continue block13;
                }
                case 90: {
                    this.sb.append(" io");
                    continue block13;
                }
                case 52: 
                case 57: {
                    this.sb.append(" /is4");
                    continue block13;
                }
                case 53: 
                case 58: {
                    this.sb.append(" /is5");
                    i = opCount;
                    continue block13;
                }
                case 3: {
                    this.sb.append(" mo");
                }
            }
        }
    }

    private String format_Legacy() {
        this.sb.setLength(0);
        if (this.opCode.getFwait()) {
            this.appendHexByte(155);
            this.sb.append(' ');
        }
        switch (this.opCode.getAddressSize()) {
            case 0: {
                break;
            }
            case 16: {
                this.sb.append("a16 ");
                break;
            }
            case 32: {
                this.sb.append("a32 ");
                break;
            }
            case 64: {
                this.sb.append("a64 ");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (this.opCode.getOperandSize()) {
            case 0: {
                break;
            }
            case 16: {
                this.sb.append("o16 ");
                break;
            }
            case 32: {
                this.sb.append("o32 ");
                break;
            }
            case 64: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (this.opCode.getMandatoryPrefix()) {
            case 0: {
                break;
            }
            case 1: {
                this.sb.append("NP ");
                break;
            }
            case 2: {
                this.appendHexByte(102);
                this.sb.append(' ');
                break;
            }
            case 3: {
                this.appendHexByte(243);
                this.sb.append(' ');
                break;
            }
            case 4: {
                this.appendHexByte(242);
                this.sb.append(' ');
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.opCode.getOperandSize() == 64) {
            this.sb.append("o64 ");
        }
        this.appendTable(true);
        if (this.opCode.getTable() != 0) {
            this.sb.append(' ');
        }
        this.appendOpCode(this.opCode.getOpCode(), this.opCode.getOpCodeLength(), true);
        switch (this.getOpCodeBitsOperand()) {
            case 26: {
                this.sb.append("+rb");
                break;
            }
            case 30: {
                this.sb.append("+rw");
                break;
            }
            case 34: {
                this.sb.append("+rd");
                break;
            }
            case 39: {
                this.sb.append("+ro");
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int opCount = this.opCode.getOpCount();
        for (int i = 0; i < opCount; ++i) {
            if (this.opCode.getOpKind(i) != 80) continue;
            this.sb.append("+i");
            break;
        }
        this.appendRest();
        return this.sb.toString();
    }

    private String format_3DNow() {
        this.sb.setLength(0);
        this.appendOpCode(3855, 2, true);
        this.sb.append(" /r");
        this.sb.append(' ');
        this.appendOpCode(this.opCode.getOpCode(), this.opCode.getOpCodeLength(), true);
        return this.sb.toString();
    }

    private String formatVecEncoding(String encodingName) {
        this.sb.setLength(0);
        this.sb.append(encodingName);
        if (this.opCode.getEncoding() == 5) {
            if (MvexInfo.isNDD(this.opCode.getCode())) {
                this.sb.append(".NDD");
            } else if (MvexInfo.isNDS(this.opCode.getCode())) {
                this.sb.append(".NDS");
            }
        }
        this.sb.append('.');
        if (this.opCode.isLIG()) {
            this.sb.append("LIG");
        } else {
            switch (this.lkind) {
                case 1: {
                    this.sb.append(128 << this.opCode.getL());
                    break;
                }
                case 2: {
                    this.sb.append('L');
                    this.sb.append(this.opCode.getL());
                    break;
                }
                case 3: {
                    if (this.opCode.getL() != 0) {
                        throw new UnsupportedOperationException();
                    }
                    this.sb.append("LZ");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        switch (this.opCode.getMandatoryPrefix()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.sb.append('.');
                this.appendHexByte(102);
                break;
            }
            case 3: {
                this.sb.append('.');
                this.appendHexByte(243);
                break;
            }
            case 4: {
                this.sb.append('.');
                this.appendHexByte(242);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.opCode.getTable() != 0) {
            this.sb.append('.');
        }
        this.appendTable(false);
        if (this.opCode.isWIG()) {
            this.sb.append(".WIG");
        } else {
            this.sb.append(".W");
            this.sb.append(this.opCode.getW());
        }
        if (this.opCode.getEncoding() == 5) {
            switch (MvexInfo.getEHBit(this.opCode.getCode())) {
                case 0: {
                    break;
                }
                case 1: {
                    this.sb.append(".EH0");
                    break;
                }
                case 2: {
                    this.sb.append(".EH1");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        this.sb.append(' ');
        this.appendOpCode(this.opCode.getOpCode(), this.opCode.getOpCodeLength(), true);
        this.appendRest();
        return this.sb.toString();
    }

    private static final class ModrmInfo {
        public final boolean isRegOnly;
        public final int rrr;
        public final int bbb;

        public ModrmInfo(boolean isRegOnly, int rrr, int bbb) {
            this.isRegOnly = isRegOnly;
            this.rrr = rrr;
            this.bbb = bbb;
        }
    }
}

