/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.info;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.InternalInstructionUtils;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.info.InstructionInfo;
import com.github.icedland.iced.x86.info.OpAccessTables;
import com.github.icedland.iced.x86.info.UsedMemory;
import com.github.icedland.iced.x86.info.UsedRegister;
import com.github.icedland.iced.x86.internal.InstrInfoTable;

public final class InstructionInfoFactory {
    private InstructionInfo info = new InstructionInfo();
    private long xspMask;
    private int xspAddressSize;

    public InstructionInfo getInfo(Instruction instruction) {
        return this.create(instruction, 0);
    }

    public InstructionInfo getInfo(Instruction instruction, int options) {
        return this.create(instruction, options);
    }

    private InstructionInfo create(Instruction instruction, int options) {
        int op0Access;
        this.info.usedRegisters.clear();
        this.info.usedMemoryLocations.clear();
        int[] data = InstrInfoTable.data;
        int index = instruction.getCode() << 1;
        int flags1 = data[index];
        int flags2 = data[index + 1];
        int codeSize = instruction.getCodeSize();
        int flags = options & 3;
        if (codeSize == 3 || codeSize == 0) {
            flags |= 4;
        }
        if ((flags2 & 7) != 0) {
            flags |= 8;
        }
        int op0Info = flags1 >>> 0 & 0xF;
        switch (op0Info) {
            default: {
                op0Access = 0;
                break;
            }
            case 4: {
                op0Access = 1;
                break;
            }
            case 7: {
                if (instruction.hasOpMask() && instruction.getMergingMasking()) {
                    if (instruction.getOp0Kind() != 0) {
                        op0Access = 4;
                        break;
                    }
                    op0Access = 5;
                    break;
                }
                op0Access = 3;
                break;
            }
            case 8: {
                if (instruction.hasOpMask() && instruction.getMergingMasking()) {
                    if (instruction.getOp0Kind() != 0) {
                        op0Access = 4;
                        break;
                    }
                    op0Access = 6;
                    break;
                }
                op0Access = 3;
                break;
            }
            case 10: 
            case 12: {
                op0Access = 3;
                break;
            }
            case 1: {
                op0Access = 4;
                break;
            }
            case 2: {
                if ((flags & 4) != 0) {
                    op0Access = 5;
                    break;
                }
                op0Access = 4;
                break;
            }
            case 6: {
                op0Access = 5;
                break;
            }
            case 9: {
                if (instruction.hasOpMask() && instruction.getMergingMasking()) {
                    op0Access = 6;
                    break;
                }
                op0Access = 5;
                break;
            }
            case 5: {
                op0Access = 6;
                break;
            }
            case 3: {
                op0Access = 7;
                break;
            }
            case 11: {
                op0Access = instruction.getOp0Kind() != 0 || instruction.getOp1Kind() != 0 ? 3 : 5;
            }
        }
        assert (instruction.getOpCount() <= 5) : instruction.getOpCount();
        this.info.opAccesses[0] = (byte)op0Access;
        int op1Info = flags1 >>> 4 & 7;
        this.info.opAccesses[1] = (byte)OpAccessTables.op1[op1Info];
        this.info.opAccesses[2] = (byte)OpAccessTables.op2[flags1 >>> 7 & 3];
        this.info.opAccesses[3] = (flags1 & 0x200) != 0 ? (byte)1 : 0;
        this.info.opAccesses[4] = (flags1 & 0x400) != 0 ? (byte)1 : 0;
        int opCount = instruction.getOpCount();
        block22: for (int i = 0; i < opCount; ++i) {
            byte access = this.info.opAccesses[i];
            if (access == 0) continue;
            switch (instruction.getOpKind(i)) {
                case 0: {
                    int reg;
                    if (access == 7) {
                        access = 1;
                        this.info.opAccesses[i] = 1;
                    }
                    if ((flags & 2) != 0) continue block22;
                    if (i == 0 && op0Info == 12) {
                        reg = instruction.getOp0Register();
                        this.addRegister(flags, reg, access);
                        if (173 > reg || reg > 180) continue block22;
                        this.addRegister(flags, (reg - 173 ^ 1) + 173, access);
                        continue block22;
                    }
                    if (i == 1 && op1Info == 4) {
                        reg = instruction.getOp1Register();
                        if (77 > reg || reg > 172) continue block22;
                        reg = 141 + (reg - 141 & 0xFFFFFFFC);
                        for (int j = 0; j < 4; ++j) {
                            this.addRegister(flags, reg + j, access);
                        }
                        continue block22;
                    }
                    this.addRegister(flags, instruction.getOpRegister(i), access);
                    continue block22;
                }
                case 24: {
                    int scale;
                    int indexReg;
                    int segReg = instruction.getMemorySegment() & ~(flags1 >> 31);
                    int baseReg = instruction.getMemoryBase();
                    if (baseReg == 70) {
                        if ((flags & 1) == 0) {
                            this.addMemory(segReg, 0, 0, 1, instruction.getMemoryDisplacement64(), instruction.getMemorySize(), access, 3, 0);
                        }
                        if ((flags & 2) != 0 || segReg == 0) continue block22;
                        this.addMemorySegmentRegister(flags, segReg, 1);
                        continue block22;
                    }
                    if (baseReg == 69) {
                        if ((flags & 1) == 0) {
                            this.addMemory(segReg, 0, 0, 1, (long)instruction.getMemoryDisplacement32() & 0xFFFFFFFFL, instruction.getMemorySize(), access, 2, 0);
                        }
                        if ((flags & 2) != 0 || segReg == 0) continue block22;
                        this.addMemorySegmentRegister(flags, segReg, 1);
                        continue block22;
                    }
                    if ((flags1 & 0x20000000) != 0) {
                        indexReg = instruction.getMemoryIndex();
                        if ((flags & 2) == 0 && indexReg != 0) {
                            this.addRegister(flags, indexReg, 1);
                        }
                        indexReg = 0;
                        scale = 1;
                    } else {
                        indexReg = instruction.getMemoryIndex();
                        scale = instruction.getMemoryIndexScale();
                    }
                    if ((flags & 1) == 0) {
                        int addrSize;
                        int addrSizeBytes = InternalInstructionUtils.getAddressSizeInBytes(baseReg, indexReg, instruction.getMemoryDisplSize(), codeSize);
                        switch (addrSizeBytes) {
                            case 2: {
                                addrSize = 1;
                                break;
                            }
                            case 4: {
                                addrSize = 2;
                                break;
                            }
                            case 8: {
                                addrSize = 3;
                                break;
                            }
                            default: {
                                addrSize = 0;
                            }
                        }
                        int vsibSize = 0;
                        if (Register.isVectorRegister(indexReg)) {
                            int vsib = instruction.getVsib();
                            vsibSize = (vsib & 4) != 0 ? 8 : 4;
                        }
                        long displ = addrSizeBytes == 8 ? instruction.getMemoryDisplacement64() : (long)instruction.getMemoryDisplacement32() & 0xFFFFFFFFL;
                        this.addMemory(segReg, baseReg, indexReg, scale, displ, instruction.getMemorySize(), access, addrSize, vsibSize);
                    }
                    if ((flags & 2) != 0) continue block22;
                    if (segReg != 0) {
                        this.addMemorySegmentRegister(flags, segReg, 1);
                    }
                    if (baseReg != 0) {
                        this.addRegister(flags, baseReg, 1);
                    }
                    if (indexReg == 0) continue block22;
                    this.addRegister(flags, indexReg, 1);
                }
            }
        }
        int impliedAccess = flags1 >>> 20 & 0xFF;
        if (impliedAccess != 0) {
            this.addImpliedAccesses(impliedAccess, instruction, flags);
        }
        if (instruction.hasOpMask() && (flags & 2) == 0) {
            this.addRegister(flags, instruction.getOpMask(), (flags1 & 0x40000000) != 0 ? 5 : 1);
        }
        return this.info;
    }

    private int getXSP(int codeSize) {
        if (codeSize == 3 || codeSize == 0) {
            this.xspMask = -1L;
            this.xspAddressSize = 3;
            return 57;
        }
        if (codeSize == 2) {
            this.xspMask = 0xFFFFFFFFL;
            this.xspAddressSize = 2;
            return 41;
        }
        assert (codeSize == 1) : codeSize;
        this.xspMask = 65535L;
        this.xspAddressSize = 1;
        return 25;
    }

    private void addImpliedAccesses(int impliedAccess, Instruction instruction, int flags) {
        assert (impliedAccess != 0) : impliedAccess;
        switch (impliedAccess) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.commandClearRflags(instruction, flags);
                break;
            }
            case 6: {
                this.commandPush(instruction, flags, 1, 2);
                break;
            }
            case 7: {
                this.commandPush(instruction, flags, 1, 4);
                break;
            }
            case 8: {
                this.commandPop(instruction, flags, 1, 2);
                break;
            }
            case 9: {
                this.commandPop(instruction, flags, 1, 4);
                break;
            }
            case 10: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 1, 5);
                break;
            }
            case 11: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 5);
                break;
            }
            case 12: {
                this.commandPush(instruction, flags, 1, 8);
                break;
            }
            case 13: {
                this.commandPop(instruction, flags, 1, 8);
                break;
            }
            case 14: {
                this.commandPusha(instruction, flags, 2);
                break;
            }
            case 15: {
                this.commandPusha(instruction, flags, 4);
                break;
            }
            case 16: {
                this.commandPopa(instruction, flags, 2);
                break;
            }
            case 17: {
                this.commandPopa(instruction, flags, 4);
                break;
            }
            case 18: {
                this.commandArpl(instruction, flags);
                break;
            }
            case 19: {
                this.commandIns(instruction, flags);
                break;
            }
            case 20: {
                this.commandOuts(instruction, flags);
                break;
            }
            case 21: {
                this.commandLea(instruction, flags);
                break;
            }
            case 22: {
                this.commandLastGpr(instruction, flags, 21);
                break;
            }
            case 23: {
                this.commandPopRm(instruction, flags, 2);
                break;
            }
            case 24: {
                this.commandPopRm(instruction, flags, 4);
                break;
            }
            case 25: {
                this.commandPopRm(instruction, flags, 8);
                break;
            }
            case 26: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 1, 1);
                this.addRegister(flags, 5, 3);
                break;
            }
            case 27: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 37, 3);
                break;
            }
            case 28: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 5);
                break;
            }
            case 29: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 23, 3);
                break;
            }
            case 30: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 39, 3);
                break;
            }
            case 31: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                this.addRegister(flags, 55, 3);
                break;
            }
            case 32: {
                this.commandPush(instruction, flags, 2, 2);
                break;
            }
            case 33: {
                this.commandPush(instruction, flags, 2, 4);
                break;
            }
            case 34: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 5, 1);
                break;
            }
            case 35: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 5, 3);
                break;
            }
            case 36: {
                this.commandMovs(instruction, flags);
                break;
            }
            case 37: {
                this.commandCmps(instruction, flags);
                break;
            }
            case 38: {
                this.commandStos(instruction, flags);
                break;
            }
            case 39: {
                this.commandLods(instruction, flags);
                break;
            }
            case 40: {
                this.commandScas(instruction, flags);
                break;
            }
            case 41: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 71, 3);
                break;
            }
            case 42: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 74, 3);
                break;
            }
            case 43: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 4);
                break;
            }
            case 44: {
                this.commandEnter(instruction, flags, 2);
                break;
            }
            case 45: {
                this.commandEnter(instruction, flags, 4);
                break;
            }
            case 46: {
                this.commandEnter(instruction, flags, 8);
                break;
            }
            case 47: {
                this.commandLeave(instruction, flags, 2);
                break;
            }
            case 48: {
                this.commandLeave(instruction, flags, 4);
                break;
            }
            case 49: {
                this.commandLeave(instruction, flags, 8);
                break;
            }
            case 50: {
                this.commandPop(instruction, flags, 2, 2);
                break;
            }
            case 51: {
                this.commandPop(instruction, flags, 2, 4);
                break;
            }
            case 52: {
                this.commandPop(instruction, flags, 2, 8);
                break;
            }
            case 53: {
                if ((flags & 4) != 0) {
                    if ((flags & 2) == 0) {
                        this.addRegister(flags, 73, 3);
                    }
                    this.commandPop(instruction, flags, 5, 2);
                    break;
                }
                this.commandPop(instruction, flags, 3, 2);
                break;
            }
            case 54: {
                if ((flags & 4) != 0) {
                    if ((flags & 2) == 0) {
                        this.addRegister(flags, 73, 3);
                    }
                    this.commandPop(instruction, flags, 5, 4);
                    break;
                }
                this.commandPop(instruction, flags, 3, 4);
                break;
            }
            case 55: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 73, 3);
                }
                this.commandPop(instruction, flags, 5, 8);
                break;
            }
            case 56: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 1, 1);
                this.addRegister(flags, 21, 3);
                break;
            }
            case 57: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 1, 3);
                break;
            }
            case 58: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 217, 5);
                break;
            }
            case 59: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 217, 1);
                break;
            }
            case 60: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 217, 1);
                this.addRegister(flags, 218, 5);
                break;
            }
            case 61: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 217, 6);
                break;
            }
            case 62: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 218, 1);
                this.addRegister(flags, 217, 5);
                break;
            }
            case 63: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 217, 1);
                this.addRegister(flags, 218, 1);
                break;
            }
            case 64: {
                int reg;
                if ((flags & 2) != 0) break;
                for (reg = 217; reg <= 224; ++reg) {
                    this.addRegister(flags, reg, 3);
                }
                for (reg = 225; reg <= 232; ++reg) {
                    this.addRegister(flags, reg, 3);
                }
                break;
            }
            case 65: {
                int reg;
                if ((flags & 2) != 0) break;
                for (reg = 217; reg <= 224; ++reg) {
                    this.addRegister(flags, reg, 1);
                }
                for (reg = 225; reg <= 232; ++reg) {
                    this.addRegister(flags, reg, 1);
                }
                break;
            }
            case 66: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 22, 5);
                break;
            }
            case 67: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 5);
                break;
            }
            case 68: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 5);
                break;
            }
            case 69: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 22, 1);
                break;
            }
            case 70: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                break;
            }
            case 71: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                break;
            }
            case 72: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 23, 3);
                this.addRegister(flags, 21, 5);
                break;
            }
            case 73: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 39, 3);
                this.addRegister(flags, 37, 5);
                break;
            }
            case 74: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 55, 3);
                this.addRegister(flags, 53, 5);
                break;
            }
            case 75: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 5);
                this.addRegister(flags, 23, 5);
                break;
            }
            case 76: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 5);
                this.addRegister(flags, 39, 5);
                break;
            }
            case 77: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 5);
                this.addRegister(flags, 55, 5);
                break;
            }
            case 78: {
                this.commandPush(instruction, flags, 2, 8);
                break;
            }
            case 79: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 185, 1);
                break;
            }
            case 80: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 185, 5);
                break;
            }
            case 81: {
                this.commandLastGpr(instruction, flags, 21);
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 185, 5);
                break;
            }
            case 82: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 37, 6);
                }
                if ((flags & 4) != 0) {
                    if ((flags & 2) != 0) break;
                    this.addRegister(flags, 54, 2);
                    this.addRegister(flags, 55, 2);
                    this.addRegister(flags, 56, 2);
                    this.addRegister(flags, 54, 4);
                    this.addRegister(flags, 55, 4);
                    this.addRegister(flags, 56, 4);
                    break;
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 2);
                this.addRegister(flags, 39, 2);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 74, 2);
                this.addRegister(flags, 38, 4);
                this.addRegister(flags, 39, 4);
                this.addRegister(flags, 40, 4);
                break;
            }
            case 83: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 38, 4);
                    this.addRegister(flags, 39, 4);
                    this.addRegister(flags, 40, 4);
                    this.addRegister(flags, 37, 5);
                }
                if ((flags & 4) != 0) {
                    if ((flags & 2) != 0) break;
                    this.addRegister(flags, 54, 2);
                    this.addRegister(flags, 55, 2);
                    this.addRegister(flags, 56, 2);
                    break;
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 2);
                this.addRegister(flags, 39, 2);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 74, 2);
                break;
            }
            case 84: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 85: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 86: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 53, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 87: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 38, 1);
                break;
            }
            case 88: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 37, 3);
                this.addRegister(flags, 39, 3);
                break;
            }
            case 89: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                break;
            }
            case 90: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                break;
            }
            case 91: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                break;
            }
            case 92: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                break;
            }
            case 93: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 75, 3);
                this.addRegister(flags, 76, 3);
                break;
            }
            case 94: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 75, 3);
                this.addRegister(flags, 76, 3);
                break;
            }
            case 95: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                this.addRegister(flags, 75, 3);
                this.addRegister(flags, 76, 3);
                break;
            }
            case 96: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 75, 1);
                this.addRegister(flags, 76, 1);
                break;
            }
            case 97: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 75, 1);
                this.addRegister(flags, 76, 1);
                break;
            }
            case 98: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                this.addRegister(flags, 75, 1);
                this.addRegister(flags, 76, 1);
                break;
            }
            case 99: {
                int reg;
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 37, 1);
                    this.addRegister(flags, 185, 3);
                    this.addRegister(flags, 207, 3);
                    this.addRegister(flags, 208, 3);
                    for (reg = 71; reg <= 76; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                    for (reg = 187; reg <= 189; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                    for (reg = 201; reg <= 204; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                }
                if ((flags & 4) != 0) {
                    if ((flags & 2) != 0) break;
                    for (reg = 53; reg <= 68; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                } else {
                    if ((flags & 2) != 0) break;
                    for (reg = 37; reg <= 44; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                }
                break;
            }
            case 100: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 38, 1);
                break;
            }
            case 101: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 53, 1);
                break;
            }
            case 102: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 3);
                this.addRegister(flags, 38, 3);
                this.addRegister(flags, 39, 3);
                break;
            }
            case 103: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 40, 2);
                break;
            }
            case 104: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 105: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 106: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 107: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 38, 3);
                }
                if ((flags & 4) == 0 || (flags & 2) != 0) break;
                this.addRegister(flags, 64, 3);
                break;
            }
            case 108: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 44, 1);
                this.addRegister(flags, 71, 1);
                break;
            }
            case 109: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 38, 1);
                    this.addRegister(flags, 72, 3);
                    this.addRegister(flags, 73, 3);
                }
                if ((flags & 4) == 0 || (flags & 2) != 0) break;
                this.addRegister(flags, 48, 1);
                break;
            }
            case 110: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 48, 1);
                this.addRegister(flags, 54, 1);
                this.addRegister(flags, 72, 3);
                this.addRegister(flags, 73, 3);
                break;
            }
            case 111: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 3);
                this.addRegister(flags, 39, 3);
                break;
            }
            case 112: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 41, 3);
                break;
            }
            case 113: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 41, 3);
                this.addRegister(flags, 72, 3);
                this.addRegister(flags, 73, 3);
                break;
            }
            case 114: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                this.addRegister(flags, 55, 1);
                this.addRegister(flags, 57, 3);
                this.addRegister(flags, 72, 3);
                this.addRegister(flags, 73, 3);
                break;
            }
            case 115: {
                this.commandClearRegRegmem(instruction, flags);
                break;
            }
            case 116: {
                this.commandClearRegRegRegmem(instruction, flags);
                break;
            }
            case 117: {
                if ((flags & 4) != 0) {
                    if ((flags & 2) != 0) break;
                    for (int reg = 77; reg <= 92; ++reg) {
                        this.addRegister(flags, reg, 5);
                    }
                } else {
                    if ((flags & 2) != 0) break;
                    for (int reg = 77; reg <= 84; ++reg) {
                        this.addRegister(flags, reg, 5);
                    }
                }
                break;
            }
            case 118: {
                if ((flags & 4) != 0) {
                    if ((flags & 2) != 0) break;
                    for (int reg = 141; reg <= 156; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                } else {
                    if ((flags & 2) != 0) break;
                    for (int reg = 141; reg <= 148; ++reg) {
                        this.addRegister(flags, reg, 3);
                    }
                }
                break;
            }
            case 119: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 2);
                this.addRegister(flags, 38, 3);
                this.addRegister(flags, 39, 3);
                this.addRegister(flags, 40, 3);
                this.addRegister(flags, 37, 5);
                break;
            }
            case 120: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 37, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 37, 4);
                this.addRegister(flags, 39, 4);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 121: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 2);
                this.addRegister(flags, 43, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 37, 4);
                this.addRegister(flags, 39, 4);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 122: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 2);
                this.addRegister(flags, 59, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 37, 4);
                this.addRegister(flags, 39, 4);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 123: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 4, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 28, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 27, 4);
                this.addRegister(flags, 21, 6);
                this.addRegister(flags, 22, 6);
                break;
            }
            case 124: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 4, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 43, 2);
                this.addRegister(flags, 44, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 43, 4);
                this.addRegister(flags, 37, 6);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 125: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 59, 4);
                this.addRegister(flags, 53, 6);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 126: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 2, 1);
                this.addRegister(flags, 21, 1);
                break;
            }
            case 127: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 2, 1);
                this.addRegister(flags, 37, 1);
                break;
            }
            case 128: {
                this.commandXstore(instruction, flags, 2);
                break;
            }
            case 129: {
                this.commandXstore(instruction, flags, 4);
                break;
            }
            case 130: {
                this.commandXstore(instruction, flags, 8);
                break;
            }
            case 131: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 23, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 24, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 4, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 23, 2);
                this.addRegister(flags, 24, 2);
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 28, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 27, 4);
                this.addRegister(flags, 28, 4);
                this.addRegister(flags, 22, 6);
                break;
            }
            case 132: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 39, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 40, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 4, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 39, 2);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 43, 2);
                this.addRegister(flags, 44, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 43, 4);
                this.addRegister(flags, 44, 4);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 133: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 55, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 56, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 55, 2);
                this.addRegister(flags, 56, 2);
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 59, 4);
                this.addRegister(flags, 60, 4);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 134: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 21, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 23, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 24, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 21, 0, 1, 0L, 0, 4, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 4, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 2);
                this.addRegister(flags, 23, 2);
                this.addRegister(flags, 24, 2);
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 28, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 27, 4);
                this.addRegister(flags, 28, 4);
                this.addRegister(flags, 22, 6);
                break;
            }
            case 135: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 37, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 39, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 40, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 37, 0, 1, 0L, 0, 4, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 4, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 2);
                this.addRegister(flags, 39, 2);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 43, 2);
                this.addRegister(flags, 44, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 43, 4);
                this.addRegister(flags, 44, 4);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 136: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 53, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 55, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 56, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 53, 0, 1, 0L, 0, 4, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 2);
                this.addRegister(flags, 55, 2);
                this.addRegister(flags, 56, 2);
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 59, 4);
                this.addRegister(flags, 60, 4);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 137: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 1, 6);
                break;
            }
            case 138: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 6);
                break;
            }
            case 139: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 6);
                break;
            }
            case 140: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 39, 1);
                break;
            }
            case 141: {
                this.commandLastGpr(instruction, flags, 1);
                break;
            }
            case 142: {
                this.commandLastGpr(instruction, flags, 37);
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 39, 1);
                break;
            }
            case 143: {
                if ((flags & 1) == 0) {
                    this.addMemory(InstructionInfoFactory.getSegDefaultDS(instruction), instruction.getOp0Register(), 0, 1, 0L, 1, 1, 0, 0);
                }
                if ((flags & 2) != 0) break;
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 144: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 6);
                break;
            }
            case 145: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 73, 3);
                break;
            }
            case 146: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 75, 3);
                break;
            }
            case 147: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 76, 3);
                break;
            }
            case 148: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 2);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 37, 6);
                this.addRegister(flags, 39, 6);
                break;
            }
            case 149: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 2);
                this.addRegister(flags, 56, 2);
                this.addRegister(flags, 53, 6);
                this.addRegister(flags, 55, 6);
                break;
            }
            case 150: {
                if ((flags & 1) == 0) {
                    this.addMemory(InstructionInfoFactory.getSegDefaultDS(instruction), InstructionInfoFactory.getARDI(instruction), 0, 1, 0L, instruction.getMemorySize(), 3, 0, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, InstructionInfoFactory.getARDI(instruction), 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                break;
            }
            case 151: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 77, 1);
                break;
            }
            case 152: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 39, 1);
                break;
            }
            case 153: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 55, 1);
                break;
            }
            case 154: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, instruction.getOp0Register(), 0, 1, 0L, instruction.getMemorySize(), 3, 0, 0);
                }
                if ((flags & 2) != 0 || (flags & 4) != 0) break;
                this.addRegister(flags, 71, 1);
                break;
            }
            case 155: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 77, 3);
                break;
            }
            case 156: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                this.addRegister(flags, 55, 1);
                this.addRegister(flags, 77, 3);
                break;
            }
            case 157: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 38, 3);
                break;
            }
            case 158: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 1);
                this.addRegister(flags, 55, 1);
                this.addRegister(flags, 38, 3);
                break;
            }
            case 159: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 77, 3);
                break;
            }
            case 160: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 3);
                break;
            }
            case 161: {
                if ((flags & 1) == 0) {
                    this.addMemory(74, instruction.getOp0Register(), 0, 1, 0L, 0, 1, 0, 0);
                }
                if ((flags & 2) != 0 || (flags & 4) != 0) break;
                this.addRegister(flags, 74, 1);
                break;
            }
            case 162: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                this.addRegister(flags, 55, 1);
                this.addRegister(flags, 53, 5);
                break;
            }
            case 163: {
                if ((flags & 1) == 0) {
                    this.addMemory(InstructionInfoFactory.getSegDefaultDS(instruction), 54, 0, 1, 0L, 6, 1, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                this.addMemorySegmentRegister(flags, InstructionInfoFactory.getSegDefaultDS(instruction), 1);
                this.addRegister(flags, 53, 5);
                break;
            }
            case 164: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 5);
                break;
            }
            case 165: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 37, 3);
                break;
            }
            case 166: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 37, 5);
                break;
            }
            case 167: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 53, 5);
                break;
            }
            case 168: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                break;
            }
            case 169: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 53, 1);
                break;
            }
            case 170: {
                if ((flags & 2) != 0) break;
                for (int reg = 241; reg <= 248; ++reg) {
                    this.addRegister(flags, reg, 3);
                }
                break;
            }
            case 171: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 40, 1);
                break;
            }
            case 172: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 40, 1);
                this.addRegister(flags, 37, 3);
                break;
            }
            case 173: {
                this.commandEmmi(instruction, flags, 3);
                break;
            }
            case 174: {
                this.commandEmmi(instruction, flags, 5);
                break;
            }
            case 175: {
                this.commandEmmi(instruction, flags, 1);
                break;
            }
            case 176: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 2);
                this.addRegister(flags, 55, 2);
                this.addRegister(flags, 61, 2);
                this.addRegister(flags, 62, 2);
                this.addRegister(flags, 53, 5);
                break;
            }
            case 177: {
                if ((flags & 2) != 0) break;
                for (int reg = 77; reg <= 84; ++reg) {
                    this.addRegister(flags, reg, 5);
                }
                break;
            }
            case 178: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 77, 1);
                break;
            }
            case 179: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 78, 3);
                this.addRegister(flags, 79, 3);
                this.addRegister(flags, 77, 5);
                for (int reg = 81; reg <= 83; ++reg) {
                    this.addRegister(flags, reg, 3);
                }
                break;
            }
            case 180: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 77, 5);
                this.addRegister(flags, 78, 5);
                for (int reg = 79; reg <= 83; ++reg) {
                    this.addRegister(flags, reg, 3);
                }
                break;
            }
            case 181: {
                this.commandPop(instruction, flags, 3, 8);
                break;
            }
            case 182: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 4, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 24, 2);
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 28, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 27, 4);
                this.addRegister(flags, 21, 6);
                this.addRegister(flags, 22, 6);
                break;
            }
            case 183: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 4, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 43, 2);
                this.addRegister(flags, 44, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 43, 4);
                this.addRegister(flags, 37, 6);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 184: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 56, 2);
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 59, 4);
                this.addRegister(flags, 53, 6);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 185: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 23, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 24, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 4, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 21, 2);
                this.addRegister(flags, 23, 2);
                this.addRegister(flags, 24, 2);
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 28, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 27, 4);
                this.addRegister(flags, 28, 4);
                this.addRegister(flags, 22, 6);
                break;
            }
            case 186: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 39, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 40, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 4, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 2);
                this.addRegister(flags, 39, 2);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 43, 2);
                this.addRegister(flags, 44, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 43, 4);
                this.addRegister(flags, 44, 4);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 187: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 55, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 56, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 53, 2);
                this.addRegister(flags, 55, 2);
                this.addRegister(flags, 56, 2);
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 59, 4);
                this.addRegister(flags, 60, 4);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 188: {
                this.commandLastGpr(instruction, flags, 21);
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 76, 3);
                break;
            }
            case 189: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 57, 3);
                    this.addRegister(flags, 72, 3);
                    this.addRegister(flags, 73, 3);
                }
                this.commandPop(instruction, flags, 6, 8);
                break;
            }
            case 190: {
                if ((flags & 2) == 0) {
                    this.addRegister(flags, 72, 1);
                    this.addRegister(flags, 73, 1);
                    this.addRegister(flags, 57, 3);
                }
                this.commandPop(instruction, flags, 6, 8);
                break;
            }
            case 191: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 3);
                this.addRegister(flags, 40, 3);
                break;
            }
            case 192: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 37, 1);
                this.addRegister(flags, 38, 1);
                this.addRegister(flags, 39, 1);
                this.addRegister(flags, 40, 2);
                this.addRegister(flags, 39, 4);
                this.addRegister(flags, 40, 4);
                break;
            }
            case 193: {
                this.commandMemDispl(flags, -64);
                break;
            }
            case 194: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 27, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 2, 1, 0);
                    this.addMemory(71, 28, 0, 1, 0L, 0, 4, 1, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 27, 2);
                this.addRegister(flags, 28, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 27, 4);
                this.addRegister(flags, 22, 6);
                break;
            }
            case 195: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 43, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 2, 2, 0);
                    this.addMemory(71, 44, 0, 1, 0L, 0, 4, 2, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 43, 2);
                this.addRegister(flags, 44, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 43, 4);
                this.addRegister(flags, 38, 6);
                break;
            }
            case 196: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, 59, 4);
                this.addRegister(flags, 54, 6);
                break;
            }
            case 197: {
                if ((flags & 1) == 0) {
                    this.addMemory(71, 60, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(74, 59, 0, 1, 0L, 0, 2, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 74, 2);
                }
                this.addRegister(flags, 54, 4);
                break;
            }
            case 198: {
                if ((flags & 1) == 0) {
                    this.addMemory(74, 59, 0, 1, 0L, 0, 2, 3, 0);
                    this.addMemory(71, 60, 0, 1, 0L, 0, 4, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                this.addRegister(flags, 59, 2);
                this.addRegister(flags, 60, 2);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 74, 2);
                }
                this.addRegister(flags, 54, 4);
                break;
            }
            case 199: {
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 3, 1);
                this.addRegister(flags, 53, 1);
                this.addRegister(flags, 37, 3);
                this.addRegister(flags, 54, 3);
                this.addRegister(flags, 55, 3);
                break;
            }
            case 200: {
                if ((flags & 1) == 0) {
                    this.addMemory(74, 56, 0, 1, 0L, 0, 1, 3, 0);
                    this.addMemory(74, 54, 0, 1, 0L, 0, 3, 3, 0);
                }
                if ((flags & 2) != 0) break;
                this.addRegister(flags, 54, 1);
                this.addRegister(flags, 56, 1);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 74, 1);
                }
                this.addRegister(flags, 37, 3);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static int getARDI(Instruction instruction) {
        switch (instruction.getOp0Kind()) {
            case 18: {
                return 28;
            }
            case 19: {
                return 44;
            }
        }
        return 60;
    }

    private static int getSegDefaultDS(Instruction instruction) {
        int seg = instruction.getSegmentPrefix();
        return seg == 0 ? 74 : seg;
    }

    private void commandPush(Instruction instruction, int flags, int count, int opSize) {
        assert (count > 0) : count;
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 5);
        }
        if ((flags & 1) == 0) {
            int memSize;
            if (opSize == 8) {
                memSize = 5;
            } else if (opSize == 4) {
                memSize = 3;
            } else {
                assert (opSize == 2) : opSize;
                memSize = 2;
            }
            long offset = -opSize;
            int i = 0;
            while (i < count) {
                this.addMemory(73, xsp, 0, 1, offset & this.xspMask, memSize, 3, this.xspAddressSize, 0);
                ++i;
                offset -= (long)opSize;
            }
        }
    }

    private void commandPop(Instruction instruction, int flags, int count, int opSize) {
        assert (count > 0) : count;
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 5);
        }
        if ((flags & 1) == 0) {
            int memSize;
            if (opSize == 8) {
                memSize = 5;
            } else if (opSize == 4) {
                memSize = 3;
            } else {
                assert (opSize == 2) : opSize;
                memSize = 2;
            }
            long offset = 0L;
            int i = 0;
            while (i < count) {
                this.addMemory(73, xsp, 0, 1, offset, memSize, 1, this.xspAddressSize, 0);
                ++i;
                offset += (long)opSize;
            }
        }
    }

    private void commandPopRm(Instruction instruction, int flags, int opSize) {
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 5);
        }
        if ((flags & 1) == 0) {
            int memSize;
            if (opSize == 8) {
                memSize = 5;
            } else if (opSize == 4) {
                memSize = 3;
            } else {
                assert (opSize == 2) : opSize;
                memSize = 2;
            }
            if (instruction.getOp0Kind() == 24) {
                assert (this.info.usedMemoryLocations.size() == 1) : this.info.usedMemoryLocations.size();
                if (instruction.getMemoryBase() == 57 || instruction.getMemoryBase() == 41) {
                    UsedMemory mem = this.info.usedMemoryLocations.get(0);
                    long displ = mem.getDisplacement() + (long)opSize;
                    if (instruction.getMemoryBase() == 41) {
                        displ &= 0xFFFFFFFFL;
                    }
                    this.info.usedMemoryLocations.set(0, new UsedMemory(mem.getSegment(), mem.getBase(), mem.getIndex(), mem.getScale(), displ, mem.getMemorySize(), mem.getAccess(), mem.getAddressSize(), mem.getVsibSize()));
                }
            }
            this.addMemory(73, xsp, 0, 1, 0L, memSize, 1, this.xspAddressSize, 0);
        }
    }

    private void commandPusha(Instruction instruction, int flags, int opSize) {
        int baseReg;
        int memSize;
        long displ;
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 5);
        }
        if (opSize == 4) {
            displ = -4L;
            memSize = 3;
            baseReg = 37;
        } else {
            assert (opSize == 2) : opSize;
            displ = -2L;
            memSize = 2;
            baseReg = 21;
        }
        for (int i = 0; i < 8; ++i) {
            if ((flags & 2) == 0) {
                this.addRegister(flags, baseReg + i, 1);
            }
            if ((flags & 1) != 0) continue;
            this.addMemory(73, xsp, 0, 1, displ * (long)(i + 1) & this.xspMask, memSize, 3, this.xspAddressSize, 0);
        }
    }

    private void commandPopa(Instruction instruction, int flags, int opSize) {
        int baseReg;
        int memSize;
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 5);
        }
        if (opSize == 4) {
            memSize = 3;
            baseReg = 37;
        } else {
            assert (opSize == 2) : opSize;
            memSize = 2;
            baseReg = 21;
        }
        for (int i = 0; i < 8; ++i) {
            if (i == 3) continue;
            if ((flags & 2) == 0) {
                this.addRegister(flags, baseReg + 7 - i, 3);
            }
            if ((flags & 1) != 0) continue;
            this.addMemory(73, xsp, 0, 1, (long)(opSize * i) & this.xspMask, memSize, 1, this.xspAddressSize, 0);
        }
    }

    private void commandIns(Instruction instruction, int flags) {
        int rCX;
        int rDI;
        int addressSize;
        switch (instruction.getOp0Kind()) {
            case 21: {
                addressSize = 1;
                rDI = 28;
                rCX = 22;
                break;
            }
            case 22: {
                addressSize = 2;
                rDI = 44;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rDI = 60;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 4;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, 0, 4, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                assert (this.info.usedRegisters.size() == 1) : this.info.usedRegisters.size();
                this.info.usedRegisters.set(0, new UsedRegister(23, 2));
                this.addRegister(flags, rCX, 6);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, rDI, 2);
                this.addRegister(flags, rDI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, instruction.getMemorySize(), 3, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 1);
                }
                this.addRegister(flags, rDI, 5);
            }
        }
    }

    private void commandOuts(Instruction instruction, int flags) {
        int rCX;
        int rSI;
        int addressSize;
        switch (instruction.getOp1Kind()) {
            case 15: {
                addressSize = 1;
                rSI = 27;
                rCX = 22;
                break;
            }
            case 16: {
                addressSize = 2;
                rSI = 43;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rSI = 59;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 2;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, 0, 2, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                assert (this.info.usedRegisters.size() == 1) : this.info.usedRegisters.size();
                this.info.usedRegisters.set(0, new UsedRegister(23, 2));
                this.addRegister(flags, rCX, 6);
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 2);
                this.addRegister(flags, rSI, 2);
                this.addRegister(flags, rSI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, instruction.getMemorySize(), 1, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 1);
                this.addRegister(flags, rSI, 5);
            }
        }
    }

    private void commandMovs(Instruction instruction, int flags) {
        int rCX;
        int rDI;
        int rSI;
        int addressSize;
        switch (instruction.getOp0Kind()) {
            case 21: {
                addressSize = 1;
                rSI = 27;
                rDI = 28;
                rCX = 22;
                break;
            }
            case 22: {
                addressSize = 2;
                rSI = 43;
                rDI = 44;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rSI = 59;
                rDI = 60;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 4;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, 0, 4, addressSize, 0);
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, 0, 2, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                this.addRegister(flags, rCX, 6);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, rDI, 2);
                this.addRegister(flags, rDI, 4);
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 2);
                this.addRegister(flags, rSI, 2);
                this.addRegister(flags, rSI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, instruction.getMemorySize(), 3, addressSize, 0);
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, instruction.getMemorySize(), 1, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 1);
                }
                this.addRegister(flags, rDI, 5);
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 1);
                this.addRegister(flags, rSI, 5);
            }
        }
    }

    private void commandCmps(Instruction instruction, int flags) {
        int rCX;
        int rDI;
        int rSI;
        int addressSize;
        switch (instruction.getOp0Kind()) {
            case 15: {
                addressSize = 1;
                rSI = 27;
                rDI = 28;
                rCX = 22;
                break;
            }
            case 16: {
                addressSize = 2;
                rSI = 43;
                rDI = 44;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rSI = 59;
                rDI = 60;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 2;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, 0, 2, addressSize, 0);
                this.addMemory(71, rDI, 0, 1, 0L, 0, 2, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                this.addRegister(flags, rCX, 6);
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 2);
                this.addRegister(flags, rSI, 2);
                this.addRegister(flags, rSI, 4);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, rDI, 2);
                this.addRegister(flags, rDI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, instruction.getMemorySize(), 1, addressSize, 0);
                this.addMemory(71, rDI, 0, 1, 0L, instruction.getMemorySize(), 1, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 1);
                this.addRegister(flags, rSI, 5);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 1);
                }
                this.addRegister(flags, rDI, 5);
            }
        }
    }

    private void commandStos(Instruction instruction, int flags) {
        int rCX;
        int rDI;
        int addressSize;
        switch (instruction.getOp0Kind()) {
            case 21: {
                addressSize = 1;
                rDI = 28;
                rCX = 22;
                break;
            }
            case 22: {
                addressSize = 2;
                rDI = 44;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rDI = 60;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 4;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, 0, 4, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                assert (this.info.usedRegisters.size() == 1) : this.info.usedRegisters.size();
                this.info.usedRegisters.set(0, new UsedRegister(this.info.usedRegisters.get(0).getRegister(), 2));
                this.addRegister(flags, rCX, 6);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, rDI, 2);
                this.addRegister(flags, rDI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, instruction.getMemorySize(), 3, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 1);
                }
                this.addRegister(flags, rDI, 5);
            }
        }
    }

    private void commandLods(Instruction instruction, int flags) {
        int rCX;
        int rSI;
        int addressSize;
        switch (instruction.getOp1Kind()) {
            case 15: {
                addressSize = 1;
                rSI = 27;
                rCX = 22;
                break;
            }
            case 16: {
                addressSize = 2;
                rSI = 43;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rSI = 59;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 4;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, 0, 2, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                assert (this.info.usedRegisters.size() == 1) : this.info.usedRegisters.size();
                this.info.usedRegisters.set(0, new UsedRegister(this.info.usedRegisters.get(0).getRegister(), 4));
                this.addRegister(flags, rCX, 6);
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 2);
                this.addRegister(flags, rSI, 2);
                this.addRegister(flags, rSI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(instruction.getMemorySegment(), rSI, 0, 1, 0L, instruction.getMemorySize(), 1, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                this.addMemorySegmentRegister(flags, instruction.getMemorySegment(), 1);
                this.addRegister(flags, rSI, 5);
            }
        }
    }

    private void commandScas(Instruction instruction, int flags) {
        int rCX;
        int rDI;
        int addressSize;
        switch (instruction.getOp1Kind()) {
            case 21: {
                addressSize = 1;
                rDI = 28;
                rCX = 22;
                break;
            }
            case 22: {
                addressSize = 2;
                rDI = 44;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rDI = 60;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            this.info.opAccesses[0] = 2;
            this.info.opAccesses[1] = 2;
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, 0, 2, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                assert (this.info.usedRegisters.size() == 1) : this.info.usedRegisters.size();
                this.info.usedRegisters.set(0, new UsedRegister(this.info.usedRegisters.get(0).getRegister(), 2));
                this.addRegister(flags, rCX, 6);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, rDI, 2);
                this.addRegister(flags, rDI, 4);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, instruction.getMemorySize(), 1, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 1);
                }
                this.addRegister(flags, rDI, 5);
            }
        }
    }

    private void commandXstore(Instruction instruction, int flags, int size) {
        int rCX;
        int rDI;
        int addressSize;
        switch (size) {
            case 2: {
                addressSize = 1;
                rDI = 28;
                rCX = 22;
                break;
            }
            case 4: {
                addressSize = 2;
                rDI = 44;
                rCX = 38;
                break;
            }
            default: {
                addressSize = 3;
                rDI = 60;
                rCX = 54;
            }
        }
        if (instruction.getRepePrefix() || instruction.getRepnePrefix()) {
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, 0, 4, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                assert (this.info.usedRegisters.size() == 0) : this.info.usedRegisters.size();
                this.addRegister(flags, rCX, 6);
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 2);
                }
                this.addRegister(flags, rDI, 2);
                this.addRegister(flags, rDI, 4);
                this.addRegister(flags, 37, 4);
                this.addRegister(flags, 39, 2);
            }
        } else {
            if ((flags & 1) == 0) {
                this.addMemory(71, rDI, 0, 1, 0L, instruction.getMemorySize(), 3, addressSize, 0);
            }
            if ((flags & 2) == 0) {
                if ((flags & 4) == 0) {
                    this.addRegister(flags, 71, 1);
                }
                this.addRegister(flags, rDI, 5);
                this.addRegister(flags, 37, 3);
                this.addRegister(flags, 39, 1);
            }
        }
    }

    private void commandEnter(Instruction instruction, int flags, int opSize) {
        int rSP;
        int memSize;
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 5);
        }
        if (opSize == 8) {
            memSize = 5;
            rSP = 57;
        } else if (opSize == 4) {
            memSize = 3;
            rSP = 41;
        } else {
            assert (opSize == 2) : opSize;
            memSize = 2;
            rSP = 25;
        }
        if (rSP != xsp && (flags & 2) == 0) {
            this.addRegister(flags, rSP, 5);
        }
        int nestingLevel = instruction.getImmediate8_2nd() & 0x1F;
        long xspOffset = 0L;
        if ((flags & 2) == 0) {
            this.addRegister(flags, rSP + 1, 5);
        }
        if ((flags & 1) == 0) {
            this.addMemory(73, xsp, 0, 1, (xspOffset -= (long)opSize) & this.xspMask, memSize, 3, this.xspAddressSize, 0);
        }
        if (nestingLevel != 0) {
            int xbp = xsp + 1;
            long xbpOffset = 0L;
            for (int i = 1; i < nestingLevel; ++i) {
                if (i == 1 && rSP + 1 != xbp && (flags & 2) == 0) {
                    this.addRegister(flags, xbp, 5);
                }
                if ((flags & 1) != 0) continue;
                this.addMemory(73, xbp, 0, 1, (xbpOffset -= (long)opSize) & this.xspMask, memSize, 1, this.xspAddressSize, 0);
                this.addMemory(73, xsp, 0, 1, (xspOffset -= (long)opSize) & this.xspMask, memSize, 3, this.xspAddressSize, 0);
            }
            if ((flags & 1) == 0) {
                this.addMemory(73, xsp, 0, 1, (xspOffset -= (long)opSize) & this.xspMask, memSize, 3, this.xspAddressSize, 0);
            }
        }
    }

    private void commandLeave(Instruction instruction, int flags, int opSize) {
        int xsp = this.getXSP(instruction.getCodeSize());
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                this.addRegister(flags, 73, 1);
            }
            this.addRegister(flags, xsp, 3);
        }
        if (opSize == 8) {
            if ((flags & 1) == 0) {
                this.addMemory(73, xsp + 1, 0, 1, 0L, 5, 1, this.xspAddressSize, 0);
            }
            if ((flags & 2) == 0) {
                if (xsp + 1 == 58) {
                    this.addRegister(flags, 58, 5);
                } else {
                    this.addRegister(flags, xsp + 1, 1);
                    this.addRegister(flags, 58, 3);
                }
            }
        } else if (opSize == 4) {
            if ((flags & 1) == 0) {
                this.addMemory(73, xsp + 1, 0, 1, 0L, 3, 1, this.xspAddressSize, 0);
            }
            if ((flags & 2) == 0) {
                if (xsp + 1 == 42) {
                    this.addRegister(flags, 42, 5);
                } else {
                    this.addRegister(flags, xsp + 1, 1);
                    this.addRegister(flags, 42, 3);
                }
            }
        } else {
            assert (opSize == 2) : opSize;
            if ((flags & 1) == 0) {
                this.addMemory(73, xsp + 1, 0, 1, 0L, 2, 1, this.xspAddressSize, 0);
            }
            if ((flags & 2) == 0) {
                if (xsp + 1 == 26) {
                    this.addRegister(flags, 26, 5);
                } else {
                    this.addRegister(flags, xsp + 1, 1);
                    this.addRegister(flags, 26, 3);
                }
            }
        }
    }

    private void commandClearRflags(Instruction instruction, int flags) {
        if (instruction.getOp0Register() != instruction.getOp1Register()) {
            return;
        }
        if (instruction.getOp0Kind() != 0 || instruction.getOp1Kind() != 0) {
            return;
        }
        this.info.opAccesses[0] = 3;
        this.info.opAccesses[1] = 0;
        if ((flags & 2) == 0) {
            assert (this.info.usedRegisters.size() == 2 || this.info.usedRegisters.size() == 3) : this.info.usedRegisters.size();
            this.info.usedRegisters.clear();
            this.addRegister(flags, instruction.getOp0Register(), 3);
        }
    }

    private static boolean isClearInstr(Instruction instruction) {
        switch (instruction.getMvexRegMemConv()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void commandClearRegRegmem(Instruction instruction, int flags) {
        if (instruction.getOp0Register() != instruction.getOp1Register()) {
            return;
        }
        if (instruction.getOp1Kind() != 0) {
            return;
        }
        if (!InstructionInfoFactory.isClearInstr(instruction)) {
            return;
        }
        this.info.opAccesses[0] = 3;
        this.info.opAccesses[1] = 0;
        if ((flags & 2) == 0) {
            assert (this.info.usedRegisters.size() == 2 || this.info.usedRegisters.size() == 3) : this.info.usedRegisters.size();
            this.info.usedRegisters.set(0, new UsedRegister(instruction.getOp0Register(), 3));
            this.info.usedRegisters.remove(this.info.usedRegisters.size() - 1);
            if (this.info.usedRegisters.size() != 1) {
                this.info.usedRegisters.remove(this.info.usedRegisters.size() - 1);
            }
            assert (this.info.usedRegisters.size() == 1) : this.info.usedRegisters.size();
        }
    }

    private void commandClearRegRegRegmem(Instruction instruction, int flags) {
        if (instruction.getOp1Register() != instruction.getOp2Register()) {
            return;
        }
        if (instruction.getOp2Kind() != 0) {
            return;
        }
        if (!InstructionInfoFactory.isClearInstr(instruction)) {
            return;
        }
        this.info.opAccesses[1] = 0;
        this.info.opAccesses[2] = 0;
        if ((flags & 2) == 0) {
            assert (this.info.usedRegisters.size() == 3 || this.info.usedRegisters.size() == 4) : this.info.usedRegisters.size();
            assert (this.info.usedRegisters.get(this.info.usedRegisters.size() - 2).getRegister() == instruction.getOp1Register());
            assert (this.info.usedRegisters.get(this.info.usedRegisters.size() - 1).getRegister() == instruction.getOp2Register());
            this.info.usedRegisters.remove(this.info.usedRegisters.size() - 1);
            this.info.usedRegisters.remove(this.info.usedRegisters.size() - 1);
        }
    }

    private void commandArpl(Instruction instruction, int flags) {
        if ((flags & 2) == 0) {
            assert (this.info.usedRegisters.size() != 0) : this.info.usedRegisters.size();
            int startIndex = instruction.getOp0Kind() == 0 ? 0 : this.info.usedRegisters.size() - 1;
            for (int i = 0; i < this.info.usedRegisters.size(); ++i) {
                if (i < startIndex) continue;
                UsedRegister regInfo = this.info.usedRegisters.get(i);
                int index = InstructionInfoFactory.tryGetGpr163264Index(regInfo.getRegister());
                if (index >= 4) {
                    index += 4;
                }
                if (index < 0) continue;
                this.info.usedRegisters.set(i, new UsedRegister(1 + index, regInfo.getAccess()));
            }
        }
    }

    private void commandLastGpr(Instruction instruction, int flags, int baseReg) {
        if ((flags & 2) == 0) {
            int opCount = instruction.getOpCount();
            int immCount = instruction.getOpKind(opCount - 1) == 6 ? 1 : 0;
            boolean N = true;
            int opIndex = opCount - 1 - immCount;
            if (instruction.getOpKind(opIndex) == 0) {
                assert (this.info.usedRegisters.size() >= 1) : this.info.usedRegisters.size();
                assert (this.info.usedRegisters.get(this.info.usedRegisters.size() - 1).getRegister() == instruction.getOpRegister(opIndex));
                assert (this.info.usedRegisters.get(this.info.usedRegisters.size() - 1).getAccess() == 1);
                int index = InstructionInfoFactory.tryGetGpr163264Index(instruction.getOpRegister(opIndex));
                if (index >= 4 && baseReg == 1) {
                    index += 4;
                }
                if (index >= 0) {
                    this.info.usedRegisters.set(this.info.usedRegisters.size() - 1, new UsedRegister(baseReg + index, 1));
                }
            }
        }
    }

    private void commandLea(Instruction instruction, int flags) {
        if ((flags & 2) == 0) {
            assert (this.info.usedRegisters.size() >= 1) : this.info.usedRegisters.size();
            assert (instruction.getOp0Kind() == 0) : instruction.getOp0Kind();
            int reg = instruction.getOp0Register();
            for (int i = 1; i < this.info.usedRegisters.size(); ++i) {
                int memReg;
                UsedRegister regInfo = this.info.usedRegisters.get(i);
                if (reg >= 37 && reg <= 52) {
                    if (regInfo.getRegister() < 53 || regInfo.getRegister() > 68) continue;
                    memReg = regInfo.getRegister() - 53 + 37;
                    this.info.usedRegisters.set(i, new UsedRegister(memReg, regInfo.getAccess()));
                    continue;
                }
                if (reg >= 21 && reg <= 36) {
                    if (regInfo.getRegister() < 37 || regInfo.getRegister() > 68) continue;
                    memReg = (regInfo.getRegister() - 37 & 0xF) + 21;
                    this.info.usedRegisters.set(i, new UsedRegister(memReg, regInfo.getAccess()));
                    continue;
                }
                assert (reg >= 53 && reg <= 68) : reg;
                break;
            }
        }
    }

    private void commandEmmi(Instruction instruction, int flags, int opAccess) {
        int reg;
        if ((flags & 2) == 0 && instruction.getOp0Kind() == 0 && (reg = instruction.getOp0Register()) >= 225 && reg <= 232) {
            reg = (reg - 225 ^ 1) + 225;
            this.addRegister(flags, reg, opAccess);
        }
    }

    private void commandMemDispl(int flags, int extraDispl) {
        if ((flags & 1) == 0) {
            if (this.info.usedMemoryLocations.size() == 1) {
                long mask;
                UsedMemory mem = this.info.usedMemoryLocations.get(0);
                switch (mem.getAddressSize()) {
                    case 1: {
                        mask = 65535L;
                        break;
                    }
                    case 2: {
                        mask = 0xFFFFFFFFL;
                        break;
                    }
                    default: {
                        mask = -1L;
                    }
                }
                long displ = mem.getDisplacement() + (long)extraDispl & mask;
                this.info.usedMemoryLocations.set(0, new UsedMemory(mem.getSegment(), mem.getBase(), mem.getIndex(), mem.getScale(), displ, mem.getMemorySize(), mem.getAccess(), mem.getAddressSize(), mem.getVsibSize()));
            } else assert (false);
        }
    }

    private static int tryGetGpr163264Index(int register) {
        int index = register - 37;
        if (Integer.compareUnsigned(index, 15) <= 0) {
            return index;
        }
        index = register - 53;
        if (Integer.compareUnsigned(index, 15) <= 0) {
            return index;
        }
        index = register - 21;
        if (Integer.compareUnsigned(index, 15) <= 0) {
            return index;
        }
        return -1;
    }

    private void addMemory(int segReg, int baseReg, int indexReg, int scale, long displ, int memorySize, int access, int addressSize, int vsibSize) {
        if (addressSize == 0) {
            int reg;
            int n = reg = baseReg != 0 ? baseReg : indexReg;
            if (Register.isGPR64(reg)) {
                addressSize = 3;
            } else if (Register.isGPR32(reg)) {
                addressSize = 2;
            } else if (Register.isGPR16(reg)) {
                addressSize = 1;
            }
        }
        if (access != 7) {
            this.info.usedMemoryLocations.add(new UsedMemory(segReg, baseReg, indexReg, scale, displ, memorySize, access, addressSize, vsibSize));
        }
    }

    private void addMemorySegmentRegister(int flags, int seg, int access) {
        assert (71 <= seg && seg <= 76) : seg;
        if ((flags & 4) == 0 || seg >= 75) {
            this.addRegister(flags, seg, access);
        }
    }

    private void addRegister(int flags, int reg, int access) {
        assert ((flags & 2) == 0) : "Caller should check flags before calling this method";
        int writeReg = reg;
        if ((flags & 0xC) != 0 && Integer.compareUnsigned(access - 3, 3) <= 0) {
            int index;
            if ((flags & 4) != 0 && Integer.compareUnsigned(index = reg - 37, 15) <= 0) {
                writeReg = 53 + index;
            } else if ((flags & 8) != 0 && Integer.compareUnsigned(index = reg - 77, 95) <= 0) {
                writeReg = 141 + index % 32;
            }
            if (access != 5 && access != 6) {
                reg = writeReg;
            }
        }
        if (writeReg == reg) {
            this.info.usedRegisters.add(new UsedRegister(reg, access));
        } else {
            assert (access == 5 || access == 6) : access;
            this.info.usedRegisters.add(new UsedRegister(reg, 1));
            int lastAccess = access == 5 ? 3 : 4;
            this.info.usedRegisters.add(new UsedRegister(writeReg, lastAccess));
        }
    }

    private static final class Flags {
        static final int NO_MEMORY_USAGE = 1;
        static final int NO_REGISTER_USAGE = 2;
        static final int IS_64_BIT = 4;
        static final int ZERO_EXT_VEC_REGS = 8;

        private Flags() {
        }
    }
}

