/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.info;

import com.github.icedland.iced.x86.MemorySize;
import com.github.icedland.iced.x86.info.OpCodeInfo;
import com.github.icedland.iced.x86.internal.InstructionMemorySizes;
import com.github.icedland.iced.x86.internal.MvexInfo;
import java.util.Locale;

final class InstructionFormatter {
    private final OpCodeInfo opCode;
    private final StringBuilder sb;
    private final String[] mnemonics;
    private int r32_count;
    private int r64_count;
    private int bnd_count;
    private int startOpIndex;
    private int r32_index;
    private int r64_index;
    private int bnd_index;
    private int k_index;
    private int vec_index;
    private int tmm_index;
    private int opCount;
    private boolean opMaskIsK1;
    private boolean noVecIndex;
    private boolean swapVecIndex12;
    private boolean noGprSuffix;
    private boolean vecIndexSameAsOpIndex;
    private static final String[] convFnNames = new String[]{"Sf32", "Sf64", "Si32", "Si64", "Uf32", "Uf64", "Ui32", "Ui64", "Df32", "Df64", "Di32", "Di64"};

    private int getKIndex() {
        ++this.k_index;
        if (this.opMaskIsK1) {
            if (this.k_index == 1) {
                return 2;
            }
            if (this.k_index == 2) {
                return 1;
            }
        }
        return this.k_index;
    }

    private int getBndIndex() {
        if (this.bnd_count <= 1) {
            return 0;
        }
        ++this.bnd_index;
        return this.bnd_index;
    }

    private int getVecIndex(int opIndex) {
        if (this.noVecIndex) {
            return 0;
        }
        if (this.vecIndexSameAsOpIndex) {
            return opIndex + 1;
        }
        ++this.vec_index;
        if (this.swapVecIndex12) {
            if (this.vec_index == 1) {
                return 2;
            }
            if (this.vec_index == 2) {
                return 1;
            }
        }
        return this.vec_index;
    }

    private int getTmmIndex() {
        ++this.tmm_index;
        return this.tmm_index;
    }

    InstructionFormatter(OpCodeInfo opCode, int fmtOption, StringBuilder sb, String[] mnemonics) {
        this.opCode = opCode;
        this.sb = sb;
        this.mnemonics = mnemonics;
        this.noVecIndex = false;
        this.swapVecIndex12 = false;
        this.noGprSuffix = false;
        this.vecIndexSameAsOpIndex = false;
        this.startOpIndex = 0;
        this.bnd_count = 0;
        this.r32_count = 0;
        this.r64_count = 0;
        this.r32_index = 0;
        this.r64_index = 0;
        this.k_index = 0;
        this.vec_index = 0;
        this.tmm_index = 0;
        this.bnd_index = 0;
        this.opCount = opCode.getOpCount();
        this.opMaskIsK1 = false;
        switch (fmtOption) {
            case 0: {
                break;
            }
            case 1: {
                this.opMaskIsK1 = true;
                this.noGprSuffix = true;
                break;
            }
            case 2: {
                ++this.vec_index;
                break;
            }
            case 3: {
                this.noVecIndex = true;
                break;
            }
            case 4: {
                this.swapVecIndex12 = true;
                break;
            }
            case 5: {
                this.startOpIndex = 1;
                break;
            }
            case 6: {
                this.vecIndexSameAsOpIndex = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if ((opCode.getOp0Kind() == 42 || opCode.getOp0Kind() == 43) && opCode.getOpCount() > 2 && opCode.getEncoding() != 5) {
            this.vecIndexSameAsOpIndex = true;
        }
        block16: for (int i = 0; i < opCode.getOpCount(); ++i) {
            switch (opCode.getOpKind(i)) {
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    ++this.r32_count;
                    continue block16;
                }
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    ++this.r64_count;
                    continue block16;
                }
                case 23: 
                case 66: {
                    ++this.bnd_count;
                    continue block16;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 93: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: {
                    continue block16;
                }
                case 91: 
                case 92: 
                case 94: {
                    this.opCount = 0;
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private int getMemorySize(boolean isBroadcast) {
        int index = this.opCode.getCode();
        if (isBroadcast) {
            return InstructionMemorySizes.sizesBcst[index] & 0xFF;
        }
        return InstructionMemorySizes.sizesNormal[index] & 0xFF;
    }

    public String format() {
        if (!this.opCode.isInstruction()) {
            switch (this.opCode.getCode()) {
                case 0: {
                    return "<invalid>";
                }
                case 1: {
                    return "<db>";
                }
                case 2: {
                    return "<dw>";
                }
                case 3: {
                    return "<dd>";
                }
                case 4: {
                    return "<dq>";
                }
                case 4833: {
                    return "ZERO_BYTES";
                }
            }
            throw new UnsupportedOperationException();
        }
        this.sb.setLength(0);
        this.write(this.mnemonics[this.opCode.getMnemonic()], true);
        if (this.startOpIndex < this.opCount) {
            this.sb.append(' ');
            int saeErIndex = this.opCount - 1;
            if (this.opCode.getEncoding() != 0 && this.opCode.getOpKind(saeErIndex) == 82) {
                --saeErIndex;
            }
            boolean addComma = false;
            for (int i = this.startOpIndex; i < this.opCount; ++i) {
                int convFn;
                if (addComma) {
                    this.writeOpSeparator();
                }
                addComma = true;
                if (i == saeErIndex && this.opCode.getEncoding() == 5 && (convFn = MvexInfo.getConvFn(this.opCode.getCode())) != 0) {
                    this.sb.append(convFnNames[convFn - 1]);
                    this.sb.append('(');
                }
                int opKind = this.opCode.getOpKind(i);
                block8 : switch (opKind) {
                    case 1: {
                        this.sb.append("ptr16:16");
                        break;
                    }
                    case 2: {
                        this.sb.append("ptr16:32");
                        break;
                    }
                    case 3: {
                        this.sb.append("moffs");
                        this.writeMemorySize(this.getMemorySize(false));
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.writeMemory();
                        break;
                    }
                    case 105: {
                        this.sb.append("sibmem");
                        break;
                    }
                    case 6: {
                        this.sb.append("mib");
                        break;
                    }
                    case 7: {
                        this.sb.append("vm32x");
                        break;
                    }
                    case 8: {
                        this.sb.append("vm64x");
                        break;
                    }
                    case 9: {
                        this.sb.append("vm32y");
                        break;
                    }
                    case 10: {
                        this.sb.append("vm64y");
                        break;
                    }
                    case 11: {
                        if (this.opCode.getEncoding() == 5) {
                            this.sb.append("mvt");
                            break;
                        }
                        this.sb.append("vm32z");
                        break;
                    }
                    case 12: {
                        this.sb.append("vm64z");
                        break;
                    }
                    case 13: {
                        this.writeGprMem(8);
                        break;
                    }
                    case 14: {
                        this.writeGprMem(16);
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.writeGprMem(32);
                        break;
                    }
                    case 17: 
                    case 18: {
                        this.writeGprMem(64);
                        break;
                    }
                    case 19: {
                        this.writeRegMem("mm", this.getVecIndex(i));
                        break;
                    }
                    case 20: {
                        this.writeRegMem("xmm", this.getVecIndex(i));
                        break;
                    }
                    case 21: {
                        this.writeRegMem("ymm", this.getVecIndex(i));
                        break;
                    }
                    case 22: {
                        this.writeRegMem("zmm", this.getVecIndex(i));
                        break;
                    }
                    case 106: 
                    case 107: 
                    case 108: {
                        this.writeRegOp("tmm", this.getTmmIndex());
                        break;
                    }
                    case 23: {
                        this.writeRegOp("bnd", this.getBndIndex());
                        this.sb.append('/');
                        this.writeMemory();
                        break;
                    }
                    case 24: {
                        this.writeRegMem("k", this.getKIndex());
                        break;
                    }
                    case 25: 
                    case 26: {
                        this.writeRegOp("r8");
                        break;
                    }
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: {
                        this.writeRegOp("r16");
                        break;
                    }
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: {
                        this.writeRegOp("r32");
                        this.r32_index = this.appendGprSuffix(this.r32_count, this.r32_index);
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.writeRegOp("r64");
                        this.r64_index = this.appendGprSuffix(this.r64_count, this.r64_index);
                        break;
                    }
                    case 41: {
                        this.sb.append("Sreg");
                        break;
                    }
                    case 42: 
                    case 44: 
                    case 45: {
                        this.writeRegOp("k", this.getKIndex());
                        break;
                    }
                    case 43: {
                        this.writeRegOp("k", this.getKIndex());
                        this.sb.append("+1");
                        break;
                    }
                    case 46: 
                    case 47: {
                        this.writeRegOp("mm", this.getVecIndex(i));
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 52: 
                    case 53: {
                        this.writeRegOp("xmm", this.getVecIndex(i));
                        break;
                    }
                    case 51: {
                        this.writeRegOp("xmm", this.getVecIndex(i));
                        this.sb.append("+3");
                        break;
                    }
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        this.writeRegOp("ymm", this.getVecIndex(i));
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: {
                        this.writeRegOp("zmm", this.getVecIndex(i));
                        break;
                    }
                    case 62: {
                        this.writeRegOp("zmm", this.getVecIndex(i));
                        this.sb.append("+3");
                        break;
                    }
                    case 66: {
                        this.writeRegOp("bnd", this.getBndIndex());
                        break;
                    }
                    case 63: {
                        this.writeRegOp("cr");
                        break;
                    }
                    case 64: {
                        this.writeRegOp("dr");
                        break;
                    }
                    case 65: {
                        this.writeRegOp("tr");
                        break;
                    }
                    case 67: {
                        this.writeRegister("es");
                        break;
                    }
                    case 68: {
                        this.writeRegister("cs");
                        break;
                    }
                    case 69: {
                        this.writeRegister("ss");
                        break;
                    }
                    case 70: {
                        this.writeRegister("ds");
                        break;
                    }
                    case 71: {
                        this.writeRegister("fs");
                        break;
                    }
                    case 72: {
                        this.writeRegister("gs");
                        break;
                    }
                    case 73: {
                        this.writeRegister("al");
                        break;
                    }
                    case 74: {
                        this.writeRegister("cl");
                        break;
                    }
                    case 75: {
                        this.writeRegister("ax");
                        break;
                    }
                    case 76: {
                        this.writeRegister("dx");
                        break;
                    }
                    case 77: {
                        this.writeRegister("eax");
                        break;
                    }
                    case 78: {
                        this.writeRegister("rax");
                        break;
                    }
                    case 79: 
                    case 80: {
                        this.writeRegister("ST");
                        if (opKind == 79) {
                            switch (this.opCode.getCode()) {
                                case 587: 
                                case 588: 
                                case 655: 
                                case 656: {
                                    break block8;
                                }
                            }
                            this.sb.append("(0)");
                            break;
                        }
                        assert (opKind == 80) : opKind;
                        this.sb.append("(i)");
                        break;
                    }
                    case 81: {
                        this.sb.append("imm4");
                        break;
                    }
                    case 82: 
                    case 84: 
                    case 85: 
                    case 86: {
                        this.sb.append("imm8");
                        break;
                    }
                    case 83: {
                        this.sb.append('1');
                        break;
                    }
                    case 87: {
                        this.sb.append("imm16");
                        break;
                    }
                    case 88: 
                    case 89: {
                        this.sb.append("imm32");
                        break;
                    }
                    case 90: {
                        this.sb.append("imm64");
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: {
                        addComma = false;
                        break;
                    }
                    case 95: 
                    case 96: 
                    case 97: {
                        this.sb.append("rel8");
                        break;
                    }
                    case 98: 
                    case 101: {
                        this.sb.append("rel16");
                        break;
                    }
                    case 99: 
                    case 100: 
                    case 102: {
                        this.sb.append("rel32");
                        break;
                    }
                    case 103: {
                        this.sb.append("disp16");
                        break;
                    }
                    case 104: {
                        this.sb.append("disp32");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                if (i == saeErIndex && this.opCode.getEncoding() == 5 && MvexInfo.getConvFn(this.opCode.getCode()) != 0) {
                    this.sb.append(')');
                }
                if (i == 0 && this.opCode.canUseOpMaskRegister()) {
                    this.sb.append(' ');
                    this.writeRegDecorator("k", this.getKIndex());
                    if (this.opCode.canUseZeroingMasking()) {
                        this.writeDecorator("z");
                    }
                }
                if (i != saeErIndex || this.opCode.getEncoding() == 5) continue;
                if (this.opCode.canSuppressAllExceptions()) {
                    this.writeDecorator("sae");
                }
                if (!this.opCode.canUseRoundingControl()) continue;
                this.writeDecorator("er");
            }
        }
        switch (this.opCode.getCode()) {
            case 2035: 
            case 2036: 
            case 2041: 
            case 2042: {
                this.writeOpSeparator();
                this.write("<EDX>", false);
                this.writeOpSeparator();
                this.write("<EAX>", false);
                break;
            }
            case 2633: 
            case 2660: 
            case 2670: 
            case 3619: {
                this.writeOpSeparator();
                this.write("<XMM0>", true);
                break;
            }
            case 4283: 
            case 4284: 
            case 4285: 
            case 4286: {
                this.writeOpSeparator();
                this.write("<XMM0-7>", true);
                break;
            }
            case 4287: {
                this.writeOpSeparator();
                this.write("<EAX>", true);
                this.writeOpSeparator();
                this.write("<XMM0>", true);
                break;
            }
            case 4292: {
                this.writeOpSeparator();
                this.write("<XMM0-2>", true);
                this.writeOpSeparator();
                this.write("<XMM4-6>", true);
                break;
            }
            case 4293: {
                this.writeOpSeparator();
                this.write("<XMM0-6>", true);
                break;
            }
            case 4303: {
                this.writeOpSeparator();
                this.write("<EAX>", true);
                break;
            }
        }
        return this.sb.toString();
    }

    private void writeMemorySize(int memorySize) {
        switch (this.opCode.getCode()) {
            case 515: 
            case 520: 
            case 521: 
            case 615: 
            case 616: {
                this.sb.append("2byte");
                return;
            }
        }
        switch (memorySize) {
            case 22: {
                this.sb.append("16&16");
                break;
            }
            case 23: {
                this.sb.append("32&32");
                break;
            }
            case 34: {
                this.sb.append("14byte");
                break;
            }
            case 35: {
                this.sb.append("28byte");
                break;
            }
            case 36: {
                this.sb.append("94byte");
                break;
            }
            case 37: {
                this.sb.append("108byte");
                break;
            }
            case 38: 
            case 39: {
                this.sb.append("512byte");
                break;
            }
            case 40: 
            case 41: {
                this.sb.append("em");
                break;
            }
            case 16: {
                this.sb.append("16:16");
                break;
            }
            case 17: {
                this.sb.append("16:32");
                break;
            }
            case 18: {
                this.sb.append("16:64");
                break;
            }
            case 26: {
                if (this.isSgdtOrSidt()) break;
                this.sb.append("16&32");
                break;
            }
            case 27: {
                if (this.isSgdtOrSidt()) break;
                this.sb.append("16&64");
                break;
            }
            default: {
                int memSize = MemorySize.getSize(memorySize);
                if (memSize == 0) break;
                this.sb.append(memSize * 8);
            }
        }
        if (InstructionFormatter.isFpuInstruction(this.opCode.getCode())) {
            switch (memorySize) {
                case 10: 
                case 11: 
                case 12: {
                    this.sb.append("int");
                    break;
                }
                case 29: 
                case 30: 
                case 31: {
                    this.sb.append("fp");
                    break;
                }
                case 42: {
                    this.sb.append("bcd");
                }
            }
        }
    }

    private boolean isSgdtOrSidt() {
        switch (this.opCode.getCode()) {
            case 792: 
            case 793: 
            case 794: 
            case 795: 
            case 796: 
            case 797: {
                return true;
            }
        }
        return false;
    }

    private void writeRegister(String register) {
        this.write(register, true);
    }

    private void writeRegOp(String register) {
        this.write(register, false);
    }

    private void writeRegOp(String register, int index) {
        this.writeRegOp(register);
        if (index > 0) {
            this.sb.append(index);
        }
    }

    private void writeDecorator(String decorator) {
        this.sb.append('{');
        this.write(decorator, false);
        this.sb.append('}');
    }

    private void writeRegDecorator(String register, int index) {
        this.sb.append('{');
        this.write(register, false);
        this.sb.append(index);
        this.sb.append('}');
    }

    private int appendGprSuffix(int count, int index) {
        if (count <= 1 || this.noGprSuffix) {
            return index;
        }
        this.sb.append((char)(97 + index));
        return ++index;
    }

    private void writeOpSeparator() {
        this.sb.append(", ");
    }

    private void write(String s, boolean upper) {
        String fixed = upper ? s.toUpperCase(Locale.ROOT) : s.toLowerCase(Locale.ROOT);
        this.sb.append(fixed);
    }

    private void writeGprMem(int regSize) {
        assert (!this.opCode.canBroadcast());
        this.sb.append('r');
        int memSize = MemorySize.getSize(this.getMemorySize(false)) * 8;
        if (memSize != regSize) {
            this.sb.append(regSize);
        }
        this.sb.append('/');
        this.writeMemory();
    }

    private void writeRegMem(String register, int index) {
        this.writeRegOp(register, index);
        this.sb.append('/');
        this.writeMemory();
    }

    private void writeMemory() {
        this.writeMemory(false);
        if (this.opCode.canBroadcast()) {
            this.sb.append('/');
            this.writeMemory(true);
        }
    }

    private void writeMemory(boolean isBroadcast) {
        int memorySize = this.getMemorySize(isBroadcast);
        this.sb.append('m');
        if (this.opCode.getEncoding() == 5 && MvexInfo.getEHBit(this.opCode.getCode()) == 0 && !MvexInfo.getIgnoresEvictionHint(this.opCode.getCode())) {
            this.sb.append('t');
        }
        this.writeMemorySize(memorySize);
        if (isBroadcast) {
            this.sb.append("bcst");
        }
    }

    private static boolean isFpuInstruction(int code) {
        return Integer.compareUnsigned(code - 494, 162) <= 0;
    }
}

