/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_os_mem_reg16
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;

    SimpleInstrInfo_os_mem_reg16(int bitness, String mnemonic) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int REG_MASK = 255;
        int flags = 0;
        int instrBitness = SimpleInstrInfo_os_mem_reg16.getBitness(instruction.getCodeSize());
        assert (instruction.getOpCount() == 1) : instruction.getOpCount();
        if (!(instruction.getOp0Kind() != 24 || instrBitness == 0 || instrBitness != 64 && instrBitness == this.bitness || instrBitness == 64 && this.bitness == 32)) {
            flags = this.bitness == 16 ? (flags |= 8) : (this.bitness == 32 ? (flags |= 0x10) : (flags |= 0x18));
        }
        InstrOpInfo info = new InstrOpInfo(this.mnemonic, instruction, flags);
        if (instruction.getOp0Kind() == 0) {
            int reg = info.op0Register & 0xFF;
            int regSize = 0;
            if (21 <= reg && reg <= 36) {
                regSize = 16;
            } else if (37 <= reg && reg <= 52) {
                regSize = 32;
                reg = reg - 37 + 21;
            } else if (53 <= reg && reg <= 68) {
                regSize = 64;
                reg = reg - 53 + 21;
            }
            assert (regSize != 0) : regSize;
            if (regSize != 0) {
                info.op0Register = (byte)reg;
                if (!(instrBitness != 64 && instrBitness == regSize || instrBitness == 64 && regSize == 32)) {
                    info.flags = this.bitness == 16 ? (info.flags |= 8) : (this.bitness == 32 ? (info.flags |= 0x10) : (info.flags |= 0x18));
                }
            }
        }
        return info;
    }
}

