/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_String
extends InstrInfo {
    private final FormatterString mnemonic;

    SimpleInstrInfo_String(String mnemonic) {
        this.mnemonic = new FormatterString(mnemonic);
    }

    static int getAddressSizeFlags(int opKind) {
        switch (opKind) {
            case 15: 
            case 18: 
            case 21: {
                return 32;
            }
            case 16: 
            case 19: 
            case 22: {
                return 64;
            }
            case 17: 
            case 20: 
            case 23: {
                return 96;
            }
        }
        return 0;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int instrFlags;
        int opKind = instruction.getOp0Kind() != 0 ? instruction.getOp0Kind() : instruction.getOp1Kind();
        int opKindFlags = SimpleInstrInfo_String.getAddressSizeFlags(opKind);
        switch (instruction.getCodeSize()) {
            case 0: {
                instrFlags = opKindFlags;
                break;
            }
            case 1: {
                instrFlags = 32;
                break;
            }
            case 2: {
                instrFlags = 64;
                break;
            }
            case 3: {
                instrFlags = 96;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int flags = 0;
        if (opKindFlags != instrFlags) {
            flags |= opKindFlags;
        }
        InstrOpInfo info = new InstrOpInfo();
        info.flags = flags;
        info.mnemonic = this.mnemonic;
        return info;
    }
}

