/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.masm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.masm.InstrInfo;
import com.github.icedland.iced.x86.fmt.masm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_nop
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;
    private final int register;
    private static final FormatterString str_xchg = new FormatterString("xchg");

    SimpleInstrInfo_nop(int bitness, String mnemonic, int register) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
        this.register = register;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int instrBitness = SimpleInstrInfo_nop.getBitness(instruction.getCodeSize());
        if (instrBitness == 0 || (instrBitness & this.bitness) != 0) {
            return new InstrOpInfo(this.mnemonic, instruction, 0);
        }
        InstrOpInfo info = new InstrOpInfo();
        info.mnemonic = str_xchg;
        info.opCount = (byte)2;
        info.op0Register = (byte)this.register;
        info.op1Register = (byte)this.register;
        info.op0Index = (byte)-2;
        info.op1Index = (byte)-2;
        return info;
    }
}

