/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.masm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.masm.InstrInfo;
import com.github.icedland.iced.x86.fmt.masm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

final class SimpleInstrInfo_maskmovq
extends InstrInfo {
    private final FormatterString mnemonic;
    private final int flags;

    SimpleInstrInfo_maskmovq(String mnemonic, int flags) {
        this.mnemonic = new FormatterString(mnemonic);
        this.flags = flags;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        boolean shortForm;
        int shortFormOpKind;
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        switch (instruction.getCodeSize()) {
            case 0: {
                shortFormOpKind = instruction.getOp0Kind();
                break;
            }
            case 1: {
                shortFormOpKind = 18;
                break;
            }
            case 2: {
                shortFormOpKind = 19;
                break;
            }
            case 3: {
                shortFormOpKind = 20;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean bl = shortForm = instruction.getOp0Kind() == shortFormOpKind && (instruction.getSegmentPrefix() == 0 || !FormatterUtils.showSegmentPrefix(74, instruction, options));
        if (!shortForm) {
            return new InstrOpInfo(this.mnemonic, instruction, this.flags);
        }
        InstrOpInfo info = new InstrOpInfo();
        info.flags = this.flags;
        info.mnemonic = this.mnemonic;
        info.opCount = (byte)2;
        info.op0Kind = (byte)instruction.getOp1Kind();
        info.op0Index = 1;
        info.op0Register = (byte)instruction.getOp1Register();
        info.op1Kind = (byte)instruction.getOp2Kind();
        info.op1Index = (byte)2;
        info.op1Register = (byte)instruction.getOp2Register();
        return info;
    }
}

