/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.intel.InstrInfo;
import com.github.icedland.iced.x86.fmt.intel.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.MnemonicCC;

final class SimpleInstrInfo_os_jcc
extends InstrInfo {
    private final int bitness;
    private final int ccIndex;
    private final FormatterString[] mnemonics;
    private final int flags;

    SimpleInstrInfo_os_jcc(int bitness, int ccIndex, String[] mnemonics) {
        this(bitness, ccIndex, mnemonics, 0);
    }

    SimpleInstrInfo_os_jcc(int bitness, int ccIndex, String[] mnemonics, int flags) {
        this.bitness = bitness;
        this.ccIndex = ccIndex;
        this.mnemonics = FormatterString.create(mnemonics);
        this.flags = flags;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int prefixSeg;
        int flags = this.flags;
        int instrBitness = SimpleInstrInfo_os_jcc.getBitness(instruction.getCodeSize());
        if (instrBitness != 0 && instrBitness != this.bitness) {
            flags = this.bitness == 16 ? (flags |= 0x10) : (this.bitness == 32 ? (flags |= 0x20) : (flags |= 0x30));
        }
        if ((prefixSeg = instruction.getSegmentPrefix()) == 72) {
            flags |= 0x4400;
        } else if (prefixSeg == 74) {
            flags |= 0x4800;
        }
        if (instruction.getRepnePrefix()) {
            flags |= 0x1000;
        }
        FormatterString mnemonic = MnemonicCC.getMnemonicCC(options, this.ccIndex, this.mnemonics);
        return new InstrOpInfo(mnemonic, instruction, flags);
    }
}

