/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.intel.InstrInfo;
import com.github.icedland.iced.x86.fmt.intel.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_movabs
extends InstrInfo {
    private final FormatterString mnemonic;

    SimpleInstrInfo_movabs(String mnemonic) {
        this.mnemonic = new FormatterString(mnemonic);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int memSize;
        int flags = 0;
        int instrBitness = SimpleInstrInfo_movabs.getBitness(instruction.getCodeSize());
        switch (instruction.getMemoryDisplSize()) {
            case 2: {
                memSize = 16;
                break;
            }
            case 4: {
                memSize = 32;
                break;
            }
            default: {
                memSize = 64;
            }
        }
        if (instrBitness == 0) {
            instrBitness = memSize;
        }
        if (instrBitness != memSize) {
            flags = memSize == 16 ? (flags |= 0x40) : (memSize == 32 ? (flags |= 0x80) : (flags |= 0xC0));
        }
        return new InstrOpInfo(this.mnemonic, instruction, flags);
    }
}

