/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.fmt.intel.InstrInfo;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_DeclareData;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_Reg16;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_Reg32;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_ST1;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_ST2;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_ST_STi;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_STi_ST;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_StringIg0;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_StringIg1;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_as;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_bcst;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_bnd;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_cc;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_imul;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_invlpga;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_maskmovq;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_memsize;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_movabs;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_nop;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_opmask_op;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_os;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_os_bnd;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_os_jcc;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_os_loop;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_pclmulqdq;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_pops;
import com.github.icedland.iced.x86.fmt.intel.SimpleInstrInfo_reg;
import com.github.icedland.iced.x86.internal.DataReader;
import com.github.icedland.iced.x86.internal.ResourceReader;
import com.github.icedland.iced.x86.internal.fmt.FormatterConstants;
import com.github.icedland.iced.x86.internal.fmt.FormatterStringsTable;

final class InstrInfos {
    static final InstrInfo[] allInfos = InstrInfos.readInfos();

    InstrInfos() {
    }

    private static byte[] getSerializedInstrInfos() {
        return ResourceReader.readByteArray(InstrInfos.class.getClassLoader(), "com/github/icedland/iced/x86/fmt/intel/InstrInfos.bin");
    }

    private static String addPrefix(String s, char[] ca) {
        return (new String(ca) + s).intern();
    }

    private static InstrInfo[] readInfos() {
        DataReader reader = new DataReader(InstrInfos.getSerializedInstrInfos());
        InstrInfo[] infos = new InstrInfo[4936];
        String[] strings = FormatterStringsTable.getStringsTable();
        char[] ca = new char[1];
        int prevIndex = -1;
        for (int i = 0; i < infos.length; ++i) {
            InstrInfo instrInfo;
            int currentIndex;
            byte f = (byte)reader.readByte();
            byte ctorKind = (byte)(f & 0x7F);
            if (ctorKind == 0) {
                currentIndex = reader.getIndex();
                reader.setIndex(prevIndex);
                ctorKind = (byte)(reader.readByte() & 0x7F);
            } else {
                currentIndex = -1;
                prevIndex = reader.getIndex() - 1;
            }
            String s = strings[reader.readCompressedUInt32()];
            if ((f & 0x80) != 0) {
                ca[0] = 118;
                s = InstrInfos.addPrefix(s, ca);
            }
            switch (ctorKind) {
                case 1: {
                    instrInfo = new SimpleInstrInfo(s);
                    break;
                }
                case 2: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo(s, v);
                    break;
                }
                case 3: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_as(v, s);
                    break;
                }
                case 4: {
                    instrInfo = new SimpleInstrInfo_StringIg0(s);
                    break;
                }
                case 5: {
                    instrInfo = new SimpleInstrInfo_StringIg1(s);
                    break;
                }
                case 6: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_bcst(s, v);
                    break;
                }
                case 7: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_bnd(s, v);
                    break;
                }
                case 9: {
                    instrInfo = new SimpleInstrInfo_DeclareData(i, s);
                    break;
                }
                case 10: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_ST_STi(s, v != 0);
                    break;
                }
                case 11: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STi_ST(s, v != 0);
                    break;
                }
                case 12: {
                    instrInfo = new SimpleInstrInfo_imul(s);
                    break;
                }
                case 13: {
                    instrInfo = new SimpleInstrInfo_opmask_op(s);
                    break;
                }
                case 15: {
                    instrInfo = new SimpleInstrInfo_maskmovq(s);
                    break;
                }
                case 16: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_memsize(v, s);
                    break;
                }
                case 17: {
                    instrInfo = new SimpleInstrInfo_movabs(s);
                    break;
                }
                case 18: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_nop(v, s, v2);
                    break;
                }
                case 19: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os(v, s);
                    break;
                }
                case 20: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os(v, s, v2);
                    break;
                }
                case 21: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_bnd(v, s);
                    break;
                }
                case 22: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s});
                    break;
                }
                case 23: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2});
                    break;
                }
                case 24: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2, s3});
                    break;
                }
                case 25: {
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s});
                    break;
                }
                case 26: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s, s2});
                    break;
                }
                case 27: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s, s2, s3});
                    break;
                }
                case 28: {
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v3, new String[]{s}, v2);
                    break;
                }
                case 29: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v3, new String[]{s, s2}, v2);
                    break;
                }
                case 30: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v3, new String[]{s, s2, s3}, v2);
                    break;
                }
                case 31: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_os_loop(v, v3, v2, new String[]{s, s2});
                    break;
                }
                case 32: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_os_loop(v, -1, v2, new String[]{s});
                    break;
                }
                case 33: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pclmulqdq(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 34: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pops(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 35: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_reg(s, v);
                    break;
                }
                case 36: {
                    instrInfo = new SimpleInstrInfo_Reg16(s);
                    break;
                }
                case 37: {
                    instrInfo = new SimpleInstrInfo_Reg32(s);
                    break;
                }
                case 38: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_ST1(s, v);
                    break;
                }
                case 39: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    if (v2 > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_ST1(s, v, v2 != 0);
                    break;
                }
                case 8: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_ST2(s, v);
                    break;
                }
                case 14: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_invlpga(v, s);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            infos[i] = instrInfo;
            if (currentIndex < 0) continue;
            reader.setIndex(currentIndex);
        }
        if (reader.canRead()) {
            throw new UnsupportedOperationException();
        }
        return infos;
    }
}

