/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.fmt.gas.SimpleInstrInfo_er;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_pops
extends InstrInfo {
    private final FormatterString mnemonic;
    private final FormatterString[] pseudo_ops;
    private final boolean canUseSae;

    SimpleInstrInfo_pops(String mnemonic, FormatterString[] pseudo_ops, boolean canUseSae) {
        this.mnemonic = new FormatterString(mnemonic);
        this.pseudo_ops = pseudo_ops;
        this.canUseSae = canUseSae;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info = new InstrOpInfo(this.mnemonic, instruction, 0);
        if (this.canUseSae && instruction.getSuppressAllExceptions()) {
            SimpleInstrInfo_er.moveOperands(info, 1, 25);
        }
        int imm = instruction.getImmediate8() & 0xFF;
        if (options.getUsePseudoOps() && Integer.compareUnsigned(imm, this.pseudo_ops.length) < 0) {
            SimpleInstrInfo_pops.removeFirstImm8Operand(info);
            info.mnemonic = this.pseudo_ops[imm];
        }
        return info;
    }

    static void removeFirstImm8Operand(InstrOpInfo info) {
        assert (info.op0Kind == 6) : info.op0Kind;
        info.opCount = (byte)(info.opCount - 1);
        switch (info.opCount) {
            case 0: {
                info.op0Index = (byte)-1;
                break;
            }
            case 1: {
                info.op0Kind = info.op1Kind;
                info.op0Register = info.op1Register;
                info.op0Index = info.op1Index;
                info.op1Index = (byte)-1;
                break;
            }
            case 2: {
                info.op0Kind = info.op1Kind;
                info.op0Register = info.op1Register;
                info.op1Kind = info.op2Kind;
                info.op1Register = info.op2Register;
                info.op0Index = info.op1Index;
                info.op1Index = info.op2Index;
                info.op2Index = (byte)-1;
                break;
            }
            case 3: {
                info.op0Kind = info.op1Kind;
                info.op0Register = info.op1Register;
                info.op1Kind = info.op2Kind;
                info.op1Register = info.op2Register;
                info.op2Kind = info.op3Kind;
                info.op2Register = info.op3Register;
                info.op0Index = info.op1Index;
                info.op1Index = info.op2Index;
                info.op2Index = info.op3Index;
                info.op3Index = (byte)-1;
                break;
            }
            case 4: {
                info.op0Kind = info.op1Kind;
                info.op0Register = info.op1Register;
                info.op1Kind = info.op2Kind;
                info.op1Register = info.op2Register;
                info.op2Kind = info.op3Kind;
                info.op2Register = info.op3Register;
                info.op3Kind = info.op4Kind;
                info.op3Register = info.op4Register;
                info.op0Index = info.op1Index;
                info.op1Index = info.op2Index;
                info.op2Index = info.op3Index;
                info.op3Index = info.op4Index;
                info.op4Index = (byte)-1;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

