/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.MnemonicCC;

final class SimpleInstrInfo_os_loop
extends InstrInfo {
    private final int bitness;
    private final int regSize;
    private final int ccIndex;
    private final FormatterString[] mnemonics;
    private final FormatterString[] mnemonics_suffix;

    SimpleInstrInfo_os_loop(int bitness, int regSize, int ccIndex, String[] mnemonics, String[] mnemonics_suffix) {
        this.bitness = bitness;
        this.regSize = regSize;
        this.ccIndex = ccIndex;
        this.mnemonics = FormatterString.create(mnemonics);
        this.mnemonics_suffix = FormatterString.create(mnemonics_suffix);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int flags = 0;
        int instrBitness = SimpleInstrInfo_os_loop.getBitness(instruction.getCodeSize());
        FormatterString[] mnemonics = this.mnemonics;
        if (instrBitness != 0 && instrBitness != this.regSize || options.getGasShowMnemonicSizeSuffix()) {
            mnemonics = this.mnemonics_suffix;
        }
        if (instrBitness != 0 && instrBitness != this.bitness) {
            flags = this.bitness == 16 ? (flags |= 0x42) : (this.bitness == 32 ? (flags |= 0x44) : (flags |= 6));
        }
        FormatterString mnemonic = this.ccIndex == -1 ? mnemonics[0] : MnemonicCC.getMnemonicCC(options, this.ccIndex, mnemonics);
        return new InstrOpInfo(mnemonic, instruction, flags);
    }
}

