/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_maskmovq
extends InstrInfo {
    private final FormatterString mnemonic;

    SimpleInstrInfo_maskmovq(String mnemonic) {
        this.mnemonic = new FormatterString(mnemonic);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int bitness;
        assert (instruction.getOpCount() == 3) : instruction.getOpCount();
        int instrBitness = SimpleInstrInfo_maskmovq.getBitness(instruction.getCodeSize());
        switch (instruction.getOp0Kind()) {
            case 18: {
                bitness = 16;
                break;
            }
            case 19: {
                bitness = 32;
                break;
            }
            case 20: {
                bitness = 64;
                break;
            }
            default: {
                bitness = instrBitness;
            }
        }
        InstrOpInfo info = new InstrOpInfo();
        info.mnemonic = this.mnemonic;
        info.opCount = (byte)2;
        info.op0Kind = (byte)instruction.getOp2Kind();
        info.op0Register = (byte)instruction.getOp2Register();
        info.op0Index = (byte)2;
        info.op1Kind = (byte)instruction.getOp1Kind();
        info.op1Register = (byte)instruction.getOp1Register();
        info.op1Index = 1;
        if (instrBitness != 0 && instrBitness != bitness) {
            info.flags = bitness == 16 ? (info.flags |= 8) : (bitness == 32 ? (info.flags |= 0x10) : (info.flags |= 0x18));
        }
        return info;
    }
}

