/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.MvexInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

final class SimpleInstrInfo_er
extends InstrInfo {
    private final int erIndex;
    private final FormatterString mnemonic;
    private final FormatterString mnemonic_suffix;
    private final int flags;

    SimpleInstrInfo_er(int erIndex, String mnemonic) {
        this(erIndex, mnemonic, mnemonic, 0);
    }

    SimpleInstrInfo_er(int erIndex, String mnemonic, String mnemonic_suffix, int flags) {
        this.erIndex = erIndex;
        this.mnemonic = new FormatterString(mnemonic);
        this.mnemonic_suffix = new FormatterString(mnemonic_suffix);
        this.flags = flags;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info;
        block25: {
            block21: {
                block22: {
                    int rcOpKind;
                    block24: {
                        int rc;
                        block23: {
                            info = new InstrOpInfo(SimpleInstrInfo_er.getMnemonic(options, instruction, this.mnemonic, this.mnemonic_suffix, this.flags), instruction, this.flags);
                            if (!MvexInfo.isMvex(instruction.getCode())) break block21;
                            rc = instruction.getRoundingControl();
                            if (rc == 0) break block22;
                            if (!instruction.getSuppressAllExceptions()) break block23;
                            switch (rc) {
                                case 1: {
                                    rcOpKind = 26;
                                    break block24;
                                }
                                case 2: {
                                    rcOpKind = 27;
                                    break block24;
                                }
                                case 3: {
                                    rcOpKind = 28;
                                    break block24;
                                }
                                case 4: {
                                    rcOpKind = 29;
                                    break block24;
                                }
                                default: {
                                    return info;
                                }
                            }
                        }
                        switch (rc) {
                            case 1: {
                                rcOpKind = 30;
                                break;
                            }
                            case 2: {
                                rcOpKind = 31;
                                break;
                            }
                            case 3: {
                                rcOpKind = 32;
                                break;
                            }
                            case 4: {
                                rcOpKind = 33;
                                break;
                            }
                            default: {
                                return info;
                            }
                        }
                    }
                    SimpleInstrInfo_er.moveOperands(info, this.erIndex, rcOpKind);
                    break block25;
                }
                if (instruction.getSuppressAllExceptions()) {
                    SimpleInstrInfo_er.moveOperands(info, this.erIndex, 25);
                }
                break block25;
            }
            int rc = instruction.getRoundingControl();
            if (rc != 0) {
                int rcOpKind;
                if (!FormatterUtils.canShowRoundingControl(instruction, options)) {
                    return info;
                }
                switch (rc) {
                    case 1: {
                        rcOpKind = 26;
                        break;
                    }
                    case 2: {
                        rcOpKind = 27;
                        break;
                    }
                    case 3: {
                        rcOpKind = 28;
                        break;
                    }
                    case 4: {
                        rcOpKind = 29;
                        break;
                    }
                    default: {
                        return info;
                    }
                }
                SimpleInstrInfo_er.moveOperands(info, this.erIndex, rcOpKind);
            }
        }
        return info;
    }

    static void moveOperands(InstrOpInfo info, int index, int newOpKind) {
        assert (info.opCount <= 4) : info.opCount;
        switch (index) {
            case 0: {
                info.op4Kind = info.op3Kind;
                info.op4Register = info.op3Register;
                info.op3Kind = info.op2Kind;
                info.op3Register = info.op2Register;
                info.op2Kind = info.op1Kind;
                info.op2Register = info.op1Register;
                info.op1Kind = info.op0Kind;
                info.op1Register = info.op0Register;
                info.op0Kind = (byte)newOpKind;
                info.op4Index = info.op3Index;
                info.op3Index = info.op2Index;
                info.op2Index = info.op1Index;
                info.op1Index = info.op0Index;
                info.op0Index = (byte)-2;
                info.opCount = (byte)(info.opCount + 1);
                break;
            }
            case 1: {
                info.op4Kind = info.op3Kind;
                info.op4Register = info.op3Register;
                info.op3Kind = info.op2Kind;
                info.op3Register = info.op2Register;
                info.op2Kind = info.op1Kind;
                info.op2Register = info.op1Register;
                info.op1Kind = (byte)newOpKind;
                info.op4Index = info.op3Index;
                info.op3Index = info.op2Index;
                info.op2Index = info.op1Index;
                info.op1Index = (byte)-2;
                info.opCount = (byte)(info.opCount + 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

