/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_DeclareData
extends InstrInfo {
    private final FormatterString mnemonic;
    private final int opKind;

    SimpleInstrInfo_DeclareData(int code, String mnemonic) {
        int opKind;
        this.mnemonic = new FormatterString(mnemonic);
        switch (code) {
            case 1: {
                opKind = 34;
                break;
            }
            case 2: {
                opKind = 35;
                break;
            }
            case 3: {
                opKind = 36;
                break;
            }
            case 4: {
                opKind = 37;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.opKind = opKind;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info = new InstrOpInfo(this.mnemonic, instruction, 4224);
        info.opCount = (byte)instruction.getDeclareDataCount();
        info.op0Kind = (byte)this.opKind;
        info.op1Kind = (byte)this.opKind;
        info.op2Kind = (byte)this.opKind;
        info.op3Kind = (byte)this.opKind;
        info.op4Kind = (byte)this.opKind;
        info.op0Index = (byte)-3;
        info.op1Index = (byte)-3;
        info.op2Index = (byte)-3;
        info.op3Index = (byte)-3;
        info.op4Index = (byte)-3;
        return info;
    }
}

