/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.fast;

import com.github.icedland.iced.x86.Code;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.InternalInstructionUtils;
import com.github.icedland.iced.x86.fmt.SymbolResolver;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import com.github.icedland.iced.x86.fmt.TextInfo;
import com.github.icedland.iced.x86.fmt.TextPart;
import com.github.icedland.iced.x86.fmt.fast.FastFormatterOptions;
import com.github.icedland.iced.x86.fmt.fast.FastStringOutput;
import com.github.icedland.iced.x86.fmt.fast.FmtData;
import com.github.icedland.iced.x86.fmt.fast.MemorySizes;
import com.github.icedland.iced.x86.fmt.fast.Registers;
import com.github.icedland.iced.x86.internal.MvexInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterConstants;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

public final class FastFormatter {
    private final FastFormatterOptions options = new FastFormatterOptions();
    private final SymbolResolver symbolResolver;
    private final FormatterString[] allRegisters;
    private final String[] codeMnemonics;
    private final byte[] codeFlags;
    private final String[] allMemorySizes;
    private final String[] rcStrings;
    private final String[] rcSaeStrings;
    private final String[] scaleNumbers;
    private final String[] mvexRegMemConsts32;
    private final String[] mvexRegMemConsts64;
    private static final boolean SHOW_USELESS_PREFIXES = true;
    private static final String[] s_rcStrings = new String[]{"{rn}", "{rd}", "{ru}", "{rz}"};
    private static final String[] s_rcSaeStrings = new String[]{"{rn-sae}", "{rd-sae}", "{ru-sae}", "{rz-sae}"};
    private static final String[] s_scaleNumbers = new String[]{"*1", "*2", "*4", "*8"};
    private static final String[] s_mvexRegMemConsts32 = new String[]{"", "", "{cdab}", "{badc}", "{dacb}", "{aaaa}", "{bbbb}", "{cccc}", "{dddd}", "", "{1to16}", "{4to16}", "{float16}", "{uint8}", "{sint8}", "{uint16}", "{sint16}"};
    private static final String[] s_mvexRegMemConsts64 = new String[]{"", "", "{cdab}", "{badc}", "{dacb}", "{aaaa}", "{bbbb}", "{cccc}", "{dddd}", "", "{1to8}", "{4to8}", "{float16}", "{uint8}", "{sint8}", "{uint16}", "{sint16}"};

    public FastFormatterOptions getOptions() {
        return this.options;
    }

    public FastFormatter() {
        this(null);
    }

    public FastFormatter(SymbolResolver symbolResolver) {
        this.symbolResolver = symbolResolver;
        this.allRegisters = Registers.allRegisters;
        this.codeMnemonics = FmtData.mnemonics;
        this.codeFlags = FmtData.flags;
        this.allMemorySizes = MemorySizes.allMemorySizes;
        this.rcStrings = s_rcStrings;
        this.rcSaeStrings = s_rcSaeStrings;
        this.scaleNumbers = s_scaleNumbers;
        this.mvexRegMemConsts32 = s_mvexRegMemConsts32;
        this.mvexRegMemConsts64 = s_mvexRegMemConsts64;
    }

    public void format(Instruction instruction, FastStringOutput output) {
        int declareDataOpKind;
        boolean isDeclareData;
        int prefixSeg;
        boolean hasNoTrackPrefix;
        if (output == null) {
            throw new NullPointerException("output");
        }
        int code = instruction.getCode();
        String mnemonic = this.codeMnemonics[code];
        int flags = this.codeFlags[code] & 0xFF;
        int opCount = instruction.getOpCount();
        int pseudoOpsNum = flags >>> 3;
        if (pseudoOpsNum != 0 && this.options.getUsePseudoOps() && instruction.getOpKind(opCount - 1) == 6) {
            int index = instruction.getImmediate8() & 0xFF;
            int pseudoOpKind = pseudoOpsNum - 1;
            if (pseudoOpKind == 30) {
                switch (code) {
                    case 4804: {
                        pseudoOpKind = 31;
                        break;
                    }
                }
            }
            FormatterString[] pseudoOps = FormatterConstants.getPseudoOps(pseudoOpKind);
            if ((pseudoOpKind == 8 || pseudoOpKind == 9) && index > 1) {
                index = index == 16 ? 2 : (index == 17 ? 3 : -1);
            }
            if (Integer.compareUnsigned(index, pseudoOps.length) < 0) {
                mnemonic = pseudoOps[index].getLower();
                --opCount;
            }
        }
        boolean bl = hasNoTrackPrefix = (prefixSeg = instruction.getSegmentPrefix()) == 74 && FormatterUtils.isNotrackPrefixBranch(code);
        if (!hasNoTrackPrefix && prefixSeg != 0 && FastFormatter.showSegmentPrefix(instruction, opCount)) {
            this.formatRegister(output, prefixSeg);
            output.append(' ');
        }
        boolean hasXacquirePrefix = false;
        if (instruction.getXacquirePrefix()) {
            output.append("xacquire ");
            hasXacquirePrefix = true;
        }
        if (instruction.getXreleasePrefix()) {
            output.append("xrelease ");
            hasXacquirePrefix = true;
        }
        if (instruction.getLockPrefix()) {
            output.append("lock ");
        }
        if (hasNoTrackPrefix) {
            output.append("notrack ");
        }
        if (!hasXacquirePrefix) {
            if (instruction.getRepePrefix()) {
                if (FormatterUtils.isRepeOrRepneInstruction(code)) {
                    output.append("repe ");
                } else {
                    output.append("rep ");
                }
            }
            if (instruction.getRepnePrefix()) {
                if (391 <= code && code <= 396 || 691 <= code && code <= 696 || 757 <= code && code <= 759 || 763 <= code && code <= 765 || Code.isJccShortOrNear(code)) {
                    output.append("bnd ");
                } else {
                    output.append("repne ");
                }
            }
        }
        output.append(mnemonic);
        if (Integer.compareUnsigned(code - 1, 3) <= 0) {
            opCount = instruction.getDeclareDataCount();
            isDeclareData = true;
            switch (code) {
                case 1: {
                    declareDataOpKind = 6;
                    break;
                }
                case 2: {
                    declareDataOpKind = 8;
                    break;
                }
                case 3: {
                    declareDataOpKind = 9;
                    break;
                }
                default: {
                    assert (code == 4) : code;
                    declareDataOpKind = 10;
                    break;
                }
            }
        } else {
            isDeclareData = false;
            declareDataOpKind = 0;
        }
        if (opCount > 0) {
            int mvexRmOperand;
            output.append(' ');
            if (MvexInfo.isMvex(instruction.getCode())) {
                assert (opCount != 0) : opCount;
                mvexRmOperand = instruction.getOpKind(opCount - 1) == 6 ? opCount - 2 : opCount - 1;
            } else {
                mvexRmOperand = -1;
            }
            for (int operand = 0; operand < opCount; ++operand) {
                String[] tbl;
                String s;
                int conv;
                if (operand > 0) {
                    if (this.options.getSpaceAfterOperandSeparator()) {
                        output.append(", ");
                    } else {
                        output.append(',');
                    }
                }
                int opKind = isDeclareData ? declareDataOpKind : instruction.getOpKind(operand);
                switch (opKind) {
                    case 0: {
                        this.formatRegister(output, instruction.getOpRegister(operand));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        SymbolResult symbol;
                        long imm64;
                        int immSize;
                        if (opKind == 3) {
                            immSize = 8;
                            imm64 = instruction.getNearBranch64();
                        } else if (opKind == 2) {
                            immSize = 4;
                            imm64 = (long)instruction.getNearBranch32() & 0xFFFFFFFFL;
                        } else {
                            immSize = 2;
                            imm64 = instruction.getNearBranch16() & 0xFFFF;
                        }
                        if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, operand, imm64, immSize)) != null) {
                            this.writeSymbol(output, imm64, symbol);
                            break;
                        }
                        this.formatNumber(output, imm64);
                        break;
                    }
                    case 4: 
                    case 5: {
                        SymbolResult symbol;
                        long imm64;
                        int immSize;
                        if (opKind == 5) {
                            immSize = 4;
                            imm64 = (long)instruction.getFarBranch32() & 0xFFFFFFFFL;
                        } else {
                            immSize = 2;
                            imm64 = instruction.getFarBranch16() & 0xFFFF;
                        }
                        if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, operand, imm64, immSize)) != null) {
                            assert (operand + 1 == 1) : operand;
                            SymbolResult selectorSymbol = this.symbolResolver.getSymbol(instruction, operand + 1, operand, instruction.getFarBranchSelector() & 0xFFFF, 2);
                            if (selectorSymbol == null) {
                                this.formatNumber(output, instruction.getFarBranchSelector() & 0xFFFF);
                            } else {
                                this.writeSymbol(output, instruction.getFarBranchSelector() & 0xFFFF, selectorSymbol);
                            }
                            output.append(':');
                            this.writeSymbol(output, imm64, symbol);
                            break;
                        }
                        this.formatNumber(output, instruction.getFarBranchSelector() & 0xFFFF);
                        output.append(':');
                        if (opKind == 5) {
                            this.formatNumber(output, (long)instruction.getFarBranch32() & 0xFFFFFFFFL);
                            break;
                        }
                        this.formatNumber(output, instruction.getFarBranch16() & 0xFFFF);
                        break;
                    }
                    case 6: 
                    case 7: {
                        byte imm8;
                        SymbolResult symbol;
                        if (isDeclareData) {
                            imm8 = instruction.getDeclareByteValue(operand);
                        } else if (opKind == 6) {
                            imm8 = instruction.getImmediate8();
                        } else {
                            assert (opKind == 7) : opKind;
                            imm8 = instruction.getImmediate8_2nd();
                        }
                        if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, operand, imm8 & 0xFF, 1)) != null) {
                            if ((symbol.flags & 1) == 0) {
                                output.append("offset ");
                            }
                            this.writeSymbol(output, imm8 & 0xFF, symbol);
                            break;
                        }
                        this.formatNumber(output, imm8 & 0xFF);
                        break;
                    }
                    case 8: 
                    case 11: {
                        short imm16;
                        SymbolResult symbol;
                        if (isDeclareData) {
                            imm16 = instruction.getDeclareWordValue(operand);
                        } else if (opKind == 8) {
                            imm16 = instruction.getImmediate16();
                        } else {
                            assert (opKind == 11) : opKind;
                            imm16 = instruction.getImmediate8to16();
                        }
                        if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, operand, imm16 & 0xFFFF, 2)) != null) {
                            if ((symbol.flags & 1) == 0) {
                                output.append("offset ");
                            }
                            this.writeSymbol(output, imm16 & 0xFFFF, symbol);
                            break;
                        }
                        this.formatNumber(output, imm16 & 0xFFFF);
                        break;
                    }
                    case 9: 
                    case 12: {
                        int imm32;
                        SymbolResult symbol;
                        if (isDeclareData) {
                            imm32 = instruction.getDeclareDwordValue(operand);
                        } else if (opKind == 9) {
                            imm32 = instruction.getImmediate32();
                        } else {
                            assert (opKind == 12) : opKind;
                            imm32 = instruction.getImmediate8to32();
                        }
                        if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, operand, (long)imm32 & 0xFFFFFFFFL, 4)) != null) {
                            if ((symbol.flags & 1) == 0) {
                                output.append("offset ");
                            }
                            this.writeSymbol(output, (long)imm32 & 0xFFFFFFFFL, symbol);
                            break;
                        }
                        this.formatNumber(output, (long)imm32 & 0xFFFFFFFFL);
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 14: {
                        SymbolResult symbol;
                        long imm64;
                        if (isDeclareData) {
                            imm64 = instruction.getDeclareQwordValue(operand);
                        } else if (opKind == 14) {
                            imm64 = instruction.getImmediate32to64();
                        } else if (opKind == 13) {
                            imm64 = instruction.getImmediate8to64();
                        } else {
                            assert (opKind == 10) : opKind;
                            imm64 = instruction.getImmediate64();
                        }
                        if (this.symbolResolver != null && (symbol = this.symbolResolver.getSymbol(instruction, operand, operand, imm64, 8)) != null) {
                            if ((symbol.flags & 1) == 0) {
                                output.append("offset ");
                            }
                            this.writeSymbol(output, imm64, symbol);
                            break;
                        }
                        this.formatNumber(output, imm64);
                        break;
                    }
                    case 15: {
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), 27, 0, 0, 0, 0L, 2);
                        break;
                    }
                    case 16: {
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), 43, 0, 0, 0, 0L, 4);
                        break;
                    }
                    case 17: {
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), 59, 0, 0, 0, 0L, 8);
                        break;
                    }
                    case 18: {
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), 28, 0, 0, 0, 0L, 2);
                        break;
                    }
                    case 19: {
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), 44, 0, 0, 0, 0L, 4);
                        break;
                    }
                    case 20: {
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), 60, 0, 0, 0, 0L, 8);
                        break;
                    }
                    case 21: {
                        this.formatMemory(output, instruction, operand, 71, 28, 0, 0, 0, 0L, 2);
                        break;
                    }
                    case 22: {
                        this.formatMemory(output, instruction, operand, 71, 44, 0, 0, 0, 0L, 4);
                        break;
                    }
                    case 23: {
                        this.formatMemory(output, instruction, operand, 71, 60, 0, 0, 0, 0L, 8);
                        break;
                    }
                    case 24: {
                        int displSize = instruction.getMemoryDisplSize();
                        int baseReg = instruction.getMemoryBase();
                        int indexReg = instruction.getMemoryIndex();
                        int addrSize = InternalInstructionUtils.getAddressSizeInBytes(baseReg, indexReg, displSize, instruction.getCodeSize());
                        long displ = addrSize == 8 ? instruction.getMemoryDisplacement64() : (long)instruction.getMemoryDisplacement32() & 0xFFFFFFFFL;
                        if (code == 493) {
                            indexReg = 0;
                        }
                        this.formatMemory(output, instruction, operand, instruction.getMemorySegment(), baseReg, indexReg, instruction.getRawMemoryIndexScale(), displSize, displ, addrSize);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                if (operand == 0 && (instruction.hasOpMask() || instruction.getZeroingMasking())) {
                    if (instruction.hasOpMask()) {
                        output.append('{');
                        this.formatRegister(output, instruction.getOpMask());
                        output.append('}');
                    }
                    if (instruction.getZeroingMasking()) {
                        output.append("{z}");
                    }
                }
                if (mvexRmOperand != operand || (conv = instruction.getMvexRegMemConv()) == 0 || MvexInfo.getConvFn(instruction.getCode()) == 0 || (s = (tbl = MvexInfo.isConvFn32(instruction.getCode()) ? this.mvexRegMemConsts32 : this.mvexRegMemConsts64)[conv]).length() == 0) continue;
                output.append(s);
            }
            int rc = instruction.getRoundingControl();
            if (rc != 0) {
                if (MvexInfo.isMvex(instruction.getCode()) && !instruction.getSuppressAllExceptions()) {
                    output.append(this.rcStrings[rc - 1]);
                } else {
                    output.append(this.rcSaeStrings[rc - 1]);
                }
            } else if (instruction.getSuppressAllExceptions()) {
                output.append("{sae}");
            }
        }
    }

    private static boolean showSegmentPrefix(Instruction instruction, int opCount) {
        block4: for (int i = 0; i < opCount; ++i) {
            switch (instruction.getOpKind(i)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    continue block4;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 24: {
                    return false;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return true;
    }

    private void formatRegister(FastStringOutput output, int register) {
        output.append(this.allRegisters[register].getLower());
    }

    private void formatNumber(FastStringOutput output, long value) {
        boolean useHexPrefix = this.options.getUseHexPrefix();
        if (useHexPrefix) {
            output.append("0x");
        }
        int shift = 0;
        long tmp = value;
        do {
            shift += 4;
        } while ((tmp >>>= 4) != 0L);
        if (!useHexPrefix && (int)(value >>> shift - 4 & 0xFL) > 9) {
            output.append('0');
        }
        String hexDigits = this.options.getUppercaseHex() ? "0123456789ABCDEF" : "0123456789abcdef";
        do {
            int digit = (int)(value >>> (shift -= 4)) & 0xF;
            output.append(hexDigits.charAt(digit));
        } while (shift != 0);
        if (!useHexPrefix) {
            output.append('h');
        }
    }

    private void writeSymbol(FastStringOutput output, long address, SymbolResult symbol) {
        this.writeSymbol(output, address, symbol, true);
    }

    private void writeSymbol(FastStringOutput output, long address, SymbolResult symbol, boolean writeMinusIfSigned) {
        long displ = address - symbol.address;
        if ((symbol.flags & 2) != 0) {
            if (writeMinusIfSigned) {
                output.append('-');
            }
            displ = -displ;
        }
        TextInfo text = symbol.text;
        TextPart[] array = text.textArray;
        if (array != null) {
            for (TextPart part : array) {
                if (part.text == null) continue;
                output.append(part.text);
            }
        } else if (text.text != null) {
            output.append(text.text.text);
        }
        if (displ != 0L) {
            if (displ < 0L) {
                output.append('-');
                displ = -displ;
            } else {
                output.append('+');
            }
            this.formatNumber(output, displ);
        }
        if (this.options.getShowSymbolAddress()) {
            output.append(" (");
            this.formatNumber(output, address);
            output.append(')');
        }
    }

    private void formatMemory(FastStringOutput output, Instruction instruction, int operand, int segReg, int baseReg, int indexReg, int scale, int displSize, long displ, int addrSize) {
        boolean noTrackPrefix;
        byte flags;
        boolean showMemSize;
        boolean useScale;
        long absAddr;
        assert (Integer.compareUnsigned(scale, this.scaleNumbers.length) < 0);
        assert (InternalInstructionUtils.getAddressSizeInBytes(baseReg, indexReg, displSize, instruction.getCodeSize()) == addrSize) : addrSize;
        if (baseReg == 70) {
            absAddr = displ;
            if (this.options.getRipRelativeAddresses()) {
                displ -= instruction.getNextIP();
            } else {
                assert (indexReg == 0) : indexReg;
                baseReg = 0;
            }
            displSize = 8;
        } else if (baseReg == 69) {
            absAddr = displ & 0xFFFFFFFFL;
            if (this.options.getRipRelativeAddresses()) {
                displ = (int)displ - instruction.getNextIP32();
            } else {
                assert (indexReg == 0) : indexReg;
                baseReg = 0;
            }
            displSize = 4;
        } else {
            absAddr = displ;
        }
        SymbolResult symbol = this.symbolResolver != null ? this.symbolResolver.getSymbol(instruction, operand, operand, absAddr, addrSize) : null;
        boolean bl = useScale = scale != 0;
        if (!useScale && baseReg == 0) {
            useScale = true;
        }
        if (addrSize == 2) {
            useScale = false;
        }
        boolean bl2 = showMemSize = ((flags = this.codeFlags[instruction.getCode()]) & 4) != 0 || instruction.getBroadcast() || this.options.getAlwaysShowMemorySize();
        if (showMemSize) {
            assert (Integer.compareUnsigned(instruction.getMemorySize(), this.allMemorySizes.length) < 0);
            String keywords = this.allMemorySizes[instruction.getMemorySize()];
            output.append(keywords);
        }
        int codeSize = instruction.getCodeSize();
        int segOverride = instruction.getSegmentPrefix();
        boolean bl3 = noTrackPrefix = segOverride == 74 && FormatterUtils.isNotrackPrefixBranch(instruction.getCode()) && (codeSize != 1 && codeSize != 2 || baseReg != 26 && baseReg != 42 && baseReg != 41);
        if (this.options.getAlwaysShowSegmentRegister() || segOverride != 0 && !noTrackPrefix) {
            this.formatRegister(output, segReg);
            output.append(':');
        }
        output.append('[');
        boolean needPlus = false;
        if (baseReg != 0) {
            this.formatRegister(output, baseReg);
            needPlus = true;
        }
        if (indexReg != 0) {
            if (needPlus) {
                output.append('+');
            }
            needPlus = true;
            this.formatRegister(output, indexReg);
            if (useScale) {
                output.append(this.scaleNumbers[scale]);
            }
        }
        if (symbol != null) {
            if (needPlus) {
                if ((symbol.flags & 2) != 0) {
                    output.append('-');
                } else {
                    output.append('+');
                }
            } else if ((symbol.flags & 2) != 0) {
                output.append('-');
            }
            this.writeSymbol(output, absAddr, symbol, false);
        } else if (!needPlus || displSize != 0 && displ != 0L) {
            if (needPlus) {
                if (addrSize == 8) {
                    if (displ < 0L) {
                        displ = -displ;
                        output.append('-');
                    } else {
                        output.append('+');
                    }
                } else if (addrSize == 4) {
                    if ((int)displ < 0) {
                        displ = (long)(-((int)displ)) & 0xFFFFFFFFL;
                        output.append('-');
                    } else {
                        output.append('+');
                    }
                } else {
                    assert (addrSize == 2) : addrSize;
                    if ((short)displ < 0) {
                        displ = -((short)displ) & 0xFFFF;
                        output.append('-');
                    } else {
                        output.append('+');
                    }
                }
            }
            this.formatNumber(output, displ);
        }
        output.append(']');
        if (instruction.getMvexEvictionHint()) {
            output.append("{eh}");
        }
    }
}

