/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt;

import com.github.icedland.iced.x86.fmt.TextInfo;

public final class SymbolResult {
    private static final int DEFAULT_KIND = 14;
    public final long address;
    public final TextInfo text;
    public final int flags;
    public final int symbolSize;

    public boolean hasSymbolSize() {
        return (this.flags & 4) != 0;
    }

    public SymbolResult(long address, String text) {
        this.address = address;
        this.text = new TextInfo(text, 14);
        this.flags = 0;
        this.symbolSize = 0;
    }

    public SymbolResult(long address, String text, int size) {
        this.address = address;
        this.text = new TextInfo(text, 14);
        this.flags = 4;
        this.symbolSize = size;
    }

    public SymbolResult(long address, String text, int color, int flags) {
        this.address = address;
        this.text = new TextInfo(text, color);
        this.flags = flags & 0xFFFFFFFB;
        this.symbolSize = 0;
    }

    public SymbolResult(long address, TextInfo text) {
        this.address = address;
        this.text = text;
        this.flags = 0;
        this.symbolSize = 0;
    }

    public SymbolResult(long address, TextInfo text, int size) {
        this.address = address;
        this.text = text;
        this.flags = 4;
        this.symbolSize = size;
    }

    public SymbolResult(long address, TextInfo text, int flags, boolean ignored) {
        this.address = address;
        this.text = text;
        this.flags = flags & 0xFFFFFFFB;
        this.symbolSize = 0;
    }

    public SymbolResult(long address, TextInfo text, int flags, int size) {
        this.address = address;
        this.text = text;
        this.flags = flags | 4;
        this.symbolSize = size;
    }
}

